/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractViewActionDelegate
extends ActionDelegate
implements IViewActionDelegate,
INullSelectionListener,
IDebugEventSetListener {
    private IAction fAction;
    private IDebugView fView;
    private IStructuredSelection fSelection = StructuredSelection.EMPTY;

    public void init(IViewPart view) {
        IAdaptable context;
        this.setView(view);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        IWorkbenchWindow window = this.getWindow();
        if (window != null) {
            window.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        StructuredSelection ss = (context = DebugUITools.getDebugContext()) != null ? new StructuredSelection((Object)context) : StructuredSelection.EMPTY;
        this.selectionChanged((IWorkbenchPart)null, (ISelection)ss);
    }

    public void dispose() {
        IWorkbenchWindow window = this.getWindow();
        if (window != null) {
            window.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }

    public void init(IAction action) {
        this.setAction(action);
        action.setEnabled(false);
        super.init(action);
    }

    protected IDebugView getView() {
        return this.fView;
    }

    private void setView(IViewPart view) {
        this.fView = view instanceof IDebugView ? (IDebugView)view : null;
    }

    public void run(IAction action) {
        MultiStatus ms = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, "", null);
        BusyIndicator.showWhile((Display)Display.getCurrent(), () -> {
            try {
                this.doAction();
            }
            catch (DebugException e) {
                ms.merge(e.getStatus());
            }
        });
        if (!ms.isOK()) {
            IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                CDebugUIPlugin.errorDialog(this.getErrorDialogMessage(), ms.getChildren()[0]);
            } else {
                CDebugUIPlugin.log((IStatus)ms);
            }
        }
    }

    protected IAction getAction() {
        return this.fAction;
    }

    private void setAction(IAction action) {
        this.fAction = action;
    }

    private IWorkbenchWindow getWindow() {
        if (this.getView() != null) {
            return this.getView().getViewSite().getWorkbenchWindow();
        }
        return null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.setSelection(selection);
        this.update();
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected void setSelection(ISelection selection) {
        this.fSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.getWindow() == null || this.getAction() == null) {
            return;
        }
        Shell shell = this.getWindow().getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Runnable r = () -> {
            int i = 0;
            while (i < events.length) {
                if (events[i].getSource() != null) {
                    this.doHandleDebugEvent(events[i]);
                }
                ++i;
            }
        };
        shell.getDisplay().asyncExec(r);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
        this.update();
    }

    protected abstract String getErrorDialogTitle();

    protected abstract String getErrorDialogMessage();

    protected abstract void doAction() throws DebugException;

    protected abstract void update();

    protected abstract void doHandleDebugEvent(DebugEvent var1);
}

