/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.filepath.settings;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.lemminx.extensions.filepath.SimpleFilePathExpression;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.xpath.matcher.XPathMatcher;
import org.w3c.dom.Node;

public class FilePathExpression
extends SimpleFilePathExpression {
    private transient XPathMatcher pathMatcher;
    private String xpath;
    private Character separator;
    private List<String> filter;

    public FilePathExpression() {
        this(null);
    }

    public FilePathExpression(String xpath) {
        this.setXPath(xpath);
    }

    public String getXPath() {
        return this.xpath;
    }

    @Override
    public Character getSeparator() {
        return this.separator;
    }

    public List<String> getFilter() {
        return this.filter;
    }

    public FilePathExpression setXPath(String xpath) {
        this.xpath = xpath;
        return this;
    }

    public FilePathExpression setSeparator(Character separator) {
        this.separator = separator;
        return this;
    }

    public FilePathExpression setFilter(List<String> filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public boolean match(Node node) {
        if (this.xpath == null) {
            return false;
        }
        if (this.pathMatcher == null) {
            this.pathMatcher = new XPathMatcher(this.xpath);
        }
        return this.pathMatcher.match(node);
    }

    @Override
    protected boolean acceptFile(Path path) {
        if (this.filter == null || this.filter.isEmpty()) {
            return true;
        }
        String fileName = FilesUtils.getFileName(path);
        for (String fileExtension : this.filter) {
            if (!fileName.endsWith(fileExtension)) continue;
            return true;
        }
        return false;
    }
}

