/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.bcoview.ui;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class EclipseUtils {
    private EclipseUtils() {
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static IJavaElement getJavaInput(IEditorPart part) {
        IJavaElement input = (IJavaElement)part.getAdapter(IJavaElement.class);
        if (input != null) {
            return input;
        }
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput != null) {
            input = (IJavaElement)editorInput.getAdapter(IJavaElement.class);
        }
        if (input != null) {
            return input;
        }
        input = EditorUtility.getEditorInputJavaElement((IEditorPart)part, (boolean)false);
        return input;
    }

    public static void selectInEditor(ITextEditor editor, int offset, int length) {
        IEditorPart active = EclipseUtils.getActiveEditor();
        if (active != editor) {
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
        }
        editor.selectAndReveal(offset, length);
    }

    public static ITextSelection getSelection(ISelectionProvider selectionProvider) {
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    public static String getJavaPackageName(IJavaElement resource) {
        if (resource == null) {
            return "";
        }
        String name = resource.getElementName();
        if (name == null) {
            return "";
        }
        int type = resource.getElementType();
        if (type == 4 || type == 3) {
            return name;
        }
        IJavaElement ancestor = resource.getAncestor(4);
        if (ancestor != null) {
            return ancestor.getElementName();
        }
        return "";
    }
}

