/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.handlers;

import java.io.File;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenBundleResourceHandler
extends AbstractHandler {
    private static final String PARAM_ID_PLUGIN = "plugin";
    private static final String PARAM_ID_PATH = "path";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        URL url;
        String pluginId = event.getParameter(PARAM_ID_PLUGIN);
        String pluginPath = event.getParameter(PARAM_ID_PATH);
        Object errorMessage = "";
        if (pluginId == null || pluginPath == null) {
            url = null;
        } else {
            try {
                File workspaceFile;
                if (pluginPath.startsWith("/")) {
                    pluginPath = pluginPath.substring(1);
                }
                if (!(workspaceFile = new File((url = new URL(Platform.getInstanceLocation().getURL().toString() + pluginId + "/" + pluginPath)).getFile())).exists() && (url = BaseHelpSystem.resolve((String)("/" + pluginId + "/" + pluginPath), (boolean)true)) == null) {
                    errorMessage = "file not found:" + pluginId + "/" + pluginPath;
                    throw new ExecutionException((String)errorMessage);
                }
            }
            catch (Exception ex) {
                throw new ExecutionException((String)errorMessage, (Throwable)ex);
            }
        }
        String browserId = pluginId + "." + pluginPath;
        try {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(browserId);
            browser.openURL(url);
        }
        catch (PartInitException ex) {
            throw new ExecutionException("error opening browser", (Throwable)ex);
        }
        return null;
    }
}

