/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ICommentContainer;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsFactory;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsPackage;

public abstract class CommentContainer
extends EObjectImpl
implements ICommentContainer {
    protected EList<IComment> comments;

    protected CommentContainer() {
    }

    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.COMMENT_CONTAINER;
    }

    @Override
    public List<IComment> getAllComments() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IComment> getComments() {
        if (this.comments == null) {
            this.comments = new EObjectContainmentWithInverseEList.Resolving(IComment.class, (InternalEObject)this, 1, 11);
        }
        return this.comments;
    }

    @Override
    public List<IComment> getAllDrafts() {
        ArrayList<IComment> drafts = new ArrayList<IComment>(this.getComments());
        for (IComment comment : this.getAllComments()) {
            if (!comment.isDraft()) continue;
            drafts.add(comment);
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)ReviewsPackage.Literals.COMMENT_CONTAINER__ALL_DRAFTS, drafts.size(), drafts.toArray());
    }

    @Override
    public List<IComment> getDrafts() {
        ArrayList<IComment> drafts = new ArrayList<IComment>(this.getComments());
        for (IComment comment : this.getComments()) {
            if (!comment.isDraft()) continue;
            drafts.add(comment);
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)ReviewsPackage.Literals.COMMENT_CONTAINER__DRAFTS, drafts.size(), drafts.toArray());
    }

    @Override
    public IComment createComment(ILocation initalLocation, String commentText) {
        IComment comment = ReviewsFactory.eINSTANCE.createComment();
        comment.setDescription(commentText);
        comment.setDraft(true);
        Date created = new Date();
        comment.setCreationDate(created);
        if (initalLocation != null) {
            comment.getLocations().add(initalLocation);
        }
        this.getComments().add(comment);
        return comment;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getComments()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getDrafts()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAllComments();
            }
            case 1: {
                return this.getComments();
            }
            case 2: {
                return this.getAllDrafts();
            }
            case 3: {
                return this.getDrafts();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getComments().clear();
                this.getComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getDrafts().clear();
                this.getDrafts().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getComments().clear();
                return;
            }
            case 3: {
                this.getDrafts().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return !this.getAllComments().isEmpty();
            }
            case 1: {
                return this.comments != null && !this.comments.isEmpty();
            }
            case 2: {
                return !this.getAllDrafts().isEmpty();
            }
            case 3: {
                return !this.getDrafts().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

