/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ResourceChangeToNonScriptDelta;
import org.eclipse.dltk.internal.core.SimpleDelta;

public class ModelElementDelta
extends SimpleDelta
implements IModelElementDelta {
    protected static final IModelElementDelta[] EMPTY_DELTA = new IModelElementDelta[0];
    protected IModelElementDelta[] affectedChildren = EMPTY_DELTA;
    protected IModelElement changedElement;
    protected IResourceDelta[] resourceDeltas = null;
    protected int resourceDeltasCounter;
    protected IModelElement movedFromHandle = null;
    protected IModelElement movedToHandle = null;

    public ModelElementDelta(IModelElement element) {
        this.changedElement = element;
    }

    public void added(IModelElement element) {
        this.added(element, 0);
    }

    public void added(IModelElement element, int flags) {
        ModelElementDelta addedDelta = new ModelElementDelta(element);
        addedDelta.added();
        addedDelta.changeFlags |= flags;
        this.insertDeltaTree(element, addedDelta);
    }

    public void removed(IModelElement element) {
        this.removed(element, 0);
    }

    public void removed(IModelElement element, int flags) {
        ModelElementDelta removedDelta = new ModelElementDelta(element);
        this.insertDeltaTree(element, removedDelta);
        ModelElementDelta actualDelta = this.getDeltaFor(element);
        if (actualDelta != null) {
            actualDelta.removed();
            actualDelta.changeFlags |= flags;
            actualDelta.affectedChildren = EMPTY_DELTA;
        }
    }

    protected ModelElementDelta getDeltaFor(IModelElement element) {
        if (this.equalsAndSameParent(this.getElement(), element)) {
            return this;
        }
        if (this.affectedChildren.length == 0) {
            return null;
        }
        int childrenCount = this.affectedChildren.length;
        int i = 0;
        while (i < childrenCount) {
            ModelElementDelta delta = (ModelElementDelta)this.affectedChildren[i];
            if (this.equalsAndSameParent(delta.getElement(), element)) {
                return delta;
            }
            if ((delta = delta.getDeltaFor(element)) != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    protected void addAffectedChild(ModelElementDelta child) {
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.changeFlags |= 8;
                break;
            }
            default: {
                this.kind = 4;
                this.changeFlags |= 8;
            }
        }
        if (this.changedElement.getElementType() >= 5) {
            this.fineGrained();
        }
        if (this.affectedChildren == null || this.affectedChildren.length == 0) {
            this.affectedChildren = new IModelElementDelta[]{child};
            return;
        }
        SimpleDelta existingChild = null;
        int existingChildIndex = -1;
        if (this.affectedChildren != null) {
            int i = 0;
            while (i < this.affectedChildren.length) {
                if (this.equalsAndSameParent(this.affectedChildren[i].getElement(), child.getElement())) {
                    existingChild = (ModelElementDelta)this.affectedChildren[i];
                    existingChildIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (existingChild == null) {
            this.affectedChildren = this.growAndAddToArray(this.affectedChildren, child);
        } else {
            switch (existingChild.getKind()) {
                case 1: {
                    switch (child.getKind()) {
                        case 1: 
                        case 4: {
                            return;
                        }
                        case 2: {
                            this.affectedChildren = this.removeAndShrinkArray(this.affectedChildren, existingChildIndex);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (child.getKind()) {
                        case 1: {
                            child.kind = 4;
                            this.affectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 2: 
                        case 4: {
                            return;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (child.getKind()) {
                        case 1: 
                        case 2: {
                            this.affectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 4: {
                            IResourceDelta[] resDeltas;
                            IModelElementDelta[] children = child.getAffectedChildren();
                            int i = 0;
                            while (i < children.length) {
                                ModelElementDelta childsChild = (ModelElementDelta)children[i];
                                ((ModelElementDelta)existingChild).addAffectedChild(childsChild);
                                ++i;
                            }
                            boolean childHadContentFlag = (child.changeFlags & 1) != 0;
                            boolean existingChildHadChildrenFlag = (((ModelElementDelta)existingChild).changeFlags & 8) != 0;
                            ((ModelElementDelta)existingChild).changeFlags |= child.changeFlags;
                            if (childHadContentFlag && existingChildHadChildrenFlag) {
                                ((ModelElementDelta)existingChild).changeFlags &= 0xFFFFFFFE;
                            }
                            if ((resDeltas = child.getResourceDeltas()) != null) {
                                ((ModelElementDelta)existingChild).resourceDeltas = resDeltas;
                                ((ModelElementDelta)existingChild).resourceDeltasCounter = child.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    int flags = existingChild.getFlags();
                    this.affectedChildren[existingChildIndex] = child;
                    child.changeFlags |= flags;
                }
            }
        }
    }

    @Override
    public IModelElement getElement() {
        return this.changedElement;
    }

    public ModelElementDelta changed(IModelElement element, int changeFlag) {
        ModelElementDelta changedDelta = new ModelElementDelta(element);
        changedDelta.changed(changeFlag);
        this.insertDeltaTree(element, changedDelta);
        return changedDelta;
    }

    protected void insertDeltaTree(IModelElement element, ModelElementDelta delta) {
        ModelElementDelta childDelta = this.createDeltaTree(element, delta);
        if (!this.equalsAndSameParent(element, this.getElement())) {
            this.addAffectedChild(childDelta);
        }
    }

    protected ModelElementDelta createDeltaTree(IModelElement element, ModelElementDelta delta) {
        ModelElementDelta childDelta = delta;
        ArrayList<IModelElement> ancestors = this.getAncestors(element);
        if (ancestors == null) {
            if (this.equalsAndSameParent(delta.getElement(), this.getElement())) {
                this.kind = delta.kind;
                this.changeFlags = delta.changeFlags;
                this.movedToHandle = delta.movedToHandle;
                this.movedFromHandle = delta.movedFromHandle;
            }
        } else {
            int i = 0;
            int size = ancestors.size();
            while (i < size) {
                IModelElement ancestor = ancestors.get(i);
                ModelElementDelta ancestorDelta = new ModelElementDelta(ancestor);
                ancestorDelta.addAffectedChild(childDelta);
                childDelta = ancestorDelta;
                ++i;
            }
        }
        return childDelta;
    }

    protected boolean equalsAndSameParent(IModelElement e1, IModelElement e2) {
        IModelElement parent1;
        return e1.equals(e2) && (parent1 = e1.getParent()) != null && parent1.equals(e2.getParent());
    }

    @Override
    public IModelElementDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    @Override
    public IModelElementDelta[] getAffectedChildren() {
        return this.affectedChildren;
    }

    private ArrayList<IModelElement> getAncestors(IModelElement element) {
        IModelElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<IModelElement> parents = new ArrayList<IModelElement>();
        while (!parent.equals(this.changedElement)) {
            parents.add(parent);
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        parents.trimToSize();
        return parents;
    }

    protected IModelElementDelta[] growAndAddToArray(IModelElementDelta[] array, IModelElementDelta addition) {
        IModelElementDelta[] old = array;
        array = new IModelElementDelta[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected IModelElementDelta[] removeAndShrinkArray(IModelElementDelta[] old, int index) {
        int rest;
        IModelElementDelta[] array = new IModelElementDelta[old.length - 1];
        if (index > 0) {
            System.arraycopy(old, 0, array, 0, index);
        }
        if ((rest = old.length - index - 1) > 0) {
            System.arraycopy(old, index + 1, array, index, rest);
        }
        return array;
    }

    public void fineGrained() {
        this.changed(16384);
    }

    @Override
    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return null;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    protected void removeAffectedChild(ModelElementDelta child) {
        int index = -1;
        if (this.affectedChildren != null) {
            int i = 0;
            while (i < this.affectedChildren.length) {
                if (this.equalsAndSameParent(this.affectedChildren[i].getElement(), child.getElement())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index >= 0) {
            this.affectedChildren = this.removeAndShrinkArray(this.affectedChildren, index);
        }
    }

    public void contentChanged() {
        this.changeFlags |= 1;
    }

    public void movedFrom(IModelElement movedFromElement, IModelElement movedToElement) {
        ModelElementDelta removedDelta = new ModelElementDelta(movedFromElement);
        removedDelta.kind = 2;
        removedDelta.changeFlags |= 0x20;
        removedDelta.movedToHandle = movedToElement;
        this.insertDeltaTree(movedFromElement, removedDelta);
    }

    public void movedTo(IModelElement movedToElement, IModelElement movedFromElement) {
        ModelElementDelta addedDelta = new ModelElementDelta(movedToElement);
        addedDelta.kind = 1;
        addedDelta.changeFlags |= 0x10;
        addedDelta.movedFromHandle = movedFromElement;
        this.insertDeltaTree(movedToElement, addedDelta);
    }

    protected void addResourceDelta(IResource resource) {
        this.addResourceDelta(new ResourceChangeToNonScriptDelta(resource));
    }

    protected void addResourceDelta(IResourceDelta child) {
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.changeFlags |= 1;
                break;
            }
            default: {
                this.kind = 4;
                this.changeFlags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = child;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = child;
    }

    protected ModelElementDelta find(IModelElement e) {
        if (this.equalsAndSameParent(this.changedElement, e)) {
            return this;
        }
        int i = 0;
        while (i < this.affectedChildren.length) {
            ModelElementDelta delta = ((ModelElementDelta)this.affectedChildren[i]).find(e);
            if (delta != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    public void closed(IModelElement element) {
        ModelElementDelta delta = new ModelElementDelta(element);
        delta.changed(1024);
        this.insertDeltaTree(element, delta);
    }

    public void opened(IModelElement element) {
        ModelElementDelta delta = new ModelElementDelta(element);
        delta.changed(512);
        this.insertDeltaTree(element, delta);
    }

    protected IModelElementDelta[] getChildrenOfType(int type) {
        int length = this.affectedChildren.length;
        if (length == 0) {
            return new IModelElementDelta[0];
        }
        ArrayList<IModelElementDelta> children = new ArrayList<IModelElementDelta>(length);
        int i = 0;
        while (i < length) {
            if (this.affectedChildren[i].getKind() == type) {
                children.add(this.affectedChildren[i]);
            }
            ++i;
        }
        IModelElementDelta[] childrenOfType = new IModelElementDelta[children.size()];
        children.toArray(childrenOfType);
        return childrenOfType;
    }

    @Override
    public IModelElement getMovedFromElement() {
        return this.movedFromHandle;
    }

    @Override
    public IModelElement getMovedToElement() {
        return this.movedToHandle;
    }

    public String toDebugString(int depth) {
        int i;
        StringBuilder buffer = new StringBuilder();
        int i2 = 0;
        while (i2 < depth) {
            buffer.append('\t');
            ++i2;
        }
        buffer.append(((ModelElement)this.getElement()).toDebugString());
        this.toDebugString(buffer);
        IModelElementDelta[] children = this.getAffectedChildren();
        if (children != null) {
            i = 0;
            while (i < children.length) {
                buffer.append("\n");
                buffer.append(((ModelElementDelta)children[i]).toDebugString(depth + 1));
                ++i;
            }
        }
        i = 0;
        while (i < this.resourceDeltasCounter) {
            buffer.append("\n");
            int j = 0;
            while (j < depth + 1) {
                buffer.append('\t');
                ++j;
            }
            IResourceDelta resourceDelta = this.resourceDeltas[i];
            buffer.append(resourceDelta.toString());
            buffer.append("[");
            switch (resourceDelta.getKind()) {
                case 1: {
                    buffer.append('+');
                    break;
                }
                case 2: {
                    buffer.append('-');
                    break;
                }
                case 4: {
                    buffer.append('*');
                    break;
                }
                default: {
                    buffer.append('?');
                }
            }
            buffer.append("]");
            ++i;
        }
        return buffer.toString();
    }

    @Override
    protected boolean toDebugString(StringBuilder buffer, int flags) {
        boolean prev = super.toDebugString(buffer, flags);
        if ((flags & 8) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CHILDREN");
            prev = true;
        }
        if ((flags & 1) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CONTENT");
            prev = true;
        }
        if ((flags & 0x10) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_FROM(" + ((ModelElement)this.getMovedFromElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((flags & 0x20) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_TO(" + ((ModelElement)this.getMovedToElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((flags & 0x40) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ADDED TO BUILDPATH");
            prev = true;
        }
        if ((flags & 0x80) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REMOVED FROM BUILDPATH");
            prev = true;
        }
        if ((flags & 0x100) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REORDERED");
            prev = true;
        }
        if ((flags & 0x8000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ARCHIVE CONTENT CHANGED");
            prev = true;
        }
        if ((flags & 0x4000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("FINE GRAINED");
            prev = true;
        }
        if ((flags & 0x10000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("PRIMARY WORKING COPY");
            prev = true;
        }
        if ((flags & 0x20000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("BUILDPATH CHANGED");
            prev = true;
        }
        if ((flags & 0x200000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("RESOLVED BUILDPATH CHANGED");
            prev = true;
        }
        if ((flags & 0x40000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("PRIMARY RESOURCE");
            prev = true;
        }
        if ((flags & 0x200) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("OPENED");
            prev = true;
        }
        if ((flags & 0x400) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CLOSED");
            prev = true;
        }
        return prev;
    }

    @Override
    public String toString() {
        return this.toDebugString(0);
    }
}

