/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.IChartObject;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ChartExtensionValueUpdater {
    private ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/trace");
    private static Set<String> hasVisibleElementSet = new HashSet<String>();
    private Map<String, EObject> defaultObjCache = new HashMap<String, EObject>();

    static {
        hasVisibleElementSet.add(LineAttributes.class.getSimpleName());
        hasVisibleElementSet.add(Marker.class.getSimpleName());
        hasVisibleElementSet.add(Label.class.getSimpleName());
        hasVisibleElementSet.add(Series.class.getSimpleName());
        hasVisibleElementSet.add(Block.class.getSimpleName());
        hasVisibleElementSet.add(ClientArea.class.getSimpleName());
    }

    static boolean contanisVisibleElement(EClass clazz) {
        boolean contains = hasVisibleElementSet.contains(clazz.getName());
        if (contains) {
            return true;
        }
        EList supers = clazz.getEAllSuperTypes();
        if (supers.size() > 0) {
            for (EClass eSuper : supers) {
                contains = hasVisibleElementSet.contains(eSuper.getName());
                if (!contains) continue;
                return true;
            }
        }
        return contains;
    }

    public static boolean isMapEntry(EClass eClass) {
        return eClass.getInstanceClass() == Map.Entry.class;
    }

    private void updateAttrs(EClass eClass, EObject eParentObj, EObject eObj, EObject eRef, EObject eDef) {
        LinkedList<EAttribute> listMany = new LinkedList<EAttribute>();
        LinkedList<EAttribute> list = new LinkedList<EAttribute>();
        for (EAttribute eAttr : eClass.getEAllAttributes()) {
            if (eAttr.isMany()) {
                listMany.add(eAttr);
                continue;
            }
            list.add(eAttr);
        }
        for (EAttribute eAttr : listMany) {
            List vList = (List)eObj.eGet((EStructuralFeature)eAttr);
            if (vList.size() != 0) continue;
            if (eRef != null && ((List)eRef.eGet((EStructuralFeature)eAttr)).size() > 0) {
                vList.addAll((List)eRef.eGet((EStructuralFeature)eAttr));
                continue;
            }
            if (eDef == null) continue;
            vList.addAll((List)eDef.eGet((EStructuralFeature)eAttr));
        }
        for (EAttribute eAttr : list) {
            Object val = eObj.eGet((EStructuralFeature)eAttr);
            if (eAttr.isUnsettable()) {
                if (eObj.eIsSet((EStructuralFeature)eAttr)) continue;
                if (eRef != null && eRef.eIsSet((EStructuralFeature)eAttr)) {
                    eObj.eSet((EStructuralFeature)eAttr, eRef.eGet((EStructuralFeature)eAttr));
                    continue;
                }
                if (eDef == null || !eDef.eIsSet((EStructuralFeature)eAttr)) continue;
                eObj.eSet((EStructuralFeature)eAttr, eDef.eGet((EStructuralFeature)eAttr));
                continue;
            }
            if (val != null) continue;
            if (eRef != null && eRef.eGet((EStructuralFeature)eAttr) != null) {
                eObj.eSet((EStructuralFeature)eAttr, eRef.eGet((EStructuralFeature)eAttr));
                continue;
            }
            if (eDef == null) continue;
            eObj.eSet((EStructuralFeature)eAttr, eDef.eGet((EStructuralFeature)eAttr));
        }
    }

    public void update(EClass expected, String name, EObject eParentObj, EObject eObj, EObject eRef, EObject eDef) {
        if (eObj == null) {
            if (eRef != null) {
                if (eRef instanceof IChartObject) {
                    eObj = ((IChartObject)eRef).copyInstance();
                    ChartElementUtil.setEObjectAttribute(eParentObj, name, eObj, false);
                }
            } else if (eDef != null && eDef instanceof IChartObject) {
                eObj = ((IChartObject)eDef).copyInstance();
                ChartElementUtil.setEObjectAttribute(eParentObj, name, eObj, false);
                return;
            }
        }
        if (eObj == null || eRef == null && eDef == null) {
            return;
        }
        if (ChartExtensionValueUpdater.contanisVisibleElement(eObj.eClass())) {
            if (eObj.eIsSet(eObj.eClass().getEStructuralFeature("visible"))) {
                if (eObj.eGet(eObj.eClass().getEStructuralFeature("visible")) != Boolean.TRUE) {
                    return;
                }
            } else if (eRef != null && eRef.eIsSet(eRef.eClass().getEStructuralFeature("visible"))) {
                if (eRef.eGet(eRef.eClass().getEStructuralFeature("visible")) != Boolean.TRUE) {
                    eObj.eSet(eRef.eClass().getEStructuralFeature("visible"), (Object)Boolean.FALSE);
                    return;
                }
            } else if (eDef != null && eDef.eIsSet(eDef.eClass().getEStructuralFeature("visible")) && eDef.eGet(eDef.eClass().getEStructuralFeature("visible")) != Boolean.TRUE) {
                eObj.eSet(eDef.eClass().getEStructuralFeature("visible"), (Object)Boolean.FALSE);
                return;
            }
        }
        EClass eClass = eObj.eClass();
        this.updateAttrs(eClass, eParentObj, eObj, eRef, eDef);
        for (EReference ref : eClass.getEAllReferences()) {
            String childName = ref.getName();
            Object child = eObj.eGet((EStructuralFeature)ref);
            Object refChild = eRef != null ? eRef.eGet((EStructuralFeature)ref) : null;
            Object defChild = eDef != null ? eDef.eGet((EStructuralFeature)ref) : null;
            EObject eChildParntObj = eObj;
            if (child == null) {
                if (refChild != null) {
                    if (refChild instanceof IChartObject) {
                        child = this.updateFromReference(childName, refChild, eChildParntObj);
                    }
                } else if (defChild != null && defChild instanceof IChartObject) {
                    child = ((IChartObject)defChild).copyInstance();
                    ChartElementUtil.setEObjectAttribute(eChildParntObj, childName, child, false);
                    continue;
                }
            }
            if (child == null) continue;
            if (ref.isMany()) {
                int size = ((List)child).size();
                int i = 0;
                while (i < size) {
                    Object item = ((List)child).get(i);
                    Object refItem = refChild == null || i >= ((List)refChild).size() ? null : ((List)refChild).get(i);
                    Object defItem = defChild == null || i >= ((List)defChild).size() ? null : ((List)defChild).get(i);
                    this.update(ref, eObj, (EObject)item, refItem, defItem);
                    ++i;
                }
                continue;
            }
            this.update(ref, eObj, (EObject)child, (EObject)refChild, (EObject)defChild);
        }
    }

    protected Object updateFromReference(String childName, Object refChild, EObject eChildParntObj) {
        IChartObject child = ((IChartObject)refChild).copyInstance();
        ChartElementUtil.setEObjectAttribute(eChildParntObj, childName, child, false);
        return child;
    }

    public EObject getDefault(EClass expected, String name, EObject eObj) {
        EObject def = this.defaultObjCache.get(eObj.getClass().getSimpleName());
        if (def != null) {
            return def;
        }
        try {
            Method m = eObj.getClass().getMethod("create", new Class[0]);
            EObject object = (EObject)m.invoke((Object)eObj, new Object[0]);
            this.defaultObjCache.put(eObj.getClass().getSimpleName(), object);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.log(e);
            return null;
        }
    }

    private void update(EReference ref, EObject eParentObj, EObject eObj, EObject eRef, EObject eDef) {
        if (eObj instanceof DataPointComponent) {
            eDef = ChartDefaultValueUtil.getPercentileDataPointDefObj((DataPointComponent)eObj, (DataPointComponent)eDef);
        }
        this.update(ref.getEReferenceType(), ref.getName(), eParentObj, eObj, eRef, eDef);
    }
}

