/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.base.ScriptStatusContext;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.ui.refactoring.TextStatusContextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ScriptStatusContextViewer
extends TextStatusContextViewer {
    protected SourceViewer createSourceViewer(Composite parent) {
        return new ScriptSourceViewer(parent, null, null, false, 33620738, null);
    }

    public void setInput(RefactoringStatusContext context) {
        if (context instanceof ScriptStatusContext) {
            ScriptStatusContext jsc = (ScriptStatusContext)context;
            IDocument document = null;
            ISourceModule cunit = jsc.getSourceModule();
            if (cunit.isWorkingCopy()) {
                try {
                    document = this.newScriptDocument(cunit);
                }
                catch (ModelException modelException) {}
            } else {
                FileEditorInput editorInput = new FileEditorInput((IFile)cunit.getResource());
                document = this.getDocument(DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider(), (IEditorInput)editorInput);
            }
            if (document == null) {
                document = new Document(RefactoringMessages.ScriptStatusContextViewer_no_source_available);
            }
            this.updateTitle((IAdaptable)cunit);
            this.setInput(document, ScriptStatusContextViewer.createRegion(jsc.getSourceRange()));
        }
    }

    private IDocument newScriptDocument(ISourceModule cu) throws ModelException {
        Document result = new Document(cu.getSource());
        IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((IModelElement)cu);
        toolkit.getTextTools().setupDocumentPartitioner((IDocument)result);
        ScriptSourceViewer viewer = (ScriptSourceViewer)this.getSourceViewer();
        viewer.setPreferenceStore(toolkit.getCombinedPreferenceStore());
        viewer.configure((SourceViewerConfiguration)toolkit.createSourceViewerConfiguration());
        return result;
    }

    private static IRegion createRegion(ISourceRange range) {
        return new Region(range.getOffset(), range.getLength());
    }

    private IDocument getDocument(IDocumentProvider provider, IEditorInput input) {
        if (input == null) {
            return null;
        }
        IDocument result = null;
        try {
            try {
                provider.connect((Object)input);
                result = provider.getDocument((Object)input);
            }
            catch (CoreException coreException) {
                provider.disconnect((Object)input);
            }
        }
        finally {
            provider.disconnect((Object)input);
        }
        return result;
    }
}

