/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import java.util.function.Function;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.ui.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.graphics.Point;

public abstract class HttpRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private boolean syncLabel = true;
    private boolean editingUrl = false;

    public HttpRepositorySettingsPage(String title, String description, TaskRepository taskRepository) {
        super(title, description, taskRepository);
        this.setHttpAuth(false);
        this.setNeedsAdvanced(false);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsTimeZone(false);
        this.setNeedsHttpAuth(false);
    }

    public boolean canValidate() {
        return this.isPageComplete() && (this.getMessage() == null || this.getMessageType() != 3);
    }

    private void syncRepositoryLabel(Function<RepositoryId, String> labelProvider) {
        String url;
        RepositoryId repo;
        if (this.syncLabel && (repo = GitHub.getRepository((String)(url = this.serverUrlCombo.getText()))) != null) {
            this.repositoryLabelEditor.setStringValue(labelProvider.apply(repo));
        }
    }

    protected void setInitialUrl(Function<RepositoryId, String> labelProvider) {
        String fullUrlText = "https://github.com/user/repository";
        this.serverUrlCombo.setText(fullUrlText);
        this.serverUrlCombo.setFocus();
        this.serverUrlCombo.setSelection(new Point("https://github.com".length() + 1, fullUrlText.length()));
        this.syncRepositoryLabel(labelProvider);
        this.serverUrlCombo.addModifyListener(e -> {
            this.editingUrl = true;
            try {
                this.syncRepositoryLabel(labelProvider);
            }
            finally {
                this.editingUrl = false;
            }
        });
        this.repositoryLabelEditor.getTextControl(this.compositeContainer).addModifyListener(e -> {
            if (!this.editingUrl) {
                this.syncLabel = false;
            }
        });
    }

    protected boolean useTokenChecked(TaskRepository taskRepository) {
        return super.useTokenChecked(taskRepository) || Boolean.parseBoolean(taskRepository.getProperty(GitHub.PROPERTY_USE_TOKEN));
    }

    protected String getSettingsPageEnterTokenText() {
        return Messages.HttpRepositorySettingsPage_EnterToken;
    }

    protected String getSettingsPageEnterUserAndTokenText() {
        return Messages.HttpRepositorySettingsPage_EnterUserAndToken;
    }

    protected String getSettingsPageGetUseLabelUseTokenText() {
        return Messages.HttpRepositorySettingsPage_LabelUseToken;
    }

    protected String getSettingsPageTooltipUseTokenText() {
        return Messages.HttpRepositorySettingsPage_TooltipUseToken;
    }

    protected String getSettingsPageLabelTokenText() {
        return Messages.HttpRepositorySettingsPage_LabelToken;
    }

    protected String getSettingsPageLabelSaveTokenText() {
        return Messages.HttpRepositorySettingsPage_LabelSaveToken;
    }
}

