/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.errorparsers.RegexErrorParser;
import org.eclipse.cdt.core.errorparsers.RegexErrorPattern;
import org.eclipse.cdt.internal.core.ProblemMarkerFilterManager;
import org.eclipse.cdt.internal.errorparsers.FixitManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class FixitErrorParser
extends RegexErrorParser {
    private static final Pattern fixit = Pattern.compile("fix-it:\"(.*)\":\\{(.*-.*)\\}:\"(.*)\"");

    public FixitErrorParser(String id, String name) {
        super(id, name);
    }

    public FixitErrorParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processLine(String line, ErrorParserManager epManager) {
        Matcher m = fixit.matcher(line);
        if (!m.matches()) return super.processLine(line, epManager);
        IProject project = null;
        IFile f = epManager.findFileName(m.group(1));
        if (f == null) return super.processLine(line, epManager);
        project = f.getProject();
        try {
            IMarker[] markers;
            ProblemMarkerInfo info = ProblemMarkerFilterManager.getInstance().getLastProblemMarker((IResource)f);
            String externalLocation = null;
            if (info.externalPath != null && !info.externalPath.isEmpty()) {
                externalLocation = info.externalPath.toOSString();
            }
            IMarker[] iMarkerArray = markers = f.findMarkers("org.eclipse.cdt.core.problem", true, 1);
            int n = markers.length;
            int n2 = 0;
            while (true) {
                String extloc;
                if (n2 >= n) {
                    return true;
                }
                IMarker marker = iMarkerArray[n2];
                int lineNumber = marker.getAttribute("lineNumber", -1);
                int sev = marker.getAttribute("severity", -1);
                String msg = (String)marker.getAttribute("message");
                if (lineNumber == info.lineNumber && sev == info.severity && msg.equals(info.description) && ((extloc = (String)marker.getAttribute("problem.externalLocation")) == null || extloc.equals(externalLocation))) {
                    if (project == null || project.equals((Object)info.file.getProject())) {
                        FixitManager.getInstance().addMarker(marker, m.group(2), m.group(3));
                        return true;
                    }
                    String source = (String)marker.getAttribute("sourceId");
                    if (project.getName().equals(source)) {
                        FixitManager.getInstance().addMarker(marker, m.group(2), m.group(3));
                        return true;
                    }
                }
                ++n2;
            }
        }
        catch (NumberFormatException | CoreException e) {
            CCorePlugin.log(e);
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FixitErrorParser that = new FixitErrorParser(this.getId(), this.getName());
        RegexErrorPattern[] regexErrorPatternArray = this.getPatterns();
        int n = regexErrorPatternArray.length;
        int n2 = 0;
        while (n2 < n) {
            RegexErrorPattern pattern = regexErrorPatternArray[n2];
            that.addPattern((RegexErrorPattern)pattern.clone());
            ++n2;
        }
        return that;
    }
}

