/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalNameOwner;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTName
extends ASTNode
implements IASTName,
IASTCompletionContext {
    private final char[] name;
    private static final String EMPTY_STRING = "";
    private IBinding binding;

    public CASTName(char[] name) {
        this.name = name;
    }

    public CASTName() {
        this.name = CharArrayUtils.EMPTY_CHAR_ARRAY;
    }

    @Override
    public CASTName copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTName copy(IASTNode.CopyStyle style) {
        CASTName copy = new CASTName(this.name == null ? null : (char[])this.name.clone());
        return this.copy(copy, style);
    }

    @Override
    public IBinding resolveBinding() {
        if (this.binding == null) {
            CVisitor.createBinding(this);
        }
        return this.binding;
    }

    @Override
    public IBinding resolvePreBinding() {
        return this.resolveBinding();
    }

    @Override
    public IBinding getBinding() {
        return this.binding;
    }

    @Override
    public IBinding getPreBinding() {
        return this.binding;
    }

    @Override
    public IASTCompletionContext getCompletionContext() {
        IASTNode node = this.getParent();
        while (node != null) {
            if (node instanceof IASTCompletionContext) {
                return (IASTCompletionContext)((Object)node);
            }
            node = node.getParent();
        }
        if (this.getLength() > 0) {
            return this;
        }
        return null;
    }

    @Override
    public void setBinding(IBinding binding) {
        this.binding = binding;
    }

    @Override
    public String toString() {
        if (this.name == CharArrayUtils.EMPTY_CHAR_ARRAY) {
            return EMPTY_STRING;
        }
        return new String(this.name);
    }

    @Override
    public char[] toCharArray() {
        return this.name;
    }

    @Override
    public char[] getSimpleID() {
        return this.name;
    }

    @Override
    public char[] getLookupKey() {
        return this.name;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleOfName(boolean allowResolution) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTInternalNameOwner) {
            return ((IASTInternalNameOwner)((Object)parent)).getRoleForName(this, allowResolution);
        }
        if (parent instanceof IASTNameOwner) {
            return ((IASTNameOwner)((Object)parent)).getRoleForName(this);
        }
        return 3;
    }

    @Override
    public boolean isDeclaration() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: 
                case 3: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isReference() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isDefinition() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 2: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier specifier = (IASTElaboratedTypeSpecifier)parent;
            int kind = specifier.getKind();
            switch (kind) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    return null;
                }
            }
            IBinding[] bindings = CVisitor.findBindingsForContentAssist(n, isPrefix);
            return this.filterByElaboratedTypeSpecifier(kind, bindings);
        }
        return null;
    }

    private IBinding[] filterByElaboratedTypeSpecifier(int kind, IBinding[] bindings) {
        int i = 0;
        while (i < bindings.length) {
            block10: {
                block9: {
                    if (!(bindings[i] instanceof ICompositeType)) break block9;
                    ICompositeType type = (ICompositeType)bindings[i];
                    switch (type.getKey()) {
                        case 1: {
                            if (kind != 1) {
                                bindings[i] = null;
                                break;
                            }
                            break block10;
                        }
                        case 2: {
                            if (kind == 2) break block10;
                            bindings[i] = null;
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block10;
                }
                bindings[i] = null;
            }
            ++i;
        }
        return ArrayUtil.removeNulls(bindings);
    }

    @Override
    public IASTName getLastName() {
        return this;
    }

    @Override
    public boolean isQualified() {
        return false;
    }
}

