/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.util.Optional;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.lsp.clangd.ClangdCompilationDatabaseProvider;
import org.eclipse.cdt.lsp.clangd.internal.config.MacroResolver;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=0"})
public class DefaultClangdCompilationDatabaseProvider
implements ClangdCompilationDatabaseProvider {
    protected static final String EMPTY = "";
    @Reference
    protected ICBuildConfigurationManager build;

    @Override
    public Optional<String> getCompilationDatabasePath(IResourceChangeEvent event, IProject project) {
        if (project != null) {
            return this.getConfiguration(project).map(bc -> {
                if (bc instanceof CBuildConfiguration) {
                    CBuildConfiguration cbc = (CBuildConfiguration)bc;
                    try {
                        IContainer container = cbc.getBuildContainer();
                        return container != null && container.exists() ? container : null;
                    }
                    catch (CoreException e) {
                        Platform.getLog(this.getClass()).log(e.getStatus());
                    }
                }
                return null;
            }).map(c -> c.getProjectRelativePath().toOSString());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getCompilationDatabasePath(CProjectDescriptionEvent event) {
        ICConfigurationDescription config;
        IPath cwdBuilder;
        if (event.getProject() != null && event.getNewCProjectDescription() != null && (cwdBuilder = (config = event.getNewCProjectDescription().getDefaultSettingConfiguration()).getBuildSetting().getBuilderCWD()) != null) {
            try {
                String cwdString = new MacroResolver().resolveValue(cwdBuilder.toOSString(), EMPTY, null, config);
                return Optional.ofNullable(event.getProject().getLocation()).map(loc -> loc.addTrailingSeparator().toOSString()).map(projectLoc -> cwdString.replace((CharSequence)projectLoc, EMPTY));
            }
            catch (CdtVariableException e) {
                Platform.getLog(this.getClass()).log(e.getStatus());
            }
        }
        return Optional.empty();
    }

    private Optional<ICBuildConfiguration> getConfiguration(IProject project) {
        try {
            return Optional.ofNullable(project.getActiveBuildConfig()).map(configuration -> {
                try {
                    return this.build.getBuildConfiguration(configuration);
                }
                catch (CoreException e) {
                    Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }
}

