/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import org.eclipse.cdt.lsp.clangd.ClangFormatFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ClangFormatMonitor
implements IPartListener2,
IWindowListener {
    private ClangFormatFile clangFormat;

    public ClangFormatMonitor start() {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            this.clangFormat = (ClangFormatFile)workbench.getService(ClangFormatFile.class);
            if (this.clangFormat == null) {
                Platform.getLog(this.getClass()).error("Cannot get ClangFormatFile service.");
                return this;
            }
            workbench.addWindowListener((IWindowListener)this);
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            int length = windows.length;
            while (i < length) {
                windows[i].getPartService().addPartListener((IPartListener2)this);
                ++i;
            }
        }
        return this;
    }

    public void stop() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.createClangFormatFile(partRef);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener2)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener2)this);
    }

    private void createClangFormatFile(IWorkbenchPartReference partRef) {
        if (this.isLspCEditor(partRef)) {
            IFile file = (IFile)partRef.getPage().getActiveEditor().getEditorInput().getAdapter(IFile.class);
            if (file == null) {
                return;
            }
            this.clangFormat.createClangFormatFile(file.getProject());
        }
    }

    private boolean isLspCEditor(IWorkbenchPartReference partRef) {
        return partRef != null ? "org.eclipse.cdt.lsp.CEditor".equals(partRef.getId()) : false;
    }
}

