/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ast;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class TclStatement
extends Statement {
    private List<ASTNode> expressions;

    public TclStatement(List<ASTNode> expressions) {
        if (!expressions.isEmpty()) {
            Expression first = (Expression)expressions.get(0);
            this.setStart(first.sourceStart());
            Expression last = (Expression)expressions.get(expressions.size() - 1);
            this.setEnd(last.sourceEnd());
        }
        this.expressions = expressions;
    }

    public List<ASTNode> getExpressions() {
        return this.expressions;
    }

    public Expression getAt(int index) {
        if (index >= 0 && index < this.expressions.size()) {
            return (Expression)this.expressions.get(index);
        }
        return null;
    }

    public int getCount() {
        return this.expressions.size();
    }

    public int getKind() {
        return 10001;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            if (this.expressions != null) {
                int exprSize = this.expressions.size();
                int i = 0;
                while (i < exprSize) {
                    ASTNode node = this.expressions.get(i);
                    node.traverse(visitor);
                    ++i;
                }
            }
            visitor.endvisit((Statement)this);
        }
    }

    public void printNode(CorePrinter output) {
        if (this.expressions != null) {
            output.formatPrintLn("");
            for (ASTNode node : this.expressions) {
                node.printNode(output);
                output.formatPrintLn(" ");
            }
        }
    }

    public String toString() {
        String value = "";
        if (this.expressions != null) {
            for (ASTNode node : this.expressions) {
                value = String.valueOf(value) + node.toString();
                value = String.valueOf(value) + " ";
            }
        }
        return value;
    }

    public void setExpressions(List<ASTNode> asList) {
        this.expressions = asList;
    }
}

