/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowAnalyzer;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowContext;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.ForInFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.GenericConditionalFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.GenericSequentialFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.util.Selection;
import org.eclipse.dltk.javascript.core.dom.ConditionalExpression;
import org.eclipse.dltk.javascript.core.dom.DoStatement;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.ForEachInStatement;
import org.eclipse.dltk.javascript.core.dom.ForInStatement;
import org.eclipse.dltk.javascript.core.dom.ForStatement;
import org.eclipse.dltk.javascript.core.dom.IfStatement;
import org.eclipse.dltk.javascript.core.dom.IterationStatement;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.ReturnStatement;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.dltk.javascript.core.dom.SwitchStatement;
import org.eclipse.dltk.javascript.core.dom.WhileStatement;
import org.eclipse.jface.text.IRegion;

public class InputFlowAnalyzer
extends FlowAnalyzer {
    private Selection fSelection;
    private boolean fDoLoopReentrance;
    private LoopReentranceVisitor fLoopReentranceVisitor;

    public InputFlowAnalyzer(FlowContext context, Selection selection, boolean doLoopReentrance) {
        super(context);
        this.fSelection = selection;
        Assert.isNotNull((Object)this.fSelection);
        this.fDoLoopReentrance = doLoopReentrance;
    }

    public FlowInfo perform(Node node) {
        this.traverse(node);
        return this.getFlowInfo(node);
    }

    @Override
    protected boolean isTraverseNeeded(Node node) {
        return node.getEnd() > this.fSelection.getExclusiveEnd();
    }

    @Override
    protected boolean createReturnFlowInfo(ReturnStatement node) {
        return node.getBegin() >= this.fSelection.getInclusiveEnd();
    }

    @Override
    protected void traverse(Node node) {
        if (this.isTraverseNeeded(node) && node instanceof IterationStatement) {
            this.createLoopReentranceVisitor(node);
        }
        super.traverse(node);
    }

    private void createLoopReentranceVisitor(Node node) {
        if (this.fLoopReentranceVisitor == null && this.fDoLoopReentrance && this.fSelection.coveredBy(node)) {
            this.fLoopReentranceVisitor = new LoopReentranceVisitor(this.fFlowContext, this.fSelection, node);
        }
    }

    @Override
    public Boolean caseConditionalExpression(ConditionalExpression node) {
        Expression thenPart = node.getConsequent();
        Expression elsePart = node.getAlternative();
        if (thenPart != null && this.fSelection.coveredBy(thenPart) || elsePart != null && this.fSelection.coveredBy(elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo(node, info);
            this.endVisitConditional(info, node.getPredicate(), new Node[]{thenPart, elsePart});
        } else {
            super.caseConditionalExpression(node);
        }
        return true;
    }

    @Override
    public Boolean caseDoStatement(DoStatement node) {
        super.caseDoStatement(node);
        this.handleLoopReentrance(node);
        return true;
    }

    @Override
    public Boolean caseIfStatement(IfStatement node) {
        Statement thenPart = node.getConsequent();
        Statement elsePart = node.getAlternative();
        if (thenPart != null && this.fSelection.coveredBy(thenPart) || elsePart != null && this.fSelection.coveredBy(elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo(node, info);
            this.endVisitConditional(info, node.getPredicate(), new Node[]{thenPart, elsePart});
        } else {
            super.caseIfStatement(node);
        }
        return true;
    }

    @Override
    public Boolean caseForInStatement(ForInStatement node) {
        super.caseForInStatement(node);
        this.handleLoopReentrance(node);
        return true;
    }

    @Override
    public Boolean caseForEachInStatement(ForEachInStatement node) {
        super.caseForEachInStatement(node);
        this.handleLoopReentrance(node);
        return true;
    }

    @Override
    public Boolean caseForStatement(ForStatement node) {
        super.caseForStatement(node);
        this.handleLoopReentrance(node);
        return true;
    }

    @Override
    public Boolean caseSwitchStatement(SwitchStatement node) {
        FlowAnalyzer.SwitchData data = this.createSwitchData(node);
        IRegion[] ranges = data.getRanges();
        int i = 0;
        while (i < ranges.length) {
            IRegion range = ranges[i];
            if (this.fSelection.coveredBy(range)) {
                GenericSequentialFlowInfo info = this.createSequential();
                this.setFlowInfo(node, info);
                info.merge(this.getFlowInfo(node.getSelector()), this.fFlowContext);
                info.merge(data.getInfo(i), this.fFlowContext);
                info.removeLabel(null);
                return true;
            }
            ++i;
        }
        super.caseSwitchStatement(node, data);
        return true;
    }

    @Override
    public Boolean caseWhileStatement(WhileStatement node) {
        super.caseWhileStatement(node);
        this.handleLoopReentrance(node);
        return true;
    }

    private void endVisitConditional(GenericSequentialFlowInfo info, Node condition, Node[] branches) {
        info.merge(this.getFlowInfo(condition), this.fFlowContext);
        int i = 0;
        while (i < branches.length) {
            Node branch = branches[i];
            if (branch != null && this.fSelection.coveredBy(branch)) {
                info.merge(this.getFlowInfo(branch), this.fFlowContext);
                break;
            }
            ++i;
        }
    }

    private void handleLoopReentrance(Node node) {
        if (this.fLoopReentranceVisitor == null || this.fLoopReentranceVisitor.getLoopNode() != node) {
            return;
        }
        this.fLoopReentranceVisitor.process(node);
        GenericSequentialFlowInfo info = this.createSequential();
        info.merge(this.getFlowInfo(node), this.fFlowContext);
        info.merge(this.fLoopReentranceVisitor.getFlowInfo(node), this.fFlowContext);
        this.setFlowInfo(node, info);
    }

    private static class LoopReentranceVisitor
    extends FlowAnalyzer {
        private Selection fSelection;
        private Node fLoopNode;

        public LoopReentranceVisitor(FlowContext context, Selection selection, Node loopNode) {
            super(context);
            this.fSelection = selection;
            this.fLoopNode = loopNode;
        }

        @Override
        protected boolean isTraverseNeeded(Node node) {
            return true;
        }

        @Override
        protected boolean createReturnFlowInfo(ReturnStatement node) {
            return node.getEnd() <= this.fSelection.getExclusiveEnd();
        }

        protected Node getLoopNode() {
            return this.fLoopNode;
        }

        public void process(Node node) {
            this.traverse(node);
        }

        @Override
        public Boolean caseDoStatement(DoStatement node) {
            DoWhileFlowInfo info = this.createDoWhile();
            this.setFlowInfo(node, info);
            info.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
            info.removeLabel(null);
            return true;
        }

        @Override
        public Boolean caseForInStatement(ForInStatement node) {
            FlowInfo paramInfo = this.getFlowInfo(node.getItem());
            FlowInfo expressionInfo = this.getFlowInfo(node.getCollection());
            FlowInfo actionInfo = this.getFlowInfo(node.getBody());
            this.processForIn(node, paramInfo, expressionInfo, actionInfo);
            return true;
        }

        @Override
        public Boolean caseForEachInStatement(ForEachInStatement node) {
            FlowInfo paramInfo = this.getFlowInfo(node.getItem());
            FlowInfo expressionInfo = this.getFlowInfo(node.getCollection());
            FlowInfo actionInfo = this.getFlowInfo(node.getBody());
            this.processForIn(node, paramInfo, expressionInfo, actionInfo);
            return true;
        }

        private void processForIn(Node node, FlowInfo paramInfo, FlowInfo expressionInfo, FlowInfo actionInfo) {
            ForInFlowInfo forInfo = this.createForIn();
            this.setFlowInfo(node, forInfo);
            if (node == this.fLoopNode) {
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                forInfo.mergeExpression(expressionInfo, this.fFlowContext);
                forInfo.mergeParameter(paramInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
        }

        @Override
        public Boolean caseForStatement(ForStatement node) {
            GenericSequentialFlowInfo initInfo = this.createSequential(node.getInitialization());
            FlowInfo conditionInfo = this.getFlowInfo(node.getCondition());
            GenericSequentialFlowInfo incrementInfo = this.createSequential(node.getIncrement());
            FlowInfo actionInfo = this.getFlowInfo(node.getBody());
            ForFlowInfo forInfo = this.createFor();
            this.setFlowInfo(node, forInfo);
            if (node == this.fLoopNode) {
                forInfo.mergeIncrement(incrementInfo, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                GenericConditionalFlowInfo initIncr = new GenericConditionalFlowInfo();
                initIncr.merge(initInfo, this.fFlowContext);
                initIncr.merge(incrementInfo, this.fFlowContext);
                forInfo.mergeAccessModeSequential(initIncr, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
            return true;
        }
    }
}

