/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.util.Map;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.javascript.internal.ui.text.JSDocAutoIndentStrategy;
import org.eclipse.dltk.javascript.internal.ui.text.JSDocDoubleClickStrategy;
import org.eclipse.dltk.javascript.internal.ui.text.JavaScriptScriptCommentScanner;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptAutoEditStrategy;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptCodeScanner;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptDocScanner;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptCompletionProcessor;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptContentAssistPreference;
import org.eclipse.dltk.javascript.ui.text.IJavaScriptPartitions;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.SingleTokenScriptScanner;
import org.eclipse.dltk.ui.text.TodoTaskPreferencesOnPreferenceStore;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.dltk.ui.text.spelling.SpellCheckDelegate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavascriptSourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private JavascriptCodeScanner fCodeScanner;
    private AbstractScriptScanner fStringScanner;
    private AbstractScriptScanner fCommentScanner;
    private JavascriptDocScanner fDocScanner;

    public JavascriptSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__javascript_doc".equals(contentType)) {
            return new JSDocDoubleClickStrategy(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return new DefaultTextDoubleClickStrategy(){

            protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
                int closing;
                int start = -1;
                int end = -1;
                String text = document.get();
                if (document instanceof IDocumentExtension3) {
                    try {
                        ITypedRegion region;
                        String contentType = ((IDocumentExtension3)document).getContentType("__javascript_partitioning", offset, true);
                        if (("__javascript_string_single".equals(contentType) || "__javascript_string_double".equals(contentType)) && (region = ((IDocumentExtension3)document).getPartition("__javascript_partitioning", offset, true)) != null && region.getLength() > 0) {
                            return new Region(region.getOffset() + 1, region.getLength() - 2);
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                    catch (BadPartitioningException ex) {
                        ex.printStackTrace();
                    }
                }
                if (offset > 0) {
                    char ch = text.charAt(offset - 1);
                    char closingChar = '\u0000';
                    if (ch == '(') {
                        closingChar = ')';
                    } else if (ch == '{') {
                        closingChar = '}';
                    } else if (ch == '[') {
                        closingChar = ']';
                    }
                    if (closingChar != '\u0000' && (closing = this.findClosing(text, offset, ch, closingChar, 1)) != -1) {
                        return new Region(offset, closing - offset);
                    }
                }
                if (offset >= text.length()) {
                    return null;
                }
                char ch = text.charAt(offset);
                char startChar = '\u0000';
                if (ch == ')') {
                    startChar = '(';
                } else if (ch == '}') {
                    startChar = '{';
                } else if (ch == ']') {
                    startChar = '[';
                }
                if (startChar != '\u0000' && (closing = this.findClosing(text, offset - 1, ch, startChar, -1)) != -1) {
                    return new Region(closing + 1, offset - closing - 1);
                }
                int i = offset;
                while (Character.isJavaIdentifierPart(text.charAt(i--))) {
                    if (i == -1) break;
                }
                start = i + 2;
                i = offset;
                while (Character.isJavaIdentifierPart(text.charAt(i++))) {
                    if (i == text.length()) break;
                }
                end = i - 1;
                return new Region(start, end - start);
            }

            private int findClosing(String text, int offset, char beginChar, char endChar, int next) {
                int skip = 0;
                int counter = offset;
                while (counter != -1 && counter < text.length()) {
                    char ch = text.charAt(counter);
                    if (ch == endChar) {
                        if (skip == 0) {
                            return counter;
                        }
                        --skip;
                    }
                    if (ch == beginChar) {
                        ++skip;
                    }
                    counter += next;
                }
                return -1;
            }
        };
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return IJavaScriptPartitions.JS_PARTITION_TYPES;
    }

    public String getCommentPrefix() {
        return "//";
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        JavaScriptCompletionProcessor scriptProcessor = new JavaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__dftl_partition_content_type");
        JavaScriptCompletionProcessor singleLineProcessor = new JavaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)singleLineProcessor, "__javascript_comment");
        JavaScriptCompletionProcessor stringProcessor = new JavaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_string_double");
        assistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__javascript_string_double");
        JavaScriptCompletionProcessor stringSingleProcessor = new JavaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_string_single");
        assistant.setContentAssistProcessor((IContentAssistProcessor)stringSingleProcessor, "__javascript_string_single");
        JavaScriptCompletionProcessor jsProcessor = new JavaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_doc");
        assistant.setContentAssistProcessor((IContentAssistProcessor)jsProcessor, "__javascript_doc");
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return JavaScriptContentAssistPreference.getDefault();
    }

    protected void initializeScanners() {
        this.fCodeScanner = new JavascriptCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_string");
        this.fCommentScanner = new JavaScriptScriptCommentScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_single_line_comment", "DLTK_comment_task_tag", (ITodoTaskPreferences)new TodoTaskPreferencesOnPreferenceStore(this.fPreferenceStore));
        this.fDocScanner = new JavascriptDocScanner(this);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fStringScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_string_double");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_string_double");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fStringScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_string_single");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_string_single");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_single_line_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_single_line_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fDocScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_doc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_doc");
        return reconciler;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner.affectsBehavior(event)) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fDocScanner.affectsBehavior(event)) {
            this.fDocScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fCommentScanner.affectsBehavior(event) || this.fDocScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("__javascript_comment".equals(contentType) || "__javascript_doc".equals(contentType)) {
            return new IAutoEditStrategy[]{new JSDocAutoIndentStrategy(this.fPreferenceStore)};
        }
        if ("__dftl_partition_content_type".equals(contentType)) {
            String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
            return new IAutoEditStrategy[]{new JavascriptAutoEditStrategy(partitioning, null)};
        }
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.dltk.javascript.code", this.getEditor());
        return targets;
    }

    protected SpellCheckDelegate createSpellCheckDelegate() {
        return new SpellCheckDelegate(new String[]{"__dftl_partition_content_type", "__javascript_string_double", "__javascript_string_single"});
    }
}

