/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.validation.TypeInfoValidator;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.ISuppressWarningsState;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;

public class JavaScriptDeprecationHighlightVisitor
extends TypeInfoValidator.ValidationVisitor
implements JSProblemReporter {
    private final ISemanticHighlightingRequestor requestor;
    private static final Set<JavaScriptProblems> DEPRECATION = EnumSet.of(JavaScriptProblems.DEPRECATED_FUNCTION, JavaScriptProblems.DEPRECATED_METHOD, JavaScriptProblems.DEPRECATED_PROPERTY, JavaScriptProblems.DEPRECATED_TYPE, JavaScriptProblems.DEPRECATED_VARIABLE);

    public JavaScriptDeprecationHighlightVisitor(ITypeInferenceContext context, ISemanticHighlightingRequestor requestor) {
        super(context, null, null);
        this.reporter = this;
        this.requestor = requestor;
    }

    public void reportProblem(IProblem problem) {
    }

    protected JSMethod createMethod(FunctionStatement node) {
        JSMethod method = super.createMethod(node);
        if (method != null && method.isDeprecated()) {
            if (node.getName() != null) {
                this.requestor.addPosition(node.getName().sourceStart(), node.getName().sourceEnd(), "JS_DEPRECATED");
            } else if (node.getParent() instanceof BinaryOperation && ((BinaryOperation)node.getParent()).getLeftExpression() instanceof PropertyExpression) {
                PropertyExpression exp = (PropertyExpression)((BinaryOperation)node.getParent()).getLeftExpression();
                this.requestor.addPosition(exp.getProperty().sourceStart(), exp.getProperty().sourceEnd(), "JS_DEPRECATED");
            } else if (node.getParent() instanceof PropertyInitializer) {
                Expression name = ((PropertyInitializer)node.getParent()).getName();
                this.requestor.addPosition(name.sourceStart(), name.sourceEnd(), "JS_DEPRECATED");
            }
        }
        return method;
    }

    public void reportProblem(IProblemIdentifier identifier, String message, int start, int end) {
        if (DEPRECATION.contains(identifier)) {
            this.requestor.addPosition(start, end, "JS_DEPRECATED");
        }
    }

    public void pushSuppressWarnings(Collection<IProblemIdentifier> suppressed) {
    }

    public void popSuppressWarnings() {
    }

    public ISuppressWarningsState getSuppressWarnings() {
        return null;
    }

    public void restoreSuppressWarnings(ISuppressWarningsState state) {
    }
}

