/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.FieldDeclarationMatch;
import org.eclipse.dltk.core.search.FieldReferenceMatch;
import org.eclipse.dltk.core.search.MethodDeclarationMatch;
import org.eclipse.dltk.core.search.MethodReferenceMatch;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.core.JSBindings;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MemberReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MethodReferenceNode;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;

public class FieldReferenceNode
extends MemberReferenceNode {
    public FieldReferenceNode(Identifier node) {
        super(node);
    }

    public FieldReferenceNode(Identifier node, ReferenceLocation location) {
        super(node, location, ReferenceKind.FIELD);
    }

    @Override
    public SearchMatch createMatch(IModelElement element, SearchParticipant participant, MatchLevel level) {
        if (this.kind == ReferenceKind.FUNCTION) {
            if (this.location.getNameStart() == ((Identifier)this.node).start() && this.location.getNameEnd() == ((Identifier)this.node).end()) {
                return new MethodDeclarationMatch(element, level.toSearchMatchAccuracy(), ((Identifier)this.node).sourceStart(), this.length(), participant, element.getResource());
            }
            return new MethodReferenceMatch(element, level.toSearchMatchAccuracy(), ((Identifier)this.node).sourceStart(), this.length(), true, true, false, participant, element.getResource(), this.node);
        }
        if (this.location != null && this.location.getNameStart() == ((Identifier)this.node).start() && this.location.getNameEnd() == ((Identifier)this.node).end()) {
            return new FieldDeclarationMatch(element, level.toSearchMatchAccuracy(), ((Identifier)this.node).sourceStart(), this.length(), participant, element.getResource());
        }
        return new FieldReferenceMatch(element, this.node, level.toSearchMatchAccuracy(), ((Identifier)this.node).sourceStart(), this.length(), true, true, false, participant, element.getResource());
    }

    @Override
    public MatchingNode resolvePotentialMatch(JSBindings bindings) {
        super.resolvePotentialMatch(bindings);
        if (this.kind == ReferenceKind.FUNCTION) {
            if (this.location.getNameStart() == ((Identifier)this.node).start() && this.location.getNameEnd() == ((Identifier)this.node).end()) {
                IModelBuilder.IMethod method;
                JSNode parent;
                IValueReference reference = bindings.get(this.node);
                if (reference == null && (parent = ((Identifier)this.node).getParent()) instanceof PropertyExpression && ((PropertyExpression)parent).getProperty() == this.node) {
                    reference = bindings.get((ASTNode)parent);
                }
                if (reference != null && (method = (IModelBuilder.IMethod)reference.getAttribute("METHOD")) != null) {
                    return new MethodDeclarationNode((Expression)this.node, method);
                }
            } else {
                return new MethodReferenceNode((Identifier)this.node, this.location);
            }
        }
        if (this.location != null && this.location.getNameStart() == ((Identifier)this.node).start() && this.location.getNameEnd() == ((Identifier)this.node).end()) {
            return new FieldDeclarationNode((Expression)this.node, this.location.getSourceModule(), null);
        }
        return this;
    }
}

