-- IF YOU UPDATE THIS FILE, DON'T FORGET TO INCREMENT THE Schema.VERSION!
-- This is a table for element references. Table name
-- is substituted in a runtime.

CREATE TABLE IF NOT EXISTS {0}(
	ID INT AUTO_INCREMENT PRIMARY KEY,
	OFFSET INT NOT NULL,
	LENGTH INT NOT NULL,
	NAME VARCHAR_IGNORECASE NOT NULL,
	METADATA VARCHAR,
	QUALIFIER VARCHAR,
	FILE_ID INT NOT NULL,
	FOREIGN KEY(FILE_ID) REFERENCES FILES(ID) ON UPDATE CASCADE ON DELETE CASCADE,
);
CREATE INDEX IF NOT EXISTS IDX_QUALIFIER_{0} ON {0}(QUALIFIER);
CREATE INDEX IF NOT EXISTS IDX_FILE_ID_{0} ON {0}(FILE_ID);
CREATE INDEX IF NOT EXISTS IDX_NAME_{0} ON {0}(NAME);

CREATE OR REPLACE  VIEW {0}_TO_CONTAINER AS SELECT T.*, F.CONTAINER_ID FROM {0} AS T INNER JOIN FILES AS F ON (T.FILE_ID = F.ID);
