/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.LocalVariablePattern;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldReferenceNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MemberReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MethodReferenceNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;

public class LocalVariablePredicate
extends AbstractMatchingPredicate<MatchingNode> {
    private final boolean declarations;
    private final boolean references;
    private final ISourceModule module;
    private final int nameStart;
    private final int nameEnd;

    public LocalVariablePredicate(LocalVariablePattern pattern) {
        super((SearchPattern)pattern, pattern.name);
        ILocalVariable variable = pattern.getLocalVariable();
        this.module = (ISourceModule)variable.getAncestor(5);
        ISourceRange name = variable.getNameRange();
        this.nameStart = name.getOffset();
        this.nameEnd = name.getOffset() + name.getLength();
        this.declarations = pattern.findDeclarations;
        this.references = pattern.findReferences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatchLevel match(MatchingNode node) {
        if (node instanceof LocalVariableDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            LocalVariableDeclarationNode varNode = (LocalVariableDeclarationNode)node;
            if (((Identifier)varNode.node).sourceStart() != this.nameStart || ((Identifier)varNode.node).sourceEnd() != this.nameEnd || !this.isSame(varNode.module)) return null;
            return this.matchName(((Identifier)varNode.node).getName(), MatchLevel.ACCURATE_MATCH);
        }
        if (node instanceof LocalVariableReferenceNode) {
            if (!this.references) {
                return null;
            }
            LocalVariableReferenceNode varNode = (LocalVariableReferenceNode)node;
            ReferenceLocation location = varNode.declarationLoc;
            if (location.getNameStart() != this.nameStart || location.getNameEnd() != this.nameEnd || !this.isSame(location.getSourceModule())) return null;
            return this.matchName(((Identifier)varNode.node).getName(), MatchLevel.ACCURATE_MATCH);
        }
        if (node instanceof FieldReferenceNode) {
            if (!this.references) {
                return null;
            }
            FieldReferenceNode fieldNode = (FieldReferenceNode)node;
            ReferenceLocation location = fieldNode.location;
            if (location == null) return this.matchName(((Identifier)fieldNode.node).getName());
            if (location.getNameStart() != this.nameStart || location.getNameEnd() != this.nameEnd || !this.isSame(location.getSourceModule())) return null;
            return this.matchName(((Identifier)fieldNode.node).getName(), MatchLevel.ACCURATE_MATCH);
        }
        if (node instanceof MethodReferenceNode) {
            if (!this.references) {
                return null;
            }
            MethodReferenceNode mNode = (MethodReferenceNode)node;
            ReferenceLocation location = mNode.location;
            if (location == null) return this.matchName(((Identifier)mNode.node).getName());
            if (location.getNameStart() != this.nameStart || location.getNameEnd() != this.nameEnd || !this.isSame(location.getSourceModule())) return null;
            return this.matchName(((Identifier)mNode.node).getName(), MatchLevel.ACCURATE_MATCH);
        }
        if (node instanceof MethodDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            MethodDeclarationNode mNode = (MethodDeclarationNode)node;
            ReferenceLocation location = mNode.method.getLocation();
            if ((location.getNameStart() != this.nameStart || location.getNameEnd() != this.nameEnd) && (((Expression)mNode.node).sourceStart() != this.nameStart || ((Expression)mNode.node).sourceEnd() != this.nameEnd) || !this.isSame(location.getSourceModule())) return null;
            return this.matchName(mNode.method.getName(), MatchLevel.ACCURATE_MATCH);
        }
        if (!(node instanceof FieldDeclarationNode)) return null;
        if (!this.declarations) {
            return null;
        }
        FieldDeclarationNode fNode = (FieldDeclarationNode)node;
        if (fNode.sourceStart() != this.nameStart || fNode.sourceEnd() != this.nameEnd) return null;
        return this.matchName(fNode.getName(), MatchLevel.ACCURATE_MATCH);
    }

    public MatchLevel resolvePotentialMatch(MatchingNode node) {
        if (node instanceof MemberReferenceNode) {
            MemberReferenceNode mNode = (MemberReferenceNode)node;
            ReferenceLocation location = mNode.location;
            return location != null && location.getNameStart() == this.nameStart && location.getNameEnd() == this.nameEnd && this.isSame(location.getSourceModule()) ? MatchLevel.ACCURATE_MATCH : null;
        }
        return super.resolvePotentialMatch((Object)node);
    }

    private boolean isSame(ISourceModule module) {
        return module != null && module.equals(this.module);
    }
}

