/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.scriptview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.internal.ui.scriptview.IMultiElementTreeContentProvider;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkingSet;

public abstract class WorkingSetAwareContentProvider
extends ScriptExplorerContentProvider
implements IMultiElementTreeContentProvider {
    private WorkingSetModel fWorkingSetModel;
    private IPropertyChangeListener fListener;

    public WorkingSetAwareContentProvider(boolean provideMembers, WorkingSetModel model) {
        super(provideMembers);
        this.fWorkingSetModel = model;
        this.fListener = event -> this.workingSetModelChanged(event);
        this.fWorkingSetModel.addPropertyChangeListener(this.fListener);
    }

    @Override
    public void dispose() {
        this.fWorkingSetModel.removePropertyChangeListener(this.fListener);
        super.dispose();
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof IWorkingSet) {
            return true;
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getChildren(Object element) {
        if (element instanceof WorkingSetModel) {
            Assert.isTrue((this.fWorkingSetModel == element ? 1 : 0) != 0);
            return this.fWorkingSetModel.getActiveWorkingSets();
        }
        Object[] children = element instanceof IWorkingSet ? this.getWorkingSetChildren((IWorkingSet)element) : super.getChildren(element);
        return children;
    }

    private Object[] getWorkingSetChildren(IWorkingSet set) {
        IAdaptable[] elements = this.fWorkingSetModel.getChildren(set);
        boolean isKnownWorkingSet = this.isKnownWorkingSet(set);
        ArrayList<Object> result = new ArrayList<Object>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IProject project;
            IAdaptable element = elements[i];
            boolean add = false;
            if (element instanceof IProject) {
                add = true;
            } else if (element instanceof IResource) {
                project = ((IResource)element).getProject();
                add = project == null || project.isOpen();
            } else if (element instanceof IScriptProject) {
                add = true;
            } else if (element instanceof IModelElement) {
                project = this.getProject((IModelElement)element);
                boolean bl = add = project == null || project.isOpen();
            }
            if (add) {
                if (isKnownWorkingSet) {
                    result.add(element);
                } else {
                    project = (IProject)element.getAdapter(IProject.class);
                    if (project != null && project.exists()) {
                        IScriptProject jp = DLTKCore.create((IProject)project);
                        if (jp != null && jp.exists()) {
                            result.add(jp);
                        } else {
                            result.add(project);
                        }
                    }
                }
            }
            ++i;
        }
        return result.toArray();
    }

    private boolean isKnownWorkingSet(IWorkingSet set) {
        String id = set.getId();
        return "org.eclipse.dltk.internal.ui.OthersWorkingSet".equals(id) || "org.eclipse.dltk.ui.ScriptWorkingSetPage".equals(id) || "org.eclipse.ui.resourceWorkingSetPage".equals(id);
    }

    private IProject getProject(IModelElement element) {
        if (element == null) {
            return null;
        }
        IScriptProject project = element.getScriptProject();
        if (project == null) {
            return null;
        }
        return project.getProject();
    }

    @Override
    public TreePath[] getTreePaths(Object element) {
        if (element instanceof IWorkingSet) {
            TreePath path = new TreePath(new Object[]{element});
            return new TreePath[]{path};
        }
        List modelParents = this.getModelPath(element);
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < modelParents.size()) {
            result.addAll(this.getTreePaths(modelParents, i));
            ++i;
        }
        return result.toArray(new TreePath[result.size()]);
    }

    private List getModelPath(Object element) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(element);
        Object parent = super.getParent(element);
        Object input = this.getViewerInput();
        while (parent != null && !parent.equals(input) && !(parent instanceof IScriptModel)) {
            result.add(parent);
            parent = super.getParent(parent);
        }
        Collections.reverse(result);
        return result;
    }

    private List getTreePaths(List modelParents, int index) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        Object input = this.getViewerInput();
        Object element = modelParents.get(index);
        Object[] parents = this.fWorkingSetModel.getAllParents(element);
        int i = 0;
        while (i < parents.length) {
            ArrayList<Object> chain = new ArrayList<Object>();
            if (!parents[i].equals(input)) {
                chain.add(parents[i]);
            }
            int m = index;
            while (m < modelParents.size()) {
                chain.add(modelParents.get(m));
                ++m;
            }
            result.add(new TreePath(chain.toArray()));
            ++i;
        }
        return result;
    }

    @Override
    public Object getParent(Object child) {
        Object parent = this.getExtendedParent(child);
        if (parent != null) {
            return parent;
        }
        Object[] parents = this.fWorkingSetModel.getAllParents(child);
        if (parents.length == 0) {
            return super.getParent(child);
        }
        Object first = parents[0];
        return first;
    }

    protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
        Object parent;
        if (DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(affectedElement)) {
            toRefresh.remove(affectedElement);
            toRefresh.add(this.fWorkingSetModel);
        } else if (relation == 2 && (parent = this.internalGetParent(affectedElement)) != null) {
            toRefresh.addAll(Arrays.asList(this.fWorkingSetModel.getAllParents(parent)));
        }
        List nonProjetTopLevelElemens = this.fWorkingSetModel.getNonProjectTopLevelElements();
        if (nonProjetTopLevelElemens.isEmpty()) {
            return;
        }
        ArrayList toAdd = new ArrayList();
        for (Object element : nonProjetTopLevelElemens) {
            if (!this.isChildOf(element, toRefresh)) continue;
            toAdd.add(element);
        }
        toRefresh.addAll(toAdd);
    }

    private void workingSetModelChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        Object newValue = event.getNewValue();
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        if ("workingSetModelChanged".equals(property)) {
            toRefresh.add(this.fWorkingSetModel);
        } else if ("workingSetContentChange".equals(property)) {
            toRefresh.add(newValue);
        } else if ("workingSetNameChange".equals(property)) {
            toRefresh.add(newValue);
        }
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        this.postRefresh(toRefresh, true, runnables);
        this.executeRunnables(runnables);
    }

    private boolean isChildOf(Object element, List potentialParents) {
        Object parent = super.getParent(element);
        if (parent == null) {
            return false;
        }
        for (Object potentialParent : potentialParents) {
            while (parent != null) {
                if (parent.equals(potentialParent)) {
                    return true;
                }
                parent = super.getParent(parent);
            }
        }
        return false;
    }
}

