/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.scriptdoc;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.compiler.InvalidInputException;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IBufferChangedListener;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.javascript.scriptdoc.IScanner;
import org.eclipse.dltk.javascript.scriptdoc.PublicScanner;

public class JSDocContentAccess {
    private static final String JAVADOC_BEGIN = "/**";

    public static ISourceRange getDocRange(IMember member) throws ModelException {
        ISourceRange range = member.getSourceRange();
        if (range == null) {
            return null;
        }
        ISourceModule compilationUnit = member.getSourceModule();
        int possibleDocEnd = range.getOffset();
        int possibleDocStart = PreviousMemberDetector.execute(possibleDocEnd, possibleDocEnd + range.getLength(), member);
        return JSDocContentAccess.getDocRange(compilationUnit, possibleDocStart, possibleDocEnd);
    }

    public static ISourceRange getDocRange(ISourceModule compilationUnit, int possibleDocStart, int possibleDocEnd) throws ModelException {
        String sm;
        int start;
        if (!compilationUnit.isConsistent()) {
            return null;
        }
        IBuffer buf = compilationUnit.getBuffer();
        if (buf == null) {
            buf = new SimpleBuffer(compilationUnit.getSource());
        }
        if ((start = (sm = buf.getText(possibleDocStart, possibleDocEnd - possibleDocStart)).lastIndexOf(JAVADOC_BEGIN)) == -1) {
            return null;
        }
        IScanner scanner = JSDocContentAccess.createScanner(true, false, false, false);
        scanner.setSource(buf.getText(possibleDocStart + start, possibleDocEnd - (possibleDocStart + start)).toCharArray());
        try {
            int docOffset = -1;
            int docEnd = -1;
            int terminal = scanner.getNextToken();
            block6: while (true) {
                switch (terminal) {
                    case 1003: {
                        docOffset = scanner.getCurrentTokenStartPosition();
                        docEnd = scanner.getCurrentTokenEndPosition() + 1;
                        terminal = scanner.getNextToken();
                        continue block6;
                    }
                    case 1001: 
                    case 1002: {
                        terminal = scanner.getNextToken();
                        continue block6;
                    }
                }
                break;
            }
            if (docOffset != -1) {
                return new SourceRange(docOffset + possibleDocStart + start, docEnd - docOffset);
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return null;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean assertMode, boolean recordLineSeparator) {
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, 4L, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    private static class PreviousMemberDetector
    implements IModelElementVisitor {
        private int currentEnd = 0;
        private final IMember target;
        private final int targetStart;
        private final int targetEnd;

        public PreviousMemberDetector(IMember target, int targetStart, int targetEnd) {
            this.target = target;
            this.targetStart = targetStart;
            this.targetEnd = targetEnd;
        }

        public boolean visit(IModelElement element) {
            if (!element.equals(this.target) && element instanceof ISourceReference) {
                try {
                    ISourceRange range = ((ISourceReference)element).getSourceRange();
                    if (SourceRange.isAvailable((ISourceRange)range)) {
                        int end = range.getOffset() + range.getLength();
                        if (end < this.targetStart && end > this.currentEnd) {
                            this.currentEnd = end;
                        } else if (range.getOffset() <= this.targetStart && end >= this.targetEnd && range.getOffset() > this.currentEnd) {
                            this.currentEnd = range.getOffset();
                        }
                    }
                }
                catch (ModelException modelException) {}
            }
            return true;
        }

        public static int execute(int start, int end, IMember member) {
            PreviousMemberDetector detector = new PreviousMemberDetector(member, start, end);
            try {
                member.getSourceModule().accept((IModelElementVisitor)detector);
            }
            catch (ModelException modelException) {}
            return detector.currentEnd;
        }
    }

    private static class SimpleBuffer
    implements IBuffer {
        private final StringBuilder sb = new StringBuilder();

        public SimpleBuffer(String value) {
            this.sb.append(value);
        }

        public void addBufferChangedListener(IBufferChangedListener listener) {
        }

        public void append(char[] text) {
            this.sb.append(text);
        }

        public void append(String text) {
            this.sb.append(text);
        }

        public void close() {
        }

        public char getChar(int position) {
            return this.sb.charAt(position);
        }

        public char[] getCharacters() {
            return this.sb.toString().toCharArray();
        }

        public String getContents() {
            return this.sb.toString();
        }

        public int getLength() {
            return this.sb.length();
        }

        public IOpenable getOwner() {
            return null;
        }

        public String getText(int offset, int length) {
            return this.sb.substring(offset, offset + length);
        }

        public IResource getUnderlyingResource() {
            return null;
        }

        public boolean hasUnsavedChanges() {
            return false;
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public void removeBufferChangedListener(IBufferChangedListener listener) {
        }

        public void replace(int position, int length, char[] text) {
            this.sb.replace(position, position + length, new String(text));
        }

        public void replace(int position, int length, String text) {
            this.sb.replace(position, position + length, text);
        }

        public void save(IProgressMonitor progress, boolean force) throws ModelException {
        }

        public void setContents(char[] contents) {
            this.sb.setLength(0);
            this.sb.append(contents);
        }

        public void setContents(String contents) {
            this.sb.setLength(0);
            this.sb.append(contents);
        }
    }
}

