package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

           92,   92,  112,  112,  112,  229,   92,  392,  253,  250, 
          582,  285,  230,  242,  242,  593,  189,  242,  239,  239, 
          282,  203,  239,  492,  238,  238,  421,  275,  238,  109, 
          109,  241,  241,  521,  571,  241,  554,  603,  734,  109, 
           71,  203,  221,  229,   95,   92,  216,  242,  242,  283, 
          235,  235,  266,  277,  235,  249,  619,   61,  492,  276, 
          553,   89,  654,   40,  292,  444,  513,  518,   60,  524, 
          525,  492,  492,  788,  215,  218,  109,  458,  590,  304, 
          493,  216,  355,  254,  270,  440,  283,  453,  661,  437, 
          301,  492,  619,  608,  551,  217,  357,  216,  786,  444, 
          789,   71,  216,  301,  221,   92,  216,  492,  492,   89, 
           89,  513,  518,  109,  444,  307,  471,  386,   61,  254, 
          492,  453,  492,  663,  261,  262,  458,  551,  354,  600, 
          217,  463,  457,  440,  249,  468,  453,  538,  457,  367, 
          492,  445,  272,  657,  311,  312,  651,  354,  487,  492, 
          383,  217,  248,  254,  344,  217,  445,  492,  551,  492, 
          457,  345,  363,  577,  307,  492,  487,  234,  234,  457, 
          245,  234,  465,  302,  534,  444,  658,  362,  472,  386, 
          551,  445,  440,  394,  361,  395,  302,  492,  362,  481, 
          447,   82,  458,  459,  460,  258,  260,  744,  458,  459, 
          462,  234,  234,  248,  284,  286,  788,  257,  492,  373, 
          292,  260,  686,  492,  492,  449,  374,  343,  263,  571, 
          458,  459,  464,  718,  393,  362,  362,  296,  787,  458, 
          459,  693,  581,  858,  395,  492,  492,  190,  190,   82, 
           82,  765,   87,  242,   55,  242,  242,  769,  239,  221, 
          239,  239,  482,  355,  238,   92,  238,  423,  190,  358, 
          359,  241,   92,  241,  241,  442,  424,  457,  298,  266, 
          425,  426,  422,  562,  563,  564,  565,  492,  313,  339, 
          235,  346,  235,  419,  353,  190,  398,  399,  347,  370, 
           87,   87,  364,  676,  678,  711,  581,  774,  388,  564, 
          565,  355,  355,   92,  526,  377,  529,  655,   92,  328, 
          537,  540,  348,  330,  331,  332,  333,  352,   89,  535, 
          378,   72,  389,  278,  492,  492,  492,  458,  459,  467, 
           69,  403,  361,  361,  407,  481,   61,  481,  361,   63, 
          380,  242,  457,   40,   40,  492,  475,   92,  283,   64, 
           62,  480,  599,   67,  266,  739,  740,  533,  381,  382, 
          275,  533,  492,  311,  312,  805,  265,  492,  242,   92, 
          476,  477,  478,  479,  619,  109,  229,  492,  270,  390, 
          619,  272,   92,  234,  234,  286,  242,  533,  272,  723, 
           92,  492,   92,  216,  365,  545,   40,  234,  444,  234, 
          234,  242,  458,  459,  596,  270,  242,  429,  635,  242, 
          458,  615,  743,  493,  242,  629,  632,   61,  440,  626, 
          453,  441,  492,  270,  843,  552,  265,   65,   92,  602, 
          602,  190,  627,  841,  362,  643,  644,  571,  270,  630, 
          827,  203,  492,  391,  492,  242,  631,  243,   82,  492, 
          244,  481,  481,  481,  242,  492,  341,  481,  481,  388, 
          481,  456,  837,  342,  397,  483,  484,  485,  486,  487, 
          488,  489,  490,  491,  492,  493,  494,  495,  496,  497, 
          498,  499,  500,  501,  502,  503,  504,  505,  506,  507, 
          508,  270,  482,  857,  482,  234,  619,  795,  527,   87, 
          530,  667,  311,  312,  234,  541,  673,  362,  676,  678, 
          355,  422,  675,  677,  482,  482,  482,  492,  422,  400, 
          482,  482,  234,  482,  619,  492,  492,  863,  368,  404, 
          234,  492,  481,   91,   91,  369,  492,  386,  492,   91, 
          234,  527,  591,  541,  387,   92,  407,  234,   69,  408, 
          689,  411,  672,  481,  492,  234,  413,  703,   88,  234, 
          234,  551,  278,  234,   92,  234,  690,   64,  623,  278, 
          401,   67,  430,  520,  473,  684,  431,  402,   91,   92, 
          294,  295,  313,  265,  313,  672,  639,  640,  641,  839, 
          203,  434,    6,  390,   84,  482,  234,  435,  694,  234, 
          520,  234,    6,  492,  443,  380,   88,   88,  234,  436, 
          685,  438,   69,  452,   83,  328,  482,  439,  520,  330, 
          331,  453,  761,  763,  448,  536,  450,  451,  766,   69, 
            8,   64,  242,  520,  466,   67,  492,  615,   91,  279, 
            8,  428,   84,   84,  542,   65,  581,  470,   64,  229, 
           92,    6,   67,  390,  390,  390,  230,   92,  190,   92, 
          585,   92,   83,   83,  520,  380,  380,  380,  265,  742, 
          395,   81,   76,  727,  598,  472,  415,  610,  417,  420, 
          234,    7,  621,  109,  633,  492,  520,  781,  634,    8, 
          638,    7,  642,  656,  664,  280,  665,  670,  432,  671, 
          454,  835,  794,  584,  681,  433,   92,  455,  836,   65, 
          674,  592,  682,  594,  698,  688,  776,  700,  272,  472, 
          687,   92,   92,   92,  691,  701,   65,  242,  823,  109, 
          695,  697,  242,  242,  699,  704,  702,  813,  816,  708, 
            7,  714,  817,  812,  717,  715,  716,  234,  719,  637, 
          814,  720,  722,  729,   79,   79,  110,  110,  602,  726, 
           79,  210,  210,  210,  735,  234,  225,  210,  210,  234, 
          232,  210,   92,   92,  234,  797,  737,  738,  210,   83, 
           83,  111,  111,  741,  745,   83,  234,  190,   91,  746, 
          748,  226,  770,   92,  777,   91,  782,  747,  778,   79, 
          210,  210,  798,  280,  799,  210,  800,  190,  492,  810, 
          819,  818,  492,  492,  759,   88,  762,  764,  820,  822, 
          821,  829,  767,  768,   83,  830,   92,  834,  281,  844, 
          845,  849,  771,  234,  851,  242,   91,   92,  854,  855, 
          280,   91,  856,  234,   92,  875,  873,  242,  879,  242, 
          877,   84,  870,  492,    6,    6,    6,  210,  492,   79, 
            6,    6,  483,    6,  472,  281,  762,  764,  767,  481, 
          492,   83,  270,  485,  234,  483,  492,  242,  279,  485, 
           91,  234,  253,  483,   83,  279,  234,  234,  492,  492, 
          492,  487,    8,    8,    8,  492,  493,  300,    8,    8, 
          707,    8,   91,  115,  876,  487,   89,   84,  472,  188, 
          172,  828,  692,  351,  472,   91,  783,  756,  303,  785, 
          172,  472,  824,   91,  234,   91,  472,  831,  864,   79, 
          832,  305,    0,  833,  280,    6,  306,  307,  308,  309, 
          310,  280,    0,    7,    7,    7,   79,  472,    0,    7, 
            7,  824,    7,  234,  216,    0,    6,  272,  472,  847, 
            0,   91,    0,  234,  272,  472,    0,  234,    0,  172, 
          472,  749,    0,    8,  210,  210,  278,    0,  757,    0, 
          758,    0,  760,    0,    0,    0,    0,   89,   84,  234, 
            0,  472,    0,    0,    8,    0,    0,  210,    0,  210, 
          210,  234,  874,  234,    0,   94,   94,   34,    0,   79, 
            0,   94,   94,   94,   94,    0,   79,   34,   94,   94, 
            0,  234,   94,  234,    7,    0,   40,  796,    0,   94, 
            0,  234,    0,    0,   83,  234,   40,    0,    0,    0, 
            0,   83,  802,  803,  804,    7,    0,    0,    0,    0, 
           94,   94,   94,    0,    0,    0,   94,   79,  210,  210, 
          210,  210,   79,  210,  210,    0,   34,  520,    0,    0, 
            0,  557,    0,    0,  558,  559,  560,    0,   91,    0, 
           86,   86,   83,    0,   40,   40,   86,   83,    0,    0, 
            0,    0,  228,  826,    0,  210,    0,   91,  210,    0, 
          210,   79,  280,    0,  210,  210,    0,    0,   94,  561, 
           94,    0,   91,    0,  838,    0,  562,  563,  564,  565, 
            0,    0,  210,   79,  210,   86,   83,  281,   78,  750, 
          751,    0,  752,   39,   40,    0,   79,    0,    0,    0, 
          210,    0,    0,    0,   79,    0,   79,    0,   83,    0, 
            0,    0,    0,    0,    0,  210,    0,    0,  865,    0, 
            0,   83,    0,    0,   79,  866,    0,    0,  210,   83, 
            0,   83,  172,  172,  172,  473,    0,    0,  172,  172, 
          210,  172,   79,   91,   86,   86,    0,    0,    0,    0, 
           91,    0,   91,    0,   91,  208,  208,  208,    0,    0, 
          172,  172,    0,  172,  172,  172,  172,   83,  210,    0, 
            0,    0,  251,    0,    0,  278,    0,   77,    0,    0, 
            0,    0,  278,    0,    0,   94,   94,  473,   79,    0, 
            0,    0,   86,   86,  268,    0,    0,    0,   74,   91, 
            0,    0,    0,    0,    0,   79,  272,  275,   94,    0, 
           94,   94,    0,  172,   91,   91,   91,    0,    0,    0, 
           94,    0,    0,    0,  476,  473,    0,   94,    0,   34, 
           34,   34,    0,  412,  172,   34,   34,    0,   34,    0, 
            0,    0,    0,    0,    0,  422,    0,    0,   40,   40, 
           40,  360,    0,   40,   40,   40,    0,   40,  210,   79, 
           34,   34,   34,   34,   34,   91,   91,   40,   94,   94, 
           94,   94,   94,   94,   94,   94,   40,   40,   79,   40, 
           40,   40,   40,   40,   83,   80,   91,    0,    0,    0, 
            0,   85,    0,   79,    0,   86,    0,    0,   75,    0, 
            0,    0,   86,   83,    0,    0,   94,    0,    0,   94, 
           34,   94,   94,    0,    0,   94,   94,    0,   83,   91, 
            0,  210,    0,   86,  473,    0,    0,    0,    0,   40, 
           91,   34,  279,   94,   94,   94,    0,   91,    0,   85, 
           85,    0,    0,   86,    0,  280,  210,   94,   86,    0, 
           40,   94,    0,    0,    0,   94,    0,   94,    0,   79, 
            0,   81,    0,    0,   79,    0,   94,    0,  208,  208, 
          225,   79,  476,   79,  473,   79,  210,  210,   81,   94, 
          557,  473,  210,  558,  559,  560,  473,   86,    0,   83, 
          754,   94,    0,   94,    0,  226,   83,    0,   83,  611, 
           83,   86,    0,    0,   86,  422,  278,  473,  272,   86, 
            0,    0,   85,  476,  473,    0,  791,    0,    0,   94, 
           79,    0,   86,  210,    0,  562,  563,  564,  565,    0, 
           86,    0,   86,   82,    0,   79,   79,   79,    0,    0, 
            0,  792,    0,    0,    0,   83,  160,    0,    0,    0, 
            0,    0,  208,  208,  208,  208,    0,  481,  482,    0, 
           83,   83,   83,  476,  473,    0,    0,    0,   86,    0, 
          476,  473,    0,    0,    0,  472,  473,    0,    0,    0, 
            0,    0,  210,    0,  422,    0,   79,   79,  313,    0, 
            0,  422,    0,   85,    0,  160,  476,  473,    0,    0, 
          272,    0,    0,    0,  326,  327,    0,   79,    0,   94, 
           94,   83,   83,    0,   82,    0,    0,    0,  555,  328, 
           88,  329,    0,  330,  331,  332,  333,  272,  153,   94, 
            0,    0,   83,   83,    0,  580,  583,    0,  405,  406, 
           79,    0,    0,    0,   94,  272,    0,    0,   85,  210, 
            0,   79,    0,    0,    0,    0,    0,    0,   79,    0, 
          272,  476,  268,    0,    0,   83,    0,    0,    0,    0, 
            0,  279,   94,    0,  636,    0,   83,  153,  279,    0, 
            0,    0,    0,   83,  280,   86,    0,    0,   76,    0, 
            0,  280,    0,    0,   87,    0,   81,   94,    0,   74, 
            0,   88,    0,    0,   86,   76,    0,    0,    0,  730, 
            0,  476,    0,  272,   83,   94,   74,    0,  476,   86, 
          736,    0,   94,  472,   94,    0,   94,   94,   94,    0, 
          660,  660,    0,   94,    0,  472,    0,    0,    0,    0, 
            0,    0,    0,    0,  476,  278,  422,  272,    0,    0, 
            0,    0,  278,    0,  272,  532,   80,  473,    0,  539, 
           81,    0,    0,    0,    0,    0,  660,    0,    0,  262, 
          669,   94,    0,   80,   94,   87,    0,   81,    0,  262, 
            0,  669,  669,    0,    0,  578,   94,   94,   94,    0, 
           86,    0,  208,    0,    0,    0,  228,   86,    0,   86, 
            0,   86,  532,  279,    0,  669,   41,    0,    0,    0, 
            0,    0,    0,  261,  612,  614,   41,    0,  618,    0, 
          620,    0,  806,  625,    0,  808,  809,  262,  262,    0, 
            0,    0,    0,   94,    0,    0,  706,   94,   94,  710, 
          160,  583,  793,  160,  160,  160,   86,    0,    0,  583, 
            0,  646,    0,    0,  618,  208,  646,    0,   94,    0, 
            0,   86,   86,   86,   41,   41,  417,    0,    0,    0, 
            0,    0,    0,  417,    0,    0,    0,    0,  160,    0, 
          313,    0,   78,    0,    0,  160,  160,  160,  160,    0, 
            0,   94,    0,    0,    0,  182,  326,  327,    0,   78, 
           94,    0,   94,    0,    0,  182,  850,  852,    0,   94, 
            0,  328,   86,   86,    0,  330,  331,  332,  333,    0, 
            0,    0,  153,   76,  472,  153,  153,  153,    0,  473, 
            0,    0,    0,   86,   74,  679,    0,    0,    0,  182, 
          660,  867,  868,    0,    0,    0,    0,  872,  416,    0, 
            0,    0,    0,  182,  182,  416,    0,  208,  182,    0, 
          153,   75,    0,    0,  880,    0,   86,  153,  153,  153, 
          153,    0,  882,    0,  472,  884,    0,   86,   75,  886, 
            0,  472,    0,    0,   86,  422,  472,   76,    0,    0, 
            0,   80,  422,    0,    0,    0,  669,  669,   74,    0, 
            0,    0,  721,    0,   76,    0,    0,  472,  280,    0, 
            0,    0,    0,    0,    0,   74,    0,    0,    0,    0, 
          728,    0,    0,    0,  731,    0,    0,    0,    0,  732, 
            0,  262,  262,  262,  411,    0,  262,  262,  262,    0, 
          262,  614,  279,    0,  411,    0,    0,    0,    0,  279, 
            0,    0,    0,    0,    0,   80,    0,    0,    0,  583, 
            0,    0,  262,  262,  262,  262,  262,    0,   41,   41, 
           41,    0,   80,   41,   41,   41,    0,   41,  411,    0, 
            0,    0,    0,    0,    0,    0,    0,   41,  773,    0, 
            0,    0,  411,  411,  272,  411,    0,  411,  780,   41, 
           41,   41,   41,   41,    0,    0,    0,    0,    0,  262, 
            0,    0,  262,    0,    0,    0,    0,   78,  473,    0, 
            0,    0,  583,    0,    0,  411,    0,    0,    0,  646, 
            0,    0,    0,  262,    0,    0,  618,    0,    0,    0, 
            0,    0,  618,    0,    0,    0,    0,    0,    0,   41, 
            0,  414,    0,    0,    0,    0,    0,  182,  182,  182, 
            0,  414,  182,  182,  182,    0,  182,    0,  473,    0, 
           41,    0,    0,    0,    0,  473,  182,  182,    0,  825, 
          473,   78,    0,    0,    0,  182,  182,    0,  182,  182, 
          182,  182,  182,    0,    0,  414,   75,    0,   78,    0, 
            0,  473,    0,    0,    0,    0,    0,    0,  840,  414, 
          414,    0,  414,    0,  414,    0,    0,    0,  848,    0, 
            0,    0,  853,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  182,  254,    0,  182,    0, 
            0,  182,  414,  182,    0,    0,    0,  280,    0,    0, 
            0,    0,    0,    0,  280,    0,  614,    0,  618,  182, 
           75,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   14,    0,    0,  878,   75,  881,    0, 
            0,    0,    0,   14,    0,    0,  618,    0,    0,  338, 
          885,  469,  469,  469,    0,  469,  411,  411,  411,  469, 
          469,  411,  411,  411,  469,  411,  469,  469,  469,  469, 
          469,  469,  469,  411,  469,  411,  411,  469,  469,  469, 
          469,  469,  469,  469,  411,  411,    0,  411,  411,  411, 
          411,  411,   14,  469,    0,    0,  469,  469,  469,  469, 
          469,  469,  469,  469,  469,  469,    0,  469,  469,    0, 
          469,  469,  469,  411,  411,  411,  411,  411,  411,  411, 
          411,  411,  411,  411,  411,  411,  411,    0,    0,  411, 
          411,  411,  469,  411,  411,  469,  469,  411,  469,  469, 
          411,  469,  411,  469,  411,  469,  411,  469,  411,  411, 
          411,  411,  411,  411,  411,  469,  411,  469,  411,    0, 
          469,  469,  469,  469,  469,  469,    0,    0,  470,  470, 
          470,    0,  470,  414,  414,  414,  470,  470,  414,  414, 
          414,  470,  414,  470,  470,  470,  470,  470,  470,  470, 
          414,  470,  414,  414,  470,  470,  470,  470,  470,  470, 
          470,  414,  414,  338,  414,  414,  414,  414,  414,    0, 
          470,    0,    0,  470,  470,  470,  470,  470,  470,  470, 
          470,  470,  470,    0,  470,  470,    0,  470,  470,  470, 
          414,  414,  414,  414,  414,  414,  414,  414,  414,  414, 
          414,  414,  414,  414,    0,    0,  414,  414,  414,  470, 
          414,  414,  470,  470,  414,  470,  470,  414,  470,  414, 
          470,  414,  470,  414,  470,  414,  414,  414,  414,  414, 
          414,  414,  470,  414,  470,  414,  472,  470,  470,  470, 
          470,  470,  470,    0,    0,    0,  472,    0,    0,    0, 
            0,    0,    0,    0,    0,   14,   14,   14,    0,    0, 
            0,   14,   14,    0,   14,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,    0,  324,  325,    0, 
          472,  326,  327,    0,    0,    0,   14,   14,   14,   14, 
           14,    0,    0,    0,  472,  472,  328,   84,  329,  472, 
          330,  331,  332,  333,  334,  335,  336,    0,  337,    0, 
            0,    0,    0,    0,    0,    0,    0,  510,  511,    0, 
            0,  512,    0,    0,    0,    0,    0,  472,    0,  160, 
          161,    0,  162,  163,  164,  165,   14,  166,  167,    0, 
            0,  168,    0,    0,    0,    0,  169,  170,  171,  172, 
            0,  473,    0,    0,    0,    0,    0,   14,    0,    0, 
            0,  473,  174,  175,    0,  176,  177,  178,  179,  180, 
          181,  182,  183,  184,    0,  185,    0,    0,  186,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  473,    0,  680,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  473, 
          473,    0,   86,    0,  473,    0,    0,    0,    0,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          163,  324,  325,    0,    0,  326,  327,    0,    0,    0, 
            0,  148,  473,    0,    0,    0,    0,    0,    0,    0, 
          328,    0,  329,    0,  330,  331,  332,  333,  334,  335, 
          336,    0,  337,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  163, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          148,    0,    0,  472,  472,  472,    0,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,    0,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  338,  472, 
          472,  472,  472,  472,    0,  472,    0,    0,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,    0,  472, 
          472,    0,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,    0, 
            0,  472,  472,  472,  472,    0,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,    0,  472,  472,  472,  472,  472,  472,  473,  473, 
          473,    0,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
            0,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,    0,  473,  473,  473,  473,  473,    0, 
          473,    0,    0,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,    0,  473,  473,    0,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,    0,    0,  473,  473,  473,  473, 
            0,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,  476,  473,  473,  473, 
          473,  473,  473,    0,  163,    0,  476,  163,  163,  163, 
            0,    0,    0,    0,    0,  148,    0,    0,  148,  148, 
          148,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          418,    0,    0,    0,    0,    0,    0,  418,    0,    0, 
          476,  419,  163,    0,    0,    0,    0,    0,  419,  163, 
          163,  163,  163,  148,  476,  476,    0,   85,    0,  476, 
          148,  148,  148,  148,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,    0,  324,  325,    0,    0, 
          326,  327,    0,    0,    0,    0,    0,  476,    0,    0, 
            0,    0,    0,    0,    0,  328,    0,  329,    0,  330, 
          331,  332,  333,  334,  335,  336,    0,  337,    0,    0, 
            0,  273,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  273,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   96, 
           97,   17,   18,    0,    0,  273,    0,   98,   99,  100, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,  273, 
          273,    0,    0,  101,  273,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,  313, 
          131,    0,  104,    0,  318,  319,    0,    0,    0,    0, 
            0,  132,  273,    0,    0,  326,  327,    0,    0,    0, 
            0,    0,  224,    0,    0,   47,    0,    0,   48,   49, 
          328,   50,  329,   51,  330,  331,  332,  333,  334,  335, 
          336,    0,  337,    0,  755,    0,    0,    0,    0,  131, 
           54,   55,   56,   57,   58,   59,    0,    0,    0,    0, 
          132,    0,    0,  472,  472,  472,    0,  472,  476,  476, 
          476,  472,  472,  476,  476,  476,  472,  476,  472,  472, 
          472,  472,  472,  472,  472,    0,  476,  476,  476,  472, 
          472,  472,  472,  472,  472,  472,  476,  476,    0,  476, 
          476,  476,  476,  476,    0,  472,    0,    0,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,    0,  472, 
          472,    0,  472,  472,  472,  476,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,    0, 
            0,  476,  476,  476,  472,    0,  476,  472,  472,  476, 
          472,  472,  476,  472,  476,  472,  476,  472,  476,  472, 
          476,  476,  476,  476,  476,  476,  476,  472,  476,  476, 
          476,    0,  472,  472,  472,  472,  472,  472,  471,  471, 
          471,    0,  471,  273,  273,  273,  471,  471,  273,  273, 
          273,  471,  273,  471,  471,  471,  471,  471,  471,  471, 
            0,  471,  273,  273,  471,  471,  471,  471,  471,  471, 
          471,  273,  273,    0,  273,  273,  273,  273,  273,    0, 
          471,    0,    0,  471,  471,  471,  471,  471,  471,  471, 
          471,  471,  471,    0,  471,  471,    0,  471,  471,  471, 
          273,  273,  273,  273,  273,  273,  273,  273,  273,  273, 
          273,  273,  273,  273,    0,    0,  273,  273,  273,  471, 
            0,  273,  471,  471,  273,  471,  471,  273,  471,  273, 
          471,  273,  471,  273,  471,  273,  273,  273,  273,  273, 
          273,  273,  471,  273,  471,  273,  477,  471,  471,  471, 
          471,  471,  471,    0,  131,    0,  477,  131,  131,  131, 
            0,    0,    0,    0,    0,  132,    0,    0,  132,  132, 
          132,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          421,    0,    0,    0,    0,    0,    0,  421,    0,    0, 
          477,  420,  131,    0,    0,    0,    0,    0,  420,  131, 
          131,  131,  131,  132,  477,  477,    0,    0,    0,  477, 
          132,  132,  132,  132,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  477,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,  478,   12,   13,   14,   96,   97,   17,   18,    0, 
            0,  478,    0,   98,   99,  100,   22,   23,   24,   25, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  101, 
            0,    0,   31,   32,  102,   34,   35,   36,  103,   38, 
           39,   40,    0,   41,   42,  478,    0,    0,  104,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  478, 
          478,    0,    0,    0,  478,  105,    0,    0,  106,    0, 
            0,  107,  313,    0,   48,   49,    0,   50,    0,    0, 
           95,    0,    0,    0,    0,    0,    0,    0,  326,  327, 
            0,   96,  478,    0,    0,    0,   54,   55,   56,   57, 
           58,   59,    0,  328,    0,  329,    0,  330,  331,  332, 
          333,    0,    0,  336,    0,  337,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   95, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           96,    0,    0,  474,  474,  474,    0,  474,  477,  477, 
          477,  474,  474,  477,  477,  477,  474,  477,  474,  474, 
          474,  474,  474,  474,  474,    0,  477,  477,  477,  474, 
          474,  474,  474,  474,  474,  474,  477,  477,    0,  477, 
          477,  477,  477,  477,    0,  474,    0,    0,  474,  474, 
          474,  474,  474,  474,  474,  474,  474,  474,    0,  474, 
          474,    0,  474,  474,  474,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,  477,  477,  477,    0, 
            0,  477,  477,  477,  474,    0,  477,  474,  474,  477, 
          474,  474,  477,  474,  477,  474,  477,  474,  477,  474, 
          477,  477,  477,  477,  477,  477,  477,  474,  477,  477, 
          477,    0,  474,  474,  474,  474,  474,  474,  475,  475, 
          475,    0,  475,  478,  478,  478,  475,  475,  478,  478, 
          478,  475,  478,  475,  475,  475,  475,  475,  475,  475, 
            0,  478,  478,  478,  475,  475,  475,  475,  475,  475, 
          475,  478,  478,    0,  478,  478,  478,  478,  478,    0, 
          475,    0,    0,  475,  475,  475,  475,  475,  475,  475, 
          475,  475,  475,    0,  475,  475,    0,  475,  475,  475, 
          478,  478,  478,  478,  478,  478,  478,  478,  478,  478, 
          478,  478,  478,  478,    0,    0,  478,  478,  478,  475, 
            0,  478,  475,  475,  478,  475,  475,  478,  475,  478, 
          475,  478,  475,  478,  475,  478,  478,  478,  478,  478, 
          478,  478,  475,  478,  478,  478,  349,  475,  475,  475, 
          475,  475,  475,    0,   95,    0,  349,   95,   95,   95, 
            0,    0,    0,    0,    0,   96,    0,    0,   96,   96, 
           96,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          411,    0,    0,    0,    0,    0,    0,  411,    0,    0, 
          349,  414,   95,    0,    0,    0,    0,    0,  414,   95, 
           95,   95,   95,   96,  349,  349,    0,    0,    0,  349, 
           96,   96,   96,   96,  515,  516,    0,    0,  517,    0, 
            0,    0,    0,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,  349,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,  492,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,  492,  185,    0,    0,  186,    0,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   96, 
           97,   17,   18,    0,    0,  492,    0,   98,   20,   21, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,  492, 
          492,    0,    0,   28,  492,    0,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,   40,    0,   41,   42,    0, 
           43,   44,   45,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  492,    0,    0,    0,    0,    0,    0,   77, 
            0,    0,  207,    0,    0,  107,    0,  414,   48,   49, 
            0,   50,    0,  231,    0,  232,   77,   52,    0,    0, 
            0,    0,    0,    0,    0,  233,    0,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    0,    0,    0,    0, 
            0,    0,    0,  250,  250,  250,  476,  250,  349,  349, 
          349,  250,  250,  349,  349,  349,  250,  349,  250,  250, 
          250,  250,  250,  250,  250,    0,  349,  349,  349,  250, 
          250,  250,  250,  250,  250,  250,  349,  349,    0,  349, 
          349,  349,  349,  349,    0,  250,    0,    0,  250,  250, 
          250,  250,  250,  250,  250,  250,  250,  250,    0,  250, 
          250,    0,  250,  250,  250,  349,  349,  349,  349,  349, 
          349,  349,  349,  349,  349,  349,  349,  349,  349,    0, 
            0,  349,  349,  349,  250,    0,  349,  250,    0,  349, 
          250,  250,  349,  250,  349,  250,  349,  250,  349,  250, 
          349,  349,  349,  349,  349,  349,  349,  250,  349,  349, 
          349,    0,  250,  250,  250,  250,  250,  250,  250,  250, 
          250,    0,  250,  492,  492,  492,  250,  250,  492,  492, 
          492,  250,  492,  250,  250,  250,  250,  250,  250,  250, 
            0,  492,  492,  492,  250,  250,  250,  250,  250,  250, 
          250,  492,  492,    0,  492,  492,  492,  492,  492,    0, 
          250,    0,    0,  250,  250,  250,  250,  250,  250,  250, 
          250,  250,  250,    0,  250,  250,    0,  250,  250,  250, 
          492,  492,  492,  492,  492,  492,  492,  492,  492,  492, 
          492,  492,  492,  492,   77,  476,  492,  492,  492,  250, 
            0,  492,  250,    0,  492,  250,  250,  492,  250,  492, 
          250,  492,  250,  492,  250,  492,  492,  492,  492,  492, 
          492,  492,  250,  492,  492,  492,  278,  250,  250,  250, 
          250,  250,  250,    0,    0,    0,  278,    0,    0,    0, 
            0,    0,    0,    0,    0,  476,    0,    0,    0,    0, 
            0,    0,  476,    0,    0,    0,    0,  472,   77,    0, 
            0,    0,    0,  313,  314,  315,  316,  317,  318,  319, 
          278,    0,  322,  323,    0,   77,    0,    0,  476,  326, 
          327,    0,    0,    0,  278,  278,    0,   87,    0,  278, 
            0,    0,    0,    0,  328,    0,  329,    0,  330,  331, 
          332,  333,  334,  335,  336,    0,  337,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  278,    0,    0, 
            0,    0,    0,    0,    0,    0,    3,    4,    5,    6, 
            7,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,  286,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,  286,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
           29,   30,   31,   32,   33,   34,   35,   36,   37,   38, 
           39,   40,    0,   41,   42,  286,   43,   44,   45,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  286, 
          286,    0,    0,    0,  286,    0,    0,    0,   46,    0, 
            0,   47,    0,    0,   48,   49, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

            0,   50,    0,   51,    0,    0,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,   53,  286,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  216,    0,    0,    0,    0,    0,  473,  473,  473, 
            0,  473,  278,  278,  278,  473,  473,  278,  278,  278, 
          473,  278,  473,  473,  473,  473,  473,  473,  473,    0, 
            0,  278,  278,  473,  473,  473,  473,  473,  473,  473, 
          278,  278,    0,  278,  278,  278,  278,  278,    0,  473, 
          217,    0,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,    0,  473,  473,    0,  473,  473,  473,  278, 
          278,  278,  278,  278,  278,  278,  278,  278,  278,  278, 
          278,  278,  278,    0,    0,  278,  278,  278,  473,    0, 
          278,  473,  473,  278,  473,  473,  278,  473,  278,  473, 
          278,  473,  278,  473,  278,  278,  278,  278,  278,  278, 
          278,  473,  278,    0,  278,    0,  473,  473,  473,  473, 
          473,  473,  250,  250,  250,    0,  250,  286,  286,  286, 
          250,  250,  286,  286,  286,  250,  286,  250,  250,  250, 
          250,  250,  250,  250,  610,    0,  286,  286,  250,  250, 
          250,  250,  250,  250,  250,  286,  286,    0,  286,  286, 
          286,  286,  286,  338,  250,    0,    0,  250,  250,  250, 
          250,  250,  250,  250,  250,  250,  250,    0,  250,  250, 
            0,  250,  250,  250,  286,  286,  286,  286,  286,  286, 
          286,  286,  286,  286,  286,  286,  286,  286,    0,    0, 
          286,  286,  286,  250,    0,  286,  250,    0,  286,  250, 
          250,  286,  250,  286,  250,  286,  250,  286,  250,  286, 
          286,  286,  286,  286,  286,  286,  250,  286,  472,  286, 
            0,  250,  250,  250,  250,  250,  250,    0,  472,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,   76,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,  472,    0,   84, 
           28,  472,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  472, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
            0,    0,    0,  473,   52,    0,    0,    0,    0,    0, 
            0,    0,   53,  473,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,    0,    0,    0,    0,   78,  326,  327, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  473,  328,   86,  329,  473,  330,  331,  332, 
          333,  334,  335,  336,    0,  337,    0,    0,    0,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
            0,  324,  325,    0,  473,  326,  327,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          328,    0,  329,    0,  330,  331,  332,  333,  334,  335, 
          336,  662,  337,    0,    0,    0,  338,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  472,  472,  472,    0,  472, 
          472,  472,  472,  472,  472,    0,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,    0,  472,    0, 
            0,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
            0,  472,  472,  472,  472,  472,    0,  472,    0,    0, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
            0,  472,  472,    0,  472,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,    0,    0,  472,  472,  472,  472,    0,    0,  472, 
          472,  472,  472,  472,    0,  472,    0,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,  472,  472,    0,  472,  472,  472,  472,  472,  472, 
          473,  473,  473,    0,  473,  473,  473,  473,  473,  473, 
            0,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,    0,  473,    0,    0,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,    0,  473,  473,  473,  473, 
          473,    0,  473,    0,    0,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,    0,  473,  473,    0,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,    0,    0,  473,  473, 
          473,  473,    0,    0,  473,  473,  473,  473,  473,    0, 
          473,    0,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  476,  473, 
          473,  473,  473,  473,  473,    0,    0,    0,  476,    0, 
            0,    0,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,    0,  324,  325,    0,    0,  326,  327, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   77,  328,    0,  329,    0,  330,  331,  332, 
          333,  334,  335,  336,    0,  337,    0,  476,    0,   85, 
            0,  476,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  476, 
            0,    0,    0,    0,    0,    0,    0,    0,    3,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,  278,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,  278,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,   29,   30,   31,   32,   33,   34,   35,   36, 
           37,   38,   39,   40,    0,   41,   42,   79,   43,   44, 
           45,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  278,    0,   87,    0,  278,    0,    0,    0, 
           46,    0,    0,  264,    0,    0,   48,   49,    0,   50, 
            0,   51,    0,    0,    0,   52,    0,    0,    0,    0, 
            0,    0,    0,   53,  278,    0,    0,    0,   54,   55, 
           56,   57,   58,   59,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          492,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          492,    0,    0,    0,    0,  472,  472,  472,    0,  472, 
          476,  476,  476,  472,  472,    0,  476,  476,  472,  476, 
          472,  472,  472,  472,  472,  472,  472,    0,  476,    0, 
            0,  472,  472,  472,  472,  472,  472,  472,  476,  476, 
            0,  476,  476,  476,  476,  476,    0,  472,  492,  492, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
            0,  472,  472,    0,  472,  472,  472,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,  476, 
          476,    0,    0,  476,  476,  476,  472,    0,    0,  472, 
          472,  476,  472,  472,    0,  472,    0,  472,  476,  472, 
          476,  472,  476,  476,  476,  476,  476,  476,  476,  472, 
          476,  476,  476,    0,  472,  472,  472,  472,  472,  472, 
          473,  473,  473,    0,  473,  278,  278,  278,  473,  473, 
            0,  278,  278,  473,  278,  473,  473,  473,  473,  473, 
          473,  473,    0,    0,    0,    0,  473,  473,  473,  473, 
          473,  473,  473,  278,  278,    0,  278,  278,  278,  278, 
          278,    0,  473,    0,    0,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,    0,  473,  473,    0,  473, 
          473,  473,  278,  278,  278,  278,  278,  278,  278,  278, 
          278,  278,  278,  278,  278,  278,    0,    0,  278,  278, 
          278,  473,    0,    0,  473,  473,  278,  473,  473,    0, 
          473,    0,  473,  278,  473,  278,  473,  278,  278,  278, 
          278,  278,  278,  278,  473,  278,    0,  278,    0,  473, 
          473,  473,  473,  473,  473,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  250,  250,  250, 
            0,  250,  492,  492,  492,  250,  250,  492,  492,  492, 
          250,  492,  250,  250,  250,  250,  250,  250,  250,    0, 
            0,  492,    0,  250,  250,  250,  250,  250,  250,  250, 
          492,  492,    0,  492,  492,  492,  492,  492,    0,  250, 
            0,    0,  250,  250,  250,  250,  250,  250,  250,  250, 
          250,  250,    0,  250,  250,  349,  250,  250,  250,    0, 
            0,    0,    0,    0,    0,  349,    0,    0,    0,    0, 
          492,    0,    0,    0,    0,    0,    0,  492,  250,    0, 
            0,  250,    0,  492,  250,  250,    0,  250,    0,  250, 
            0,  250,    0,  250,    0,    0,    0,    0,    0,  349, 
            0,  250,    0,    0,  492,    0,  250,  250,  250,  250, 
          250,  250,    0,  349,  349,    0,    0,    0,  349,    0, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,  349,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,  422,   26, 
            0,    0,    0,    0,    0,    0,   28,    0,  422,   31, 
           32,   33,   34,   35,   36,   37,   38,   39,   40,    0, 
           41,   42,    0,   43,   44,   45,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  422,    0,    0,  207,    0,    0,  107,    0, 
            0,   48,   49,    0,   50,    0,  422,  422,    0,   82, 
           52,  422,    0,    0,    0,    0,    0,    0,   53,    0, 
            0,    0,    0,   54,   55,   56,   57,   58,   59,  522, 
          511,    0,    0,  523,    0,    0,    0,    0,    0,  422, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,  492,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,  492,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,    0,    0, 
          186,    0,    0,    0,    0,    0,  492,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  349,  349,  349, 
          492,  492,  349,  349,  349,  492,  349,    0,    0,    0, 
            0,    0,    0,    0,    0,  349,  349,  349,    0,    0, 
            0,    0,    0,    0,    0,  349,  349,    0,  349,  349, 
          349,  349,  349,  492,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  349,  349,  349,  349,  349,  349, 
          349,  349,  349,  349,  349,  349,  349,  349,    0,    0, 
          349,  349,  349,    0,    0,  349,    0,    0,  349,    0, 
            0,  349,    0,  349,    0,  349,  183,  349,    0,  349, 
          349,  349,  349,  349,  349,  349,  183,  349,  349,  349, 
          422,  422,  422,    0,    0,  422,  422,  422,    0,  422, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  422, 
          422,    0,    0,    0,    0,    0,    0,    0,  422,  422, 
          183,  422,  422,  422,  422,  422,    0,    0,    0,    0, 
            0,    0,    0,    0,  183,  183,    0,    0,    0,  183, 
            0,    0,    0,    0,    0,    0,    0,  422,  422,  422, 
          422,  422,  422,  422,  422,  422,  422,  422,  422,  422, 
          422,    0,    0,  422,  422,  422,    0,  423,  422,    0, 
            0,  422,    0,    0,  422,    0,  422,    0,  422,  493, 
          422,    0,  422,  422,  422,  422,  422,  422,  422,  493, 
          422,    0,  422,    0,  492,  492,  492,    0,    0,  492, 
          492,  492,    0,  492,    0,    0,    0,    0,    0,    0, 
            0,    0,  492,  492,  492,    0,    0,    0,    0,    0, 
            0,    0,  492,  492,    0,  492,  492,  492,  492,  492, 
            0,    0,    0,    0,    0,    0,    0,  493,  493,  272, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  272, 
            0,  492,  492,  492,  492,  492,  492,  492,  492,  492, 
          492,  492,  492,  492,  492,    0,    0,  492,  492,  492, 
            0,    0,  492,    0,    0,  492,    0,    0,  492,    0, 
          492,    0,  492,  272,  492,    0,  492,  492,  492,  492, 
          492,  492,  492,    0,  492,  492,  492,  272,  272,    0, 
           89,    0,  272,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          272,    0,    0,    0,    0,    0,    0,    0,  183,  183, 
          183,    0,  422,  183,  183,  183,    0,  183,    0,    0, 
            0,    0,  422,    0,    0,    0,    0,  183,  183,    0, 
            0,    0,    0,    0,    0,    0,  183,  183,    0,  183, 
          183,  183,  183,  183,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  422,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  422,    0,   82,    0,  422,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  183,    0,    0,  183, 
            0,    0,  183,    0,  183,    0,    0,    0,    0,    0, 
            0,    0,    0,  422,    0,    0,    0,    0,    0,    0, 
          183,  493,  493,  493,    0,    0,  493,  493,  493,    0, 
          493,    0,    0,  279,    0,    0,    0,    0,    0,    0, 
          493,  493,    0,  279,    0,    0,    0,    0,    0,  493, 
          493,    0,  493,  493,  493,  493,  493,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  279,    0,    0, 
            0,  272,  272,  272,    0,    0,  272,  272,  272,    0, 
          272,  279,  279,    0,   88,    0,  279,    0,    0,    0, 
          272,  272,  493,    0,    0,  493,    0,  493,    0,  272, 
          272,    0,  272,  272,  272,  272,  272,    0,    0,    0, 
            0,    0,    0,  493,  279,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  272,  272, 
          272,  272,  272,  272,  272,  272,  272,  272,  272,  272, 
          272,  272,    0,    0,  272,  272,  272,    0,    0,  272, 
            0,    0,  272,    0,    0,  272,    0,  272,    0,  272, 
            0,  272,    0,  272,  272,  272,  272,  272,  272,  272, 
            0,  272,    0,  272,  422,  422,  422,    0,    0,  422, 
          422,  422,    0,  422,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  422,  422,    0,    0,    0,    0,    0, 
            0,    0,  422,  422,    0,  422,  422,  422,  422,  422, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  280, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  280, 
            0,  422,  422,  422,  422,  422,  422,  422,  422,  422, 
          422,  422,  422,  422,  422,    0,    0,  422,  422,  422, 
            0,  423,  422,    0,    0,  422,    0,    0,  422,    0, 
          422,    0,  422,  280,  422,    0,  422,  422,  422,  422, 
          422,  422,  422,    0,  422,    0,  422,  280,  280,    0, 
           83,    0,  280,    0,    0,  279,  279,  279,    0,    0, 
          279,  279,  279,    0,  279,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  279,  279,    0,    0,    0,    0, 
          280,    0,    0,  279,  279,    0,  279,  279,  279,  279, 
          279,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          372,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          372,    0,  279,  279,  279,  279,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,  279,    0,    0,  279,  279, 
          279,    0,    0,  279,    0,    0,  279,    0,    0,  279, 
            0,  279,    0,  279,  372,  279,    0,  279,  279,  279, 
          279,  279,  279,  279,    0,  279,    0,  279,  372,  372, 
            0,    0,    0,  372,    0,    0,  549,  516,    0,    0, 
          550,    0,    0,    0,    0,    0,    0,    0,  160,  161, 
            0,  162,  163,  164,  165,    0,  166,  167,    0,    0, 
          168,  372,    0,    0,    0,  169,  170,  171,  172,    0, 
            0,    0,    0,  289,    0,    0,    0,    0,    0,    0, 
            0,  174,  175,  289,  176,  177,  178,  179,  180,  181, 
          182,  183,  184,    0,  185,    0,    0,  186,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  289,    0,    0, 
            0,  280,  280,  280,    0,    0,  280,  280,  280,    0, 
          280,  289,  289,    0,    0,    0,  289,    0,    0,    0, 
          280,  280,    0,    0,    0,    0,    0,    0,    0,  280, 
          280,    0,  280,  280,  280,  280,  280,    0,    0,    0, 
            0,    0,    0,    0,  289,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  280,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,    0,    0,  280,  280,  280,    0,    0,  280, 
            0,    0,  280,    0,    0,  280,    0,  280,    0,  280, 
            0,  280,  215,  280,  280,  280,  280,  280,  280,  280, 
            0,  280,  215,  280,    0,    0,    0,    0,    0,    0, 
            0,    0,  372,  372,  372,    0,    0,  372,  372,  372, 
            0,  372,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  372,  372,    0,    0,    0,  215,    0,    0,    0, 
          372,  372,    0,  372,  372,  372,  372,  372,    0,    0, 
          215,  215,    0,    0,    0,  215,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  372, 
          372,  372,  372,  372,  372,  372,  372,  372,  372,  372, 
          372,  372,  372,  321,    0,  372,  372,  372,    0,    0, 
          372,    0,    0,  372,    0,    0,  372,    0,  372,    0, 
          372,  286,  372,    0,  372,  372,  372,  372,  372,  372, 
          372,  286,  372,    0,  372,  289,  289,  289,    0,    0, 
          289,  289,  289,    0,  289,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  289,  289,    0,    0,    0,    0, 
            0,    0,    0,  289,  289,  286,  289,  289,  289,  289, 
          289,    0,    0,    0,    0,    0,    0,    0,    0,  286, 
          286,    0,    0,    0,  286,    0,    0,    0,    0,    0, 
            0,    0,  289,  289,  289,  289,  289,  289,  289,  289, 
          289,  289,  289,  289,  289,  289,    0,    0,  289,  289, 
          289,    0,  286,  289,    0,    0,  289,    0,    0,  289, 
            0,  289,    0,  289,    0,  289,  409,  289,  289,  289, 
          289,  289,  289,  289,    0,  289,  409,  289,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          409,    0,    0,    0,  215,  215,  215,    0,    0,  215, 
          215,  215,    0,  215,  409,  409,    0,    0,    0,  409, 
            0,    0,    0,  215,  215,    0,    0,    0,    0,    0, 
            0,    0,  215,  215,    0,  215,  215,  215,  215,  215, 
            0,    0,    0,    0,    0,    0,    0,  409,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  215,  215,  215,  215,  215,  215,  215,  215,  215, 
          215,  215,  321,  215,  215,    0,    0,  215,  215,  321, 
            0,    0,  215,    0,    0,  215,    0,    0,  215,    0, 
          215,    0,  215,  410,  215,    0,  215,  215,  215,  215, 
          215,  215,  215,  410,  215,    0,  215,    0,    0,    0, 
            0,    0,    0,  286,  286,  286,    0,    0,  286,  286, 
          286,    0,  286,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  286,  286,    0,    0,    0,  410,    0,    0, 
            0,  286,  286,    0,  286,  286,  286,  286,  286,    0, 
            0,  410,  410,    0,    0,    0,  410,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          286,  286,  286,  286,  286,  286,  286,  286,  286,  286, 
          286,  286,  286,  286,  410,    0,  286,  286,  286,    0, 
            0,  286,    0,    0,  286,    0,    0,  286,    0,  286, 
            0,  286,    0,  286,  317,  286,  286,  286,  286,  286, 
          286,  286,    0,  286,  317,  286,    0,    0,  409,  409, 
          409,    0,    0,  409,  409,  409,    0,  409,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  409,  409,    0, 
            0,    0,    0,    0,    0,    0,  409,  409,  317,  409, 
          409,  409,  409,  409,    0,    0,    0,    0,    0,    0, 
            0,    0,  317,  317,    0,    0,    0,  317,    0,    0, 
            0,    0,    0,    0,    0,    0,  409,  409,  409,  409, 
          409,  409,  409,  409,  409,  409,  409,  409,  409,    0, 
            0,  409,  409,  409,    0,  317,  409,    0,    0,  409, 
            0,    0,  409,    0,  409,    0,  409,  318,  409,    0, 
          409,  409,  409,  409,  409,  409,  409,  318,  409,    0, 
          409,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  318,    0,    0,    0,  410,  410,  410,    0,    0, 
          410,  410,  410,    0,  410,  318,  318,    0,    0,    0, 
          318,    0,    0,    0,  410,  410,    0,    0,    0,    0, 
            0,    0,    0,  410,  410,    0,  410,  410,  410,  410, 
          410,    0,    0,    0,    0,    0,    0,    0,  318,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  410,  410,  410,  410,  410,  410,  410, 
          410,  410,  410,  410,  410,  410,    0,    0,  410,  410, 
          410,    0,    0,  410,    0,    0,  410,    0,    0,  410, 
            0,  410,    0,  410,    0,  410,  283,  410,  410,  410, 
          410,  410,  410,  410,    0,  410,  283,  410,    0,    0, 
            0,    0,    0,    0,    0,    0,  317,  317,  317,    0, 
            0,  317,  317,  317,    0,  317,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  317,    0,    0,    0,    0, 
          283,    0,    0,    0,  317,  317,    0,  317,  317,  317, 
          317,  317,    0,    0,  283,  283,    0,    0,    0,  283, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  317,  317,  317,  317,  317,  317,  317, 
          317,  317,  317,  317,  317,  317,  317,  283,    0,  317, 
          317,  317,    0,    0,  317,    0,    0,  317,    0,    0, 
            0,    0,    0,    0,  317,  193,  317,    0,  317,  317, 
          317,  317,  317,  317,  317,  193,  317,    0,  317,  318, 
          318,  318,    0,    0,  318,  318,  318,    0,  318,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  318,    0, 
            0,    0,    0,    0,    0,    0,    0,  318,  318,  193, 
          318,  318,  318,  318,  318,    0,    0,    0,    0,    0, 
            0,    0,    0,  193,  193,    0,    0,    0,  193,    0, 
            0,    0,    0,    0,    0,    0,  318,  318,  318,  318, 
          318,  318,  318,  318,  318,  318,  318,  318,  318,  318, 
            0,    0,  318,  318,  318,    0,    0,  318,    0,    0, 
          318,    0,    0,    0,    0,    0,    0,  318,    0,  318, 
          189,  318,  318,  318,  318,  318,  318,  318,    0,  318, 
          189,  318,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  189,    0,    0,    0,  283,  283, 
          283,    0,    0,  283,  283,  283,    0,  283,  189,  189, 
            0,    0,    0,  189,    0,    0,    0,  283,    0,    0, 
            0,    0,    0,    0,    0,    0,  283,  283,    0,  283, 
          283,  283,  283,  283,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  283,  283,  283,  283,  283, 
          283,  283,  283,  283,  283,  283,  283,  283,  283,    0, 
            0,  283,  283,  283,  186,    0,  283,    0,    0,  283, 
            0,    0,    0,    0,  186,    0,  283,    0,  283,    0, 
          283,  283,  283,  283,  283,  283,  283,    0,  283,    0, 
          283,    0,    0,    0,    0,    0,    0,  193,  193,  193, 
            0,    0,  193,  193,  193,    0,  193,    0,  186,    0, 
            0,    0,    0,    0,    0,    0,  193,  193,    0,    0, 
            0,    0,  186,  186,    0,  193,  193,  186,  193,  193, 
          193,  193,  193,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  193,  193,  193,  193,  193, 
          193,  193,  193,  193,  193,    0,  193,  193,    0,  188, 
          193,  193,    0,    0,    0,  193,    0,    0,  193,  188, 
            0,  193,    0,  193,    0,  193,    0,  193,    0,  193, 
          193,  193,  193,  193,  193,  193,    0,  193,    0,  193, 
            0,    0,  189,  189,  189,    0,    0,  189,  189,  189, 
            0,  189,    0,  188,    0,    0,    0,    0,    0,    0, 
            0,  189,  189,    0,    0,    0,    0,  188,  188,    0, 
          189,  189,  188,  189,  189,  189,  189,  189,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          189,  189,  189,  189,  189,  189,  189,  189,  189,  189, 
            0,  189,  189,    0,    0,  189,  189,    0,    0,  187, 
          189,    0,    0,  189,    0,    0,  189,    0,  189,  187, 
          189,    0,  189,    0,  189,  189,  189,  189,  189,  189, 
          189,    0,  189,    0,  189,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  187,    0,    0,  186,  186,  186,    0, 
            0,  186,  186,  186,    0,  186,    0,  187,  187,    0, 
            0,    0,  187,    0,    0,  186,  186,    0,    0,    0, 
            0,    0,    0,    0,  186,  186,    0,  186,  186,  186, 
          186,  186,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  186,  186,  186,  186,  186,  186, 
          186,  186,  186,  186,    0,  186,  186,    0,  190,  186, 
          186,    0,    0,    0,  186,    0,    0,  186,  190,    0, 
          186,    0,  186,    0,  186,    0,  186,    0,  186,  186, 
          186,  186,  186,  186,  186,    0,  186,    0,  186,    0, 
            0,  188,  188,  188,    0,    0,  188,  188,  188,    0, 
          188,    0,  190,    0,    0,    0,    0,    0,    0,    0, 
          188,  188,    0,    0,    0,    0,  190,  190,    0,  188, 
          188,  190,  188,  188,  188,  188,  188,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  188, 
          188,  188,  188,  188,  188,  188,  188,  188,  188,    0, 
          188,  188,    0,    0,  188,  188,    0,    0,  191,  188, 
            0,    0,  188,    0,    0,  188,    0,  188,  191,  188, 
            0,  188,    0,  188,  188,  188,  188,  188,  188,  188, 
            0,  188,    0,  188,    0,    0,    0,    0,    0,    0, 
            0,  187,  187,  187,    0,    0,  187,  187,  187,    0, 
          187,    0,  191,    0,    0,    0,    0,    0,    0,    0, 
          187,  187,    0,    0,    0,    0,  191,  191,    0,  187, 
          187,  191,  187,  187,  187,  187,  187,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  187, 
          187,  187,  187,  187,  187,  187,  187,  187,  187,    0, 
          187,  187,    0,  422,  187,  187,    0,    0,    0,  187, 
            0,    0,  187,  422,    0,  187,    0,  187,    0,  187, 
            0,  187,    0,  187,  187,  187,  187,  187,  187,  187, 
            0,  187,    0,  187,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   74,    0,    0, 
          190,  190,  190,    0,    0,  190,  190,  190,    0,  190, 
            0,    0,  422,    0,   82,    0,  422,    0,    0,  190, 
          190,    0,    0,    0,    0,    0,    0,    0,  190,  190, 
            0,  190,  190,  190,  190,  190,    0,    0,    0,    0, 
            0,    0,    0,    0,  422,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  190,  190, 
          190,  190,  190,  190,  190,  190,  190,  190,    0,  190, 
          190,    0,    0,  190,  190,    0,    0,    0,  190,    0, 
            0,  190,    0,    0,  190,    0,  190,    0,  190,    0, 
          190,  272,  190,  190,  190,  190,  190,  190,  190,    0, 
          190,  272,  190,    0,    0,    0,    0,    0,    0,    0, 
          191,  191,  191,    0,    0,  191,  191,  191,    0,  191, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  191, 
          191,    0,    0,    0,    0,   81,    0,    0,  191,  191, 
            0,  191,  191,  191,  191,  191,    0,    0,    0,    0, 
          272,    0,   89,    0,  272,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  191,  191, 
          191,  191,  191,  191,  191,  191,  191,  191,    0,  191, 
          191,    0,  272,  191,  191,    0,    0,    0,  191,    0, 
            0,  191,    0,    0,  191,    0,  191,    0,  191,    0, 
          191,   52,  191,  191,  191,  191,  191,  191,  191,    0, 
          191,   52,  191,    0,    0,  422,  422,  422,    0,    0, 
            0,  422,  422,    0,  422,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  422,  422,    0,  422,  422,  422,  422, 
          422,    0,    0,    0,    0,  279,    0,    0,    0,   52, 
           52,    0,    0,    0,    0,  279,    0,    0,    0,    0, 
            0,    0,  422,  422,  422,  422,  422,  422,  422,  422, 
          422,  422,  422,  422,  422,  422,    0,    0,  422,  422, 
          422,    0,  423,    0,    0,    0,  422,    0,    0,   80, 
            0,    0,    0,  422,    0,  422,    0,  422,  422,  422, 
          422,  422,  422,  422,  279,  422,   88,  422,  279,    0, 
            0,    0,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,    0,    0,    0,    0,  280,    0,  313,  314, 
          315,  316,  317,  318,  319,  320,  280,  322,  323,  279, 
            0,    0,    0,    0,  326,  327,  272,  272,  272,    0, 
            0,    0,  272,  272,    0,  272,    0,    0,    0,  328, 
            0,  329,    0,  330,  331,  332,  333,  334,  335,  336, 
           75,  337,    0,    0,  272,  272,    0,  272,  272,  272, 
          272,  272,    0,    0,    0,  280,    0,   83,    0,  280, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  272,  272,  272,  272,  272,  272,  272, 
          272,  272,  272,  272,  272,  272,  272,  280,    0,  272, 
          272,  272,    0,    0,    0,    0,    0,  272,    0,    0, 
            0,    0,    0,    0,  272,  184,  272,    0,  272,  272, 
          272,  272,  272,  272,  272,  184,  272,    0,  272,    0, 
            0,    0,    0,    0,    0,    0,   52,   52,   52,    0, 
            0,   52,   52,   52,    0,   52,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   52,    0,    0,  184, 
            0,    0,    0,    0,   52,   52,    0,   52,   52,   52, 
           52,   52,    0,  184,  184,    0,    0,    0,  184,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          279,  279,  279,    0,    0,    0,  279,  279,    0,  279, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,  279,  279, 
           52,  279,  279,  279,  279,  279,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  185,    0,    0,   52,    0, 
            0,    0,    0,    0,    0,  185,    0,  279,  279,  279, 
          279,  279,  279,  279,  279,  279,  279,  279,  279,  279, 
          279,    0,    0,  279,  279,  279,    0,    0,  280,  280, 
          280,  279,    0,    0,  280,  280,    0,  280,  279,  185, 
          279,    0,  279,  279,  279,  279,  279,  279,  279,    0, 
          279,    0,  279,  185,  185,    0,  280,  280,  185,  280, 
          280,  280,  280,  280,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,    0, 
            0,  280,  280,  280,  209,    0,    0,    0,    0,  280, 
            0,    0,    0,    0,  209,    0,  280,    0,  280,    0, 
          280,  280,  280,  280,  280,  280,  280,    0,  280,    0, 
          280,    0,    0,    0,    0,    0,    0,  184,  184,  184, 
            0,    0,  184,  184,  184,    0,  184,    0,  209,    0, 
            0,    0,    0,    0,    0,    0,  184,  184,    0,    0, 
            0,    0,  209,  209,    0,  184,  184,  209,  184,  184, 
          184,  184,  184,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  184,  184,  184,  184,  184, 
          184,  184,  184,  184,  184,    0,  184,  184,    0,  210, 
          184,  184,    0,    0,    0,  184,    0,    0,  184,  210, 
            0,  184,    0,  184,    0,    0,    0,  184,    0,    0, 
            0,  184,  184,  184,  184,  184,    0,  184,    0,  184, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  210,    0,    0,    0,  185,  185,  185, 
            0,    0,  185,  185,  185,    0,  185,  210,  210,    0, 
            0,    0,  210,    0,    0,    0,  185,  185,    0,    0, 
            0,    0,    0,    0,    0,  185,  185,    0,  185,  185, 
          185,  185,  185,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  185,  185,  185,  185,  185, 
          185,  185,  185,  185,  185,    0,  185,  185,    0,    0, 
          185,  185,    0,    0,    0,  185,    0,    0,  185,    0, 
            0,  185,    0,  185,    0,    0,  196,  185,    0,    0, 
            0,  185,  185,  185,  185,  185,  196,  185,    0,  185, 
            0,    0,    0,    0,    0,    0,  209,  209,  209,    0, 
            0,  209,  209,  209,    0,  209,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  209,  209,    0,    0,    0, 
          196,    0,    0,    0,  209,  209,    0,  209,  209,  209, 
          209,  209,    0,    0,  196,  196,    0,    0,    0,  196, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  209,  209,  209,  209,  209,  209, 
          209,  209,  209,  209,    0,  209,  209,    0,    0,  209, 
          209,    0,    0,    0,  209,    0,    0,  209,    0,  194, 
          209,    0,  209,    0,    0,    0,  209,    0,    0,  194, 
            0,    0,  209,  209,  209,    0,  209,    0,  209,    0, 
            0,  210,  210,  210,    0,    0,  210,  210,  210,    0, 
          210,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          210,  210,    0,  194,    0,    0,    0,    0,    0,  210, 
          210,    0,  210,  210,  210,  210,  210,  194,  194,    0, 
            0,    0,  194,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  210, 
          210,  210,  210,  210,  210,  210,  210,  210,  210,    0, 
          210,  210,    0,    0,  210,  210,    0,    0,    0,  210, 
            0,    0,  210,  195,    0,  210,    0,  210,    0,    0, 
            0,  210,    0,  195,    0,    0,    0,  210,  210,  210, 
            0,  210,    0,  210,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  195,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  196,  196, 
          196,  195,  195,  196,  196,  196,  195,  196,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  196,  196,    0, 
            0,    0,    0,    0,    0,    0,  196,  196,    0,  196, 
          196,  196,  196,  196,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  196,  196,  196,  196, 
          196,  196,  196,  196,  196,  196,    0,  196,  196,    0, 
            0,    0,    0,    0,    0,    0,  196,    0,    0,  196, 
          199,    0,  196,    0,  196,    0,    0,    0,  196,    0, 
          199,    0,    0,    0,  196,  196,  196,    0,  196,    0, 
          196,  194,  194,  194,    0,    0,  194,  194,  194,    0, 
          194,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          194,  194,    0,    0,  199,    0,    0,    0,    0,  194, 
          194,    0,  194,  194,  194,  194,  194,    0,  199,  199, 
            0,    0,    0,  199,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  194, 
          194,  194,  194,  194,  194,  194,  194,  194,  194,    0, 
          194,  194,    0,    0,    0,    0,    0,    0,    0,  194, 
            0,    0,  194,  201,    0,  194,    0,  194,    0,    0, 
            0,    0,    0,  201,    0,    0,    0,  194,  194,  194, 
            0,  194,    0,  194,    0,  195,  195,  195,    0,    0, 
          195,  195,  195,    0,  195,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  195,  195,    0,  201,    0,    0, 
            0,    0,    0,  195,  195,    0,  195,  195,  195,  195, 
          195,  201,  201,    0,    0,    0,  201,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  195,  195,  195,  195,  195,  195,  195, 
          195,  195,  195,    0,  195,  195,    0,    0,    0,    0, 
            0,    0,  200,  195,    0,    0,  195,    0,    0,  195, 
            0,  195,  200,    0,    0,    0,    0,    0,    0,    0, 
            0,  195,  195,  195,    0,  195,    0,  195,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  200,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          200,  200,  199,  199,  199,  200,    0,  199,  199,  199, 
            0,  199,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  199,  199,    0,    0,    0,    0,    0,    0,    0, 
          199,  199,    0,  199,  199,  199,  199,  199,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          199,  199,  199,  199,  199,  199,  199,  199,  199,  199, 
            0,  199,  199,    0,    0,    0,    0,    0,    0,    0, 
          199,    0,    0,  199,  198,    0,  199,    0,  199,    0, 
            0,    0,    0,    0,  198,    0,    0,    0,  199,  199, 
            0,    0,    0,    0,  199,  201,  201,  201,    0,    0, 
          201,  201,  201,    0,  201,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  201,  201,    0,    0,  198,    0, 
            0,    0,    0,  201,  201,    0,  201,  201,  201,  201, 
          201,    0,  198,  198,    0,    0,    0,  198,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  201,  201,  201,  201,  201,  201,  201, 
          201,  201,  201,    0,  201,  201,    0,    0,    0,    0, 
            0,    0,  197,  201,    0,    0,  201,    0,    0,  201, 
            0,  201,  197,    0,    0,    0,    0,    0,    0,    0, 
            0,  201,  201,    0,  200,  200,  200,  201,    0,  200, 
          200,  200,    0,  200,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  200,  200,    0,  197,    0,    0,    0, 
            0,    0,  200,  200,    0,  200,  200,  200,  200,  200, 
          197,  197,    0,    0,    0,  197,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  200,  200,  200,  200,  200,  200,  200,  200, 
          200,  200,    0,  200,  200,    0,  202,    0,    0,    0, 
            0,    0,  200,    0,    0,  200,  202,    0,  200,    0, 
          200,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          200,  200,    0,    0,    0,    0,  200,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          202,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  202,  202,    0,    0,    0,  202, 
            0,    0,    0,    0,    0,    0,  198,  198,  198,    0, 
            0,  198,  198,  198,    0,  198,    0,    0,    0,    0, 
            0,    0,    0,   54,    0,  198,  198,    0,    0,    0, 
            0,    0,    0,   54,  198,  198,    0,  198,  198,  198, 
          198,  198,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  198,  198,  198,  198,  198,  198, 
          198,  198,  198,  198,    0,  198,  198,    0,    0,    0, 
            0,   54,   54,  203,  198,    0,    0,  198,    0,    0, 
          198,    0,  198,  203,    0,    0,    0,    0,    0,    0, 
            0,    0,  198,  198,  197,  197,  197,    0,  198,  197, 
          197,  197,    0,  197,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  197,  197,    0,    0,  203,    0,    0, 
            0,    0,  197,  197,    0,  197,  197,  197,  197,  197, 
            0,  203,  203,    0,    0,    0,  203,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  197,  197, 
            0,    0,    0,  197,  197,    0,    0,  204,    0,    0, 
            0,    0,  197,    0,    0,  197,    0,  204,  197,    0, 
          197,    0,    0,    0,    0,    0,    0,    0,  202,  202, 
          202,    0,    0,  202,  202,  202,  197,  202,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  202,  202,    0, 
            0,  204,    0,    0,    0,    0,  202,  202,    0,  202, 
          202,  202,  202,  202,    0,  204,  204,    0,    0,    0, 
          204,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  202,  202,  211,    0,    0,  202,  202,    0, 
            0,    0,    0,    0,  211,    0,  202,    0,    0,  202, 
            0,    0,  202,    0,  202,   54,   54,   54,    0,    0, 
           54,   54,   54,    0,   54,    0,    0,    0,    0,    0, 
          202,    0,    0,    0,   54,   54,    0,    0,  211,    0, 
            0,    0,    0,   54,   54,    0,   54,   54,   54,   54, 
           54,    0,  211,  211,    0,    0,    0,  211,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  203,  203,  203,    0,    0, 
          203,  203,  203,  205,  203,    0,    0,    0,    0,    0, 
            0,    0,    0,  205,  203,  203,   54,    0,    0,   54, 
            0,    0,    0,  203,  203,    0,  203,  203,  203,  203, 
          203,    0,    0,    0,    0,    0,    0,   54,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  205,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  203, 
          203,  205,  205,    0,  203,  203,  205,    0,    0,    0, 
            0,    0,    0,  203,    0,    0,  203,    0,    0,  203, 
            0,  203,    0,    0,    0,    0,    0,    0,    0,  204, 
          204,  204,  206,    0,  204,  204,  204,  203,  204,    0, 
            0,    0,  206,    0,    0,    0,    0,    0,  204,  204, 
            0,    0,    0,    0,    0,    0,    0,  204,  204,    0, 
          204,  204,  204,  204,  204,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  206,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          206,  206,    0,  204,  204,  206,    0,    0,  204,  204, 
            0,    0,    0,    0,    0,    0,    0,  204,    0,    0, 
          204,    0,    0,  204,    0,  204,  211,  211,  211,  212, 
            0,  211,  211,  211,    0,  211,    0,    0,    0,  212, 
            0,  204,    0,    0,    0,  211,  211,    0,    0,    0, 
            0,    0,    0,    0,  211,  211,    0,  211,  211,  211, 
          211,  211,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  212,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  212,  212,    0, 
          211,  211,  212,    0,    0,  211,  211,    0,    0,    0, 
            0,    0,    0,    0,  211,    0,    0,  211,    0,    0, 
          211,    0,  211,    0,    0,  205,  205,  205,    0,  216, 
          205,  205,  205,    0,  205,    0,    0,    0,  211,  216, 
            0,    0,    0,    0,  205,  205,    0,    0,    0,    0, 
            0,    0,    0,  205,  205,    0,  205,  205,  205,  205, 
          205,    0,    0,    0,    0,    0,  213,    0,    0,    0, 
            0,    0,    0,  216,    0,    0,  213,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  216,  216,  205, 
          205,    0,    0,    0,  205,  205,    0,    0,    0,    0, 
            0,    0,    0,  205,    0,    0,  205,    0,    0,  205, 
          213,  205,    0,    0,  206,  206,  206,    0,    0,  206, 
          206,  206,    0,  206,  213,  213,    0,  205,    0,    0, 
            0,    0,    0,  206,  206,    0,    0,    0,    0,    0, 
            0,    0,  206,  206,    0,  206,  206,  206,  206,  206, 
            0,    0,    0,  181,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  181,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  206,  206, 
            0,    0,    0,  206,  206,    0,    0,    0,    0,    0, 
            0,    0,  206,    0,  174,  206,    0,  181,  206,    0, 
          206,  212,  212,  212,  174,    0,  212,  212,  212,    0, 
          212,  181,  181,    0,    0,    0,  206,    0,    0,    0, 
          212,  212,    0,    0,    0,    0,    0,    0,    0,  212, 
          212,    0,  212,  212,  212,  212,  212,    0,  174,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  174,  174,    0,    0,    0,  180,    0,    0, 
            0,    0,    0,    0,    0,    0,  212,  180,    0,    0, 
          212,  212,    0,    0,    0,    0,    0,    0,    0,  212, 
            0,    0,  212,    0,    0,  212,    0,  212,    0,    0, 
            0,  216,  216,  216,    0,    0,  216,  216,  216,    0, 
          216,  180,    0,  212,    0,    0,    0,    0,    0,    0, 
          216,  216,    0,    0,    0,  180,  180,    0,    0,  216, 
          216,    0,  216,  216,  216,  216,  216,    0,  213,  213, 
          213,    0,    0,  213,  213,  213,    0,  213,    0,    0, 
            0,    0,    0,    0,  214,    0,    0,  213,  213,    0, 
            0,    0,    0,    0,  214,    0,  213,  213,    0,  213, 
          213,  213,  213,  213,    0,    0,    0,    0,    0,  216, 
            0,    0,  216,    0,    0,  216,    0,  216,    0,    0, 
            0,  176,    0,    0,    0,    0,    0,    0,  214,    0, 
            0,  176,    0,  216,    0,    0,    0,    0,    0,    0, 
            0,    0,  214,  214,    0,    0,  213,    0,    0,  213, 
            0,    0,  213,    0,  213,  181,  181,  181,    0,    0, 
          181,  181,  181,    0,  181,  176,    0,    0,    0,    0, 
          213,    0,    0,    0,  181,  181,    0,    0,    0,  176, 
          176,    0,    0,  181,  181,    0,  181,  181,  181,  181, 
          181,    0,    0,    0,    0,    0,  174,  174,  174,    0, 
            0,  174,  174,  174,    0,  174,    0,    0,    0,    0, 
            0,  177,    0,    0,    0,  174,  174,    0,    0,    0, 
            0,  177,    0,    0,  174,  174,    0,  174,  174,  174, 
          174,  174,    0,  181,    0,    0,  181,    0,    0,  181, 
            0,  181,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  178,    0,    0,  177,    0,  181,    0,  180, 
          180,  180,  178,    0,  180,  180,  180,    0,  180,  177, 
          177,    0,    0,    0,  174,    0,    0,  174,  180,  180, 
          174,    0,  174,    0,    0,    0,    0,  180,  180,    0, 
          180,  180,  180,  180,  180,    0,  178,    0,  174,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          178,  178,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  180,    0,    0, 
          180,    0,    0,  180,    0,  180,  214,  214,  214,    0, 
          179,  214,  214,  214,    0,  214,    0,    0,    0,    0, 
          179,  180,    0,    0,    0,  214,  214,    0,    0,    0, 
            0,    0,    0,    0,  214,  214,    0,  214,  214,  214, 
          214,  214,    0,  176,  176,  176,    0,  173,  176,  176, 
          176,    0,  176,    0,  179,    0,    0,  173,    0,    0, 
            0,    0,  176,  176,    0,    0,    0,    0,  179,  179, 
            0,  176,  176,    0,  176,  176,  176,  176,  176,    0, 
            0,    0,    0,    0,  214,    0,    0,  214,    0,    0, 
          214,  173,  214,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  173,  173,    0,  214,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  176,    0,    0,  176,    0,    0,  176,    0,  176, 
            0,    0,    0,  177,  177,  177,    0,    0,  177,  177, 
          177,  175,  177,    0,    0,  176,    0,    0,    0,    0, 
            0,  175,  177,  177,    0,    0,    0,    0,    0,    0, 
            0,  177,  177,    0,  177,  177,  177,  177,  177,    0, 
            0,    0,    0,    0,  178,  178,  178,    0,  260,  178, 
          178,  178,    0,  178,    0,  175,    0,    0,  260,    0, 
            0,    0,    0,  178,  178,    0,    0,    0,    0,  175, 
          175,    0,  178,  178,    0,  178,  178,  178,  178,  178, 
            0,  177,    0,    0,  177,    0,    0,  177,    0,  177, 
            0,    0,  260,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  177,  260,  260,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  178,    0,    0,  178,    0,    0,  178,    0, 
          178,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  179,  179,  179,    0,  178,  179,  179,  179, 
            0,  179,    0,    0,    0,    0,    0,  172,    0,    0, 
            0,  179,  179,    0,    0,    0,    0,  172,    0,    0, 
          179,  179,    0,  179,  179,  179,  179,  179,    0,  173, 
          173,  173,    0,    0,  173,  173,  173,    0,  173,    0, 
            0,    0,  261,    0,    0,    0,    0,    0,  173,  173, 
            0,  172,  261,    0,    0,    0,    0,  173,  173,    0, 
          173,  173,  173,  173,  173,  172,  172,    0,    0,    0, 
          179,    0,    0,  179,    0,    0,  179,    0,  179,    0, 
            0,    0,    0,    0,    0,    0,  261,    0,    0,    0, 
            0,    0,    0,    0,  179,    0,    0,    0,    0,    0, 
          261,  261,    0,    0,    0,    0,    0,  173,    0,    0, 
          173,    0,    0,  173,    0,  173,    0,    0,    0,    0, 
            0,    0,    0,  175,  175,  175,    0,    0,  175,  175, 
          175,  173,  175,    0,    0,    0,    0,    0,    0,    0, 
           56,    0,  175,  175,    0,    0,    0,    0,    0,    0, 
           56,  175,  175,    0,  175,  175,  175,  175,  175,    0, 
          260,  260,  260,    0,    0,  260,  260,  260,    0,  260, 
            0,    0,    0,    0,    0,    0,   42,    0,    0,  260, 
          260,    0,    0,    0,    0,    0,   42,    0,  260,  260, 
            0,  260,  260,  260,  260,  260,    0,    0,   56,   56, 
            0,  175,    0,    0,  175,    0,    0,  175,    0,  175, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  175,    0,   47,    0,    0, 
            0,    0,    0,    0,   42,   42,    0,   47,    0,    0, 
            0,  260,    0,    0,  260,    0,  260,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  260,   32,    0,    0,    0,    0,    0,  172, 
          172,  172,    0,   32,  172,  172,  172,    0,  172,    0, 
            0,    0,    0,    0,    0,   47,   47,    0,  172,  172, 
            0,    0,    0,    0,    0,    0,    0,  172,  172,    0, 
          172,  172,  172,  172,  261,  261,  261,  260,    0,  261, 
          261,  261,    0,  261,    0,    0,    0,    0,    0,    0, 
            0,    0,   32,  261,  261,    0,    0,    0,    0,    0, 
            0,    0,  261,  261,    0,  261,  261,  261,  261,  261, 
            0,    0,    0,    0,    0,    0,    0,  172,    0,    0, 
          172,    0,    0,  172,    0,  172,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   90, 
            0,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  261,    0,    0,  261,    0, 
          261,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   56,   56,   56,    0,  261,   56,   56,   56, 
            0,   56,    0,    0,    0,    0,    0,    0,   90,    0, 
            0,   56,   56,    0,    0,    0,    0,    0,    0,    0, 
           56,   56,    0,   56,   56,   56,   56,   56,   42,   42, 
           42,    0,    0,   42,   42,   42,    0,   42,    0,    0, 
          411,    0,    0,    0,    0,    0,    0,   42,    0,    0, 
            0,    0,    0,    0,    0,    0,   42,   42,    0,   42, 
           42,   42,   42,   42,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   56,    0,    0,   56,   91,    0,   47, 
           47,   47,    0,    0,   47,   47,   47,    0,   47,    0, 
            0,    0,    0,    0,   56,    0,    0,    0,   47,    0, 
            0,    0,    0,    0,    0,    0,    0,   47,   47,   42, 
           47,   47,   47,   47,   47,   32,   32,   32,    0,    0, 
            0,   32,   32,    0,   32,    0,   91,    0,    0,    0, 
           42,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   32,   32,   32,   32, 
           32,    0,    0,    0,    0,    0,    0,    0,  414,    0, 
           47,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   47,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   90,    0,    0,   32,    0,    0,    0, 
            0,    0,    0,    0,    0,   90,   90,   90,   90,   90, 
           90,   90,   90,   90,   90,   90,    0,   32,   90,   90, 
            0,   90,   90,   90,   90,   90,   90,   90,    0,  469, 
            0,    0,   90,   90,   90,   90,   90,   90,   90,    0, 
            0,   90,   90,    0,    0,    0,    0,   90,   90,   90, 
           90,   90,   90,   90,   90,   90,   90,   90,   90,   90, 
           90,    0,   90,   90,    0,   90,   90,   90,    0,    0, 
            0,    0,    0,    0,  476,    0,    0,    0,    0,  411, 
            0,    0,    0,    0,    0,    0,  411,   90,    0,    0, 
           90,  469,    0,   90,   90,    0,   90,    0,   90,    0, 
            0,    0,   90,    0,    0,    0,    0,   90,    0,   91, 
           90,    0,  469,    0,    0,   90,   90,   90,   90,   90, 
           90,    0,    0,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,    0,    0,   91,   91,    0,   91, 
           91,   91,   91,   91,   91,   91,    0,  470,    0,    0, 
           91,   91,   91,   91,   91,   91,   91,    0,   91,   91, 
            0,    0,    0,    0,    0,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,    0, 
           91,   91,    0,   91,   91,   91,    0,    0,    0,    0, 
          278,    0,    0,    0,    0,    0,    0,  414,    0,    0, 
            0,    0,    0,    0,  414,   91,    0,    0,   91,  470, 
            0,   91,   91,    0,   91,    0,   91,    0,    0,    0, 
           91,    0,    0,    0,    0,   91,    0,   91,   91,    0, 
          470,    0,    0,   91,   91,   91,   91,   91,   91,   90, 
           90,   90,   90,   90,   90,   90,   90,   90,   90,   90, 
            0,    0,   90,   90,    0,   90,   90,   90,   90,   90, 
           90,   90,    0,  476,    0,    0,   90,   90,   90,   90, 
           90,   90,   90,    0,    0,   90,   91,    0,    0,    0, 
            0,   90,   90,   90,   90,   90,   90,   90,   90,   90, 
           90,   90,   90,   90,   90,    0,   90,   90,    0,   90, 
           90,   90,    0,    0,    0,    0,    0,    0,  279,    0, 
            0,    0,    0,  476,    0,    0,    0,    0,    0,    0, 
          476,   90,    0,    0,   90,  472,    0,   90,   90,    0, 
           90,    0,   90,    0,    0,    0,   90,    0,    0,    0, 
            0,   90,    0,  322,   90,    0,  476,    0,    0,   90, 
           90,   90,   90,   90,   90,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,   91,   91,    0,    0,   91,   91, 
            0,   91,   91,   91,   91,   91,   91,   91,    0,    0, 
            0,    0,   91,   91,   91,   91,   91,   91,   91,    0, 
            0,   91,  322,    0,    0,    0,    0,   91,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,    0,   91,   91,    0,   91,   91,   91,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  278, 
            0,    0,    0,    0,    0,    0,  278,   91,    0,    0, 
           91,  473,    0,   91,   91,    0,   91,    0,   91,    0, 
            0,    0,   91,    0,    0,    0,    0,   91,    0,  492, 
           91,    0,    0,    0,    0,   91,   91,   91,   91,   91, 
           91,    0,    0,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,    0,    0,   91,   91,    0,   91, 
           91,   91,   91,   91,   91,   91,    0,    0,    0,    0, 
           91,   91,   91,   91,   91,   91,   91,    0,  492,   91, 
            0,    0,    0,    0,    0,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,    0, 
           91,   91,    0,   91,   91,   91,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  279,    0,    0, 
            0,    0,    0,    0,  279,   91,    0,    0,   91,    0, 
            0,   91,   91,    0,   91,    0,   91,    0,    0,    0, 
           91,    0,    0,    0,    0,   91,    0,  492,   91,    0, 
            0,    0,    0,   91,   91,   91,   91,   91,   91,  322, 
          322,  322,  322,  322,  322,  322,  322,  322,  322,  322, 
            0,  322,  322,  322,  322,  322,  322,  322,  322,  322, 
          322,  322,    0,    0,    0,    0,  322,  322,  322,  322, 
          322,  322,  322,    0,    0,  322,  492,    0,    0,    0, 
            0,  322,  322,  322,  322,  322,  322,  322,  322,  322, 
          322,  322,  322,  322,  322,    0,  322,  322,    0,  322, 
          322,  322,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  322,    0,    0,  322,    0,    0,  322,  322,    0, 
          322,    0,  322,    0,    0,    0,  322,    0,    0,    0, 
            0,    0,    0,    0,  322,    0,    0,    0,    0,  322, 
          322,  322,  322,  322,  322,  492,  492,  492,  492,  492, 
          492,    0,    0,  492,  492,  492,    0,    0,    0,  492, 
            0,  492,  492,  492,  492,  492,  492,  492,    0,    0, 
            0,    0,  492,  492,  492,  492,  492,  492,  492,    0, 
            0,  492,  397,    0,    0,    0,    0,  492,  492,  492, 
          492,  492,  492,  492,  492,  492,  492,  492,  492,  492, 
          492,    0,  492,  492,    0,  492,  492,  492,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  492,    0,    0, 
          492,    0,    0,  492,  492,    0,  492,    0,  492,    0, 
            0,    0,  492,    0,    0,    0,    0,    0,    0,    0, 
          492,    0,    0,    0,    0,  492,  492,  492,  492,  492, 
          492,    0,    0,  492,  492,  492,  492,  492,  492,    0, 
            0,    0,  492,  492,    0,    0,    0,  492,    0,  492, 
          492,  492,  492,  492,  492,  492,    0,    0,    0,    0, 
          492,  492,  492,  492,  492,  492,  492,    0,    0,  492, 
            0,    0,    0,    0,    0,  492,  492,  492,  492,  492, 
          492,  492,  492,  492,  492,  492,  492,  492,  492,    0, 
          492,  492,    0,  492,  492,  492,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  492,    0,    0,  492,    0, 
            0,  492,  492,    0,  492,    0,  492,    0,    0,    0, 
          492,    0,    0,    0,    0,    0,    0,    0,  492,    0, 
            0,  492,    0,  492,  492,  492,  492,  492,  492,    0, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,   27,   28,   29,   30,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   46,    0,    0,   47,    0,    0, 
           48,   49,    0,   50,    0,   51,    0,    0,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,   53,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    7,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,   29,   30,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   46, 
            0,    0,   47,    0,    0,   48,   49,    0,   50,    0, 
           51,    0,    0,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,   53,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,  622,    0,  232,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,   53,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   20,   21,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
          231,    0,  232,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           20,   21,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,    0,    0, 
          416,   49,    0,   50,    0,  231,    0,  232,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
          613,    0,  232,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,  617,    0,  232,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   20,   21,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
          613,    0,  232,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,  807,    0,  232,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
          811,    0,  232,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,  815,    0,  232,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
          869,    0,  232,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,  871,    0,  232,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
          883,    0,  232,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,  250,  250,  250,    0,  250,    0,    0, 
            0,  250,  250,    0,    0,    0,  250,    0,  250,  250, 
          250,  250,  250,  250,  250,    0,    0,    0,    0,  250, 
          250,  250,  250,  250,  250,  250,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  250,    0,    0,  250,  250, 
          250,  250,  250,  250,  250,  250,  250,  250,    0,  250, 
          250,    0,  250,  250,  250,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,  250,    0,    0, 
          250,  250,    0,  250,    0,  250,    0,  250,    0,  250, 
            0,    0,    0,    0,    0,    0,    0,  250,    0,    0, 
            0,    0,  250,  250,  250,  250,  250,  250,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   20,   21,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
          269,    0,    0,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,  428,    0, 
           48,   49,    0,   50,    0,    0,    0,    0,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
          528,    0,    0,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,  528,    0,    0,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
          595,    0,    0,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,  645,    0,    0,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
          772,    0,    0,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,  801,    0,    0,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,  483,  483, 
          483,    0,  483,    0,    0,    0,  483,  483,    0,    0, 
            0,  483,    0,  483,  483,  483,  483,  483,  483,  483, 
            0,    0,    0,    0,  483,  483,  483,  483,  483,  483, 
          483,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          483,    0,    0,  483,  483,  483,  483,  483,  483,  483, 
          483,  483,  483,    0,  483,  483,    0,  483,  483,  483, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  483, 
            0,    0,  483,  483,    0,  483,  483,    0,  483,    0, 
            0,    0,    0,    0,  483,    0,    0,    0,    0,    0, 
            0,    0,  483,    0,    0,    0,    0,  483,  483,  483, 
          483,  483,  483,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,   43,   44,   45,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,    0,    0,    0,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
            0,    0,    0,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  101,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,    0,    0,  104,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  224,    0,    0,   47,    0,    0, 
           48,   49,    0,   50,    0,   51,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          101,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  279, 
            0,    0,  349,    0,    0,   48,   49,    0,   50,    0, 
          350,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  101,    0,    0,   31,   32, 
          102,   34,   35,   36,  103,   38,   39,   40,    0,   41, 
           42,    0,    0,    0,  104,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  106,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          101,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,   40,    0,   41,   42,    0,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  279, 
            0,    0,  107,    0,    0,   48,   49,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   54,   55,   56, 
           57,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  101,    0,    0,   31,   32, 
           33,   34,   35,   36,   37,   38,   39,   40,    0,   41, 
           42,    0,    0,    0,  104,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  790,    0,    0,  107,    0,    0, 
           48,   49,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,  116,  117, 
          118,  119,  120,  121,  122,  123,    0,    0,  124,  125, 
          126,  127,  128,    0,    0,  129,  130,  131,  132,  133, 
          134,  135,    0,    0,  136,  137,  138,  192,  193,  194, 
          195,  143,  144,  145,  146,  147,  148,  149,  150,  151, 
          152,  153,  154,  196,  197,  198,  158,  252,    0,  199, 
            0,    0,    0,    0,    0,    0,    0,  160,  161,    0, 
          162,  163,  164,  165,    0,  166,  167,    0,    0,  168, 
            0,    0,    0,    0,  169,  170,  171,  172,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          174,  175,    0,  176,  177,  178,  179,  180,  181,  182, 
          183,  184,    0,  185,    0,    0,  186,  200,  116,  117, 
          118,  119,  120,  121,  122,  123,    0,    0,  124,  125, 
          126,  127,  128,    0,    0,  129,  130,  131,  132,  133, 
          134,  135,    0,    0,  136,  137,  138,  192,  193,  194, 
          195,  143,  144,  145,  146,  147,  148,  149,  150,  151, 
          152,  153,  154,  196,  197,  198,  158,    0,    0,  199, 
            0,    0,    0,    0,    0,    0,    0,  160,  161,    0, 
          162,  163,  164,  165,    0,  166,  167,    0,    0,  168, 
            0,    0,    0,    0,  169,  170,  171,  172,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          174,  175,    0,  176,  177,  178,  179,  180,  181,  182, 
          183,  184,    0,  185,    0,    0,  186,  200,  116,  117, 
          118,  119,  120,  121,  122,  123,    0,    0,  124,  125, 
          126,  127,  128,    0,    0,  129,  130,  131,  132,  133, 
          134,  135,    0,    0,  136,  137,  138,  139,  140,  141, 
          142,  143,  144,  145,  146,  147,  148,  149,  150,  151, 
          152,  153,  154,  155,  156,  157,  158,   35,   36,  159, 
           38,    0,    0,    0,    0,    0,    0,  160,  161,    0, 
          162,  163,  164,  165,    0,  166,  167,    0,    0,  168, 
            0,    0,    0,    0,  169,  170,  171,  172,    0,    0, 
            0,    0,    0,  173,    0,    0,    0,    0,    0,    0, 
          174,  175,    0,  176,  177,  178,  179,  180,  181,  182, 
          183,  184,    0,  185,    0,    0,  186,  116,  117,  118, 
          119,  120,  121,  122,  123,    0,    0,  124,  125,  126, 
          127,  128,    0,    0,  129,  130,  131,  132,  133,  134, 
          135,    0,    0,  136,  137,  138,  192,  193,  194,  195, 
          143,  144,  145,  146,  147,  148,  149,  150,  151,  152, 
          153,  154,  196,  197,  198,  158,  287,  288,  199,  289, 
            0,    0,    0,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,    0,    0,  186,  116,  117,  118,  119, 
          120,  121,  122,  123,    0,    0,  124,  125,  126,  127, 
          128,    0,    0,  129,  130,  131,  132,  133,  134,  135, 
            0,    0,  136,  137,  138,  192,  193,  194,  195,  143, 
          144,  145,  146,  147,  148,  149,  150,  151,  152,  153, 
          154,  196,  197,  198,  158,    0,    0,  199,    0,    0, 
            0,    0,    0,    0,    0,  160,  161,    0,  162,  163, 
          164,  165,    0,  166,  167,    0,    0,  168,    0,    0, 
            0,    0,  169,  170,  171,  172,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  174,  175, 
            0,  176,  177,  178,  179,  180,  181,  182,  183,  184, 
            0,  185,  586,  511,  186,    0,  587,    0,    0,    0, 
            0,    0,    0,    0,  160,  161,    0,  162,  163,  164, 
          165,    0,  166,  167,    0,    0,  168,    0,    0,    0, 
            0,  169,  170,  171,  172,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  174,  175,    0, 
          176,  177,  178,  179,  180,  181,  182,  183,  184,    0, 
          185,  588,  516,  186,    0,  589,    0,    0,    0,    0, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
            0,  166,  167,    0,    0,  168,    0,    0,    0,    0, 
          169,  170,  171,  172,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  174,  175,    0,  176, 
          177,  178,  179,  180,  181,  182,  183,  184,    0,  185, 
          604,  511,  186,    0,  605,    0,    0,    0,    0,    0, 
            0,    0,  160,  161,    0,  162,  163,  164,  165,    0, 
          166,  167,    0,    0,  168,    0,    0,    0,    0,  169, 
          170,  171,  172,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  174,  175,    0,  176,  177, 
          178,  179,  180,  181,  182,  183,  184,    0,  185,  606, 
          516,  186,    0,  607,    0,    0,    0,    0,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  647,  511, 
          186,    0,  648,    0,    0,    0,    0,    0,    0,    0, 
          160,  161,    0,  162,  163,  164,  165,    0,  166,  167, 
            0,    0,  168,    0,    0,    0,    0,  169,  170,  171, 
          172,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  174,  175,    0,  176,  177,  178,  179, 
          180,  181,  182,  183,  184,    0,  185,  649,  516,  186, 
            0,  650,    0,    0,    0,    0,    0,    0,    0,  160, 
          161,    0,  162,  163,  164,  165,    0,  166,  167,    0, 
            0,  168,    0,    0,    0,    0,  169,  170,  171,  172, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  174,  175,    0,  176,  177,  178,  179,  180, 
          181,  182,  183,  184,    0,  185,  859,  511,  186,    0, 
          860,    0,    0,    0,    0,    0,    0,    0,  160,  161, 
            0,  162,  163,  164,  165,    0,  166,  167,    0,    0, 
          168,    0,    0,    0,    0,  169,  170,  171,  172,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  174,  175,    0,  176,  177,  178,  179,  180,  181, 
          182,  183,  184,    0,  185,  861,  516,  186,    0,  862, 
            0,    0,    0,    0,    0,    0,    0,  160,  161,    0, 
          162,  163,  164,  165,    0,  166,  167,    0,    0,  168, 
            0,    0,    0,    0,  169,  170,  171,  172,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          174,  175,    0,  176,  177,  178,  179,  180,  181,  182, 
          183,  184,    0,  185,    0,    0,  186, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            2,    3,    4,    5,    6,   14,    8,  215,   27,   21, 
          379,   53,   14,   15,   16,  393,    6,   19,   15,   16, 
           51,    7,   19,   10,   15,   16,  248,   10,   19,    4, 
            5,   15,   16,  343,  376,   19,  371,  399,   44,   14, 
           44,   27,   11,   10,    3,   47,   10,   49,   50,   51, 
           15,   16,   47,   50,   19,   21,  411,   61,   10,   50, 
          370,   10,   32,   10,   54,   10,  341,  342,   61,  344, 
          345,   10,   59,  697,   10,   11,   51,   10,  388,   73, 
           10,   10,   94,   10,   49,   10,   88,   10,  474,  264, 
          280,   10,  447,  403,  369,   59,  101,   44,  695,   44, 
          697,   44,   10,  280,   73,  107,   10,   59,   10,   58, 
           59,  386,  387,   88,   59,   10,  312,  312,   61,   10, 
           59,   44,   10,  509,  313,  314,   59,  402,   94,   58, 
           59,  293,  312,   10,  100,  297,   59,  352,  312,  108, 
           59,   10,   91,  327,  290,  291,  456,  113,  346,    0, 
           58,   59,  342,   10,  330,   59,   10,   59,  433,   10, 
          312,  337,  106,  378,   59,   10,  364,   15,   16,  312, 
          342,   19,  315,  363,  349,   44,  360,   10,  374,  374, 
          455,   10,   59,  269,  304,  271,  363,   10,  308,    0, 
           44,   10,  372,  373,  374,   43,   44,  343,  372,  373, 
          374,   49,   50,  342,   52,   53,  830,  363,   59,  330, 
          200,   44,  547,   58,   59,   44,  337,   91,  308,  561, 
          372,  373,  374,  592,  218,   58,   59,   32,  304,  372, 
          373,  566,  269,  830,  271,   58,   59,    6,    7,   58, 
           59,  667,   10,  245,  367,  247,  248,  673,  245,  218, 
          247,  248,    0,   10,  245,  257,  247,  248,   27,  313, 
          314,  245,  264,  247,  248,  270,  306,  312,   32,  264, 
          310,  311,   91,  349,  350,  351,  352,   10,  319,  282, 
          245,  339,  247,  248,  339,   54,  222,  223,   44,   91, 
           58,   59,  256,  524,  525,  268,  269,  683,   91,  351, 
          352,   58,   59,  305,  346,   44,  348,  469,  310,  350, 
          352,  353,   61,  354,  355,  356,  357,   61,  267,  350, 
          262,    2,  339,   91,  263,  264,   59,  372,  373,  374, 
           61,   91,  263,  264,  340,  269,  279,  271,  269,  343, 
          264,  343,  312,  290,  291,  264,  305,  349,  350,   61, 
          343,  310,  281,   61,  349,  630,  631,  348,  308,  267, 
          343,  352,  264,  290,  291,  727,   47,  269,  370,  371, 
          306,  307,  308,  309,  729,  350,  343,  364,  343,   61, 
          735,  330,  384,  231,  232,  233,  388,  378,  337,  597, 
          392,  343,  394,  340,  358,  364,  343,  245,  343,  247, 
          248,  403,  372,  373,  395,  370,  408,  255,  427,  411, 
          343,  408,  634,  343,  416,  420,  421,  360,  343,  416, 
          343,  269,  267,  388,  802,  369,  107,   61,  430,  398, 
          399,  200,  416,  802,  267,  440,  441,  779,  403,  330, 
          775,  427,  330,  339,  267,  447,  337,   16,  267,  337, 
           19,  262,  263,  264,  456,  343,  330,  268,  269,   91, 
          271,   91,   91,  337,   59,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  456,  269,  828,  271,  343,  851,  705,  346,  267, 
          348,  513,  290,  291,  352,  353,  518,  340,  739,  740, 
          267,  330,  524,  525,  262,  263,  264,  340,  337,  308, 
          268,  269,  370,  271,  879,  263,  264,  837,  330,  279, 
          378,  264,  343,    2,    3,  337,  269,  330,  271,    8, 
          388,  389,  390,  391,  337,  547,  340,  395,  279,   44, 
          555,   44,  518,  364,   10,  403,   58,  576,   10,  407, 
          408,  836,  330,  411,  566,  413,  556,  279,  416,  337, 
          330,  279,  363,  342,  342,  544,  257,  337,   47,  581, 
           56,   57,  319,  264,  319,  551,  434,  435,  436,  797, 
          576,  319,    0,  312,   10,  343,  444,  319,  567,  447, 
          369,  449,   10,   59,  346,  312,   58,   59,  456,  339, 
          546,  343,  343,  364,   10,  350,  364,  343,  387,  354, 
          355,  308,  664,  665,  274,   44,  276,  277,  670,  360, 
            0,  343,  634,  402,  374,  343,   10,  634,  107,   91, 
           10,  342,   58,   59,  348,  279,  269,  374,  360,  658, 
          652,   59,  360,  372,  373,  374,  658,  659,  427,  661, 
          267,  663,   58,   59,  433,  372,  373,  374,  349,  634, 
          271,   44,   44,  609,  264,   91,  245,   44,  247,  248, 
          528,    0,  343,  658,  343,   59,  455,  692,   44,   59, 
          364,   10,  343,   32,  339,   91,  339,  339,  330,  339, 
          330,  330,  704,  384,   44,  337,  708,  337,  337,  343, 
          346,  392,  343,  394,  570,  264,  685,  573,   91,   91, 
          346,  723,  724,  725,   61,  304,  360,  729,  770,  704, 
           44,   44,  734,  735,   44,  340,  304,  734,  743,  263, 
           59,  339,  747,  734,  346,  339,  339,  595,  264,  430, 
          734,  264,   44,   44,    2,    3,    4,    5,  727,  346, 
            8,    9,   10,   11,   44,  613,   14,   15,   16,  617, 
          351,   19,  774,  775,  622,  711,  343,  343,   26,    2, 
            3,    4,    5,  343,  364,    8,  634,  556,  257,  343, 
          346,   14,  339,  795,  264,  264,  264,  645,  343,   47, 
           48,   49,  264,   51,  339,   53,  264,  576,  264,  343, 
          360,  364,  268,  269,  662,  267,  664,  665,  264,  264, 
          364,  343,  670,  671,   47,   44,  828,  308,   51,  264, 
          264,   44,  680,  681,   44,  837,  305,  839,  343,  364, 
           88,  310,  264,  691,  846,  346,  264,  849,   44,  851, 
          264,  267,  849,  364,  262,  263,  264,  105,  346,  107, 
          268,  269,  342,  271,  280,   88,  714,  715,  716,  271, 
          343,  267,  837,  364,  722,  346,  264,  879,  330,  346, 
          349,  729,  343,  343,  107,  337,  734,  735,  262,  263, 
          264,  346,  262,  263,  264,  269,  343,   61,  268,  269, 
          581,  271,  371,    5,  865,  364,  279,  279,  280,    6, 
            0,  779,  561,   88,  330,  384,  695,  658,   65,  695, 
           10,  337,  770,  392,  772,  394,  342,  783,  838,   44, 
          786,   73,   -1,  789,  330,  343,  293,  294,  295,  296, 
          297,  337,   -1,  262,  263,  264,   61,  363,   -1,  268, 
          269,  799,  271,  801,   44,   -1,  364,  330,  330,  807, 
           -1,  430,   -1,  811,  337,  337,   -1,  815,   -1,   59, 
          342,  652,   -1,  343,  222,  223,   91,   -1,  659,   -1, 
          661,   -1,  663,   -1,   -1,   -1,   -1,  360,  360,  837, 
           -1,  363,   -1,   -1,  364,   -1,   -1,  245,   -1,  247, 
          248,  849,  858,  851,   -1,    2,    3,    0,   -1,  257, 
           -1,    8,    9,   10,   11,   -1,  264,   10,   15,   16, 
           -1,  869,   19,  871,  343,   -1,    0,  708,   -1,   26, 
           -1,  879,   -1,   -1,  257,  883,   10,   -1,   -1,   -1, 
           -1,  264,  723,  724,  725,  364,   -1,   -1,   -1,   -1, 
           47,   48,   49,   -1,   -1,   -1,   53,  305,  306,  307, 
          308,  309,  310,  311,  312,   -1,   59,  836,   -1,   -1, 
           -1,  304,   -1,   -1,  307,  308,  309,   -1,  547,   -1, 
            2,    3,  305,   -1,   58,   59,    8,  310,   -1,   -1, 
           -1,   -1,   14,  774,   -1,  343,   -1,  566,  346,   -1, 
          348,  349,  350,   -1,  352,  353,   -1,   -1,  105,  342, 
          107,   -1,  581,   -1,  795,   -1,  349,  350,  351,  352, 
           -1,   -1,  370,  371,  372,   47,  349,  350,   44,  306, 
          307,   -1,  309,  310,  311,   -1,  384,   -1,   -1,   -1, 
          388,   -1,   -1,   -1,  392,   -1,  394,   -1,  371,   -1, 
           -1,   -1,   -1,   -1,   -1,  403,   -1,   -1,  839,   -1, 
           -1,  384,   -1,   -1,  279,  846,   -1,   -1,  416,  392, 
           -1,  394,  262,  263,  264,   91,   -1,   -1,  268,  269, 
          428,  271,  430,  652,   10,  107,   -1,   -1,   -1,   -1, 
          659,   -1,  661,   -1,  663,    9,   10,   11,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  430,  456,   -1, 
           -1,   -1,   26,   -1,   -1,  330,   -1,   44,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  222,  223,  342,  343,   -1, 
           -1,   -1,   58,   59,   48,   -1,   -1,   -1,   44,  708, 
           -1,   -1,   -1,   -1,   -1,  360,   49,   50,  245,   -1, 
          247,  248,   -1,  343,  723,  724,  725,   -1,   -1,   -1, 
          257,   -1,   -1,   -1,   91,   91,   -1,  264,   -1,  262, 
          263,  264,   -1,  239,  364,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,  262,  263, 
          264,  105,   -1,  267,  268,  269,   -1,  271,  546,  547, 
          293,  294,  295,  296,  297,  774,  775,  281,  305,  306, 
          307,  308,  309,  310,  311,  312,  290,  291,  566,  293, 
          294,  295,  296,  297,  547,   44,  795,   -1,   -1,   -1, 
           -1,   10,   -1,  581,   -1,  257,   -1,   -1,   44,   -1, 
           -1,   -1,  264,  566,   -1,   -1,  343,   -1,   -1,  346, 
          343,  348,  349,   -1,   -1,  352,  353,   -1,  581,  828, 
           -1,  609,   -1,  279,  280,   -1,   -1,   -1,   -1,  343, 
          839,  364,   91,  370,  371,  372,   -1,  846,   -1,   58, 
           59,   -1,   -1,  305,   -1,   91,  634,  384,  310,   -1, 
          364,  388,   -1,   -1,   -1,  392,   -1,  394,   -1,   44, 
           -1,   44,   -1,   -1,  652,   -1,  403,   -1,  222,  223, 
          658,  659,   91,  661,  330,  663,  664,  665,   61,  416, 
          304,  337,  670,  307,  308,  309,  342,  349,   -1,  652, 
          653,  428,   -1,  430,   -1,  658,  659,   -1,  661,  405, 
          663,  267,   -1,   -1,  360,  248,   91,  363,   91,  371, 
           -1,   -1,  279,  280,  280,   -1,  704,   -1,   -1,  456, 
          708,   -1,  384,  711,   -1,  349,  350,  351,  352,   -1, 
          392,   -1,  394,  279,   -1,  723,  724,  725,   -1,   -1, 
           -1,  704,   -1,   -1,   -1,  708,   10,   -1,   -1,   -1, 
           -1,   -1,  306,  307,  308,  309,   -1,  311,  312,   -1, 
          723,  724,  725,  330,  330,   -1,   -1,   -1,  430,   -1, 
          337,  337,   -1,   -1,   -1,  342,  342,   -1,   -1,   -1, 
           -1,   -1,  770,   -1,  330,   -1,  774,  775,  319,   -1, 
           -1,  337,   -1,  360,   -1,   59,  363,  363,   -1,   -1, 
          343,   -1,   -1,   -1,  335,  336,   -1,  795,   -1,  546, 
          547,  774,  775,   -1,  360,   -1,   -1,   -1,  372,  350, 
          279,  352,   -1,  354,  355,  356,  357,  370,   10,  566, 
           -1,   -1,  795,  279,   -1,  378,  379,   -1,  231,  232, 
          828,   -1,   -1,   -1,  581,  388,   -1,   -1,  267,  837, 
           -1,  839,   -1,   -1,   -1,   -1,   -1,   -1,  846,   -1, 
          403,  280,  416,   -1,   -1,  828,   -1,   -1,   -1,   -1, 
           -1,  330,  609,   -1,  428,   -1,  839,   59,  337,   -1, 
           -1,   -1,   -1,  846,  330,  547,   -1,   -1,   44,   -1, 
           -1,  337,   -1,   -1,  279,   -1,  279,  634,   -1,   44, 
           -1,  360,   -1,   -1,  566,   61,   -1,   -1,   -1,  615, 
           -1,  330,   -1,  456,  360,  652,   61,   -1,  337,  581, 
          626,   -1,  659,  342,  661,   -1,  663,  664,  665,   -1, 
          473,  474,   -1,  670,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  363,  330,   91,  330,   -1,   -1, 
           -1,   -1,  337,   -1,  337,  348,   44,  342,   -1,  352, 
          343,   -1,   -1,   -1,   -1,   -1,  509,   -1,   -1,    0, 
          513,  708,   -1,   61,  711,  360,   -1,  360,   -1,   10, 
           -1,  524,  525,   -1,   -1,  378,  723,  724,  725,   -1, 
          652,   -1,  546,   -1,   -1,   -1,  658,  659,   -1,  661, 
           -1,  663,  395,   91,   -1,  548,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  407,  408,   10,   -1,  411,   -1, 
          413,   -1,  728,  416,   -1,  731,  732,   58,   59,   -1, 
           -1,   -1,   -1,  770,   -1,   -1,  579,  774,  775,  582, 
          304,  584,  704,  307,  308,  309,  708,   -1,   -1,  592, 
           -1,  444,   -1,   -1,  447,  609,  449,   -1,  795,   -1, 
           -1,  723,  724,  725,   58,   59,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,   -1,   -1,  342,   -1, 
          319,   -1,   44,   -1,   -1,  349,  350,  351,  352,   -1, 
           -1,  828,   -1,   -1,   -1,    0,  335,  336,   -1,   61, 
          837,   -1,  839,   -1,   -1,   10,  812,  813,   -1,  846, 
           -1,  350,  774,  775,   -1,  354,  355,  356,  357,   -1, 
           -1,   -1,  304,  279,  280,  307,  308,  309,   -1,   91, 
           -1,   -1,   -1,  795,  279,  528,   -1,   -1,   -1,   44, 
          683,  847,  848,   -1,   -1,   -1,   -1,  853,  330,   -1, 
           -1,   -1,   -1,   58,   59,  337,   -1,  711,   63,   -1, 
          342,   44,   -1,   -1,  870,   -1,  828,  349,  350,  351, 
          352,   -1,  878,   -1,  330,  881,   -1,  839,   61,  885, 
           -1,  337,   -1,   -1,  846,  330,  342,  343,   -1,   -1, 
           -1,  279,  337,   -1,   -1,   -1,  739,  740,  343,   -1, 
           -1,   -1,  595,   -1,  360,   -1,   -1,  363,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          613,   -1,   -1,   -1,  617,   -1,   -1,   -1,   -1,  622, 
           -1,  262,  263,  264,    0,   -1,  267,  268,  269,   -1, 
          271,  634,  330,   -1,   10,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,   -1,   -1,   -1,  343,   -1,   -1,   -1,  802, 
           -1,   -1,  293,  294,  295,  296,  297,   -1,  262,  263, 
          264,   -1,  360,  267,  268,  269,   -1,  271,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  681,   -1, 
           -1,   -1,   58,   59,  837,   61,   -1,   63,  691,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,  343,   -1,   -1,   -1,   -1,  279,  280,   -1, 
           -1,   -1,  865,   -1,   -1,   91,   -1,   -1,   -1,  722, 
           -1,   -1,   -1,  364,   -1,   -1,  729,   -1,   -1,   -1, 
           -1,   -1,  735,   -1,   -1,   -1,   -1,   -1,   -1,  343, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   10,  267,  268,  269,   -1,  271,   -1,  330,   -1, 
          364,   -1,   -1,   -1,   -1,  337,  281,  282,   -1,  772, 
          342,  343,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   44,  279,   -1,  360,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,  801,   58, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,  811,   -1, 
           -1,   -1,  815,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  340,   10,   -1,  343,   -1, 
           -1,  346,   91,  348,   -1,   -1,   -1,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,  849,   -1,  851,  364, 
          343,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,  869,  360,  871,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  879,   -1,   -1,   63, 
          883,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  279,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   59,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   -1,   -1,  335, 
          336,  337,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,  364,   -1, 
          366,  367,  368,  369,  370,  371,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   63,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,  364,    0,  366,  367,  368, 
          369,  370,  371,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,   -1,  331,  332,   -1, 
           44,  335,  336,   -1,   -1,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   58,   59,  350,   61,  352,   63, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  304,  305,   -1, 
           -1,  308,   -1,   -1,   -1,   -1,   -1,   91,   -1,  316, 
          317,   -1,  319,  320,  321,  322,  343,  324,  325,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335,  336, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,  364,   -1,   -1, 
           -1,   10,  349,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,   -1,  365,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
           10,  331,  332,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,   10,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          350,   -1,  352,   -1,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,   63,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,  338,   -1,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
          364,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,  338, 
           -1,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,  364,    0,  366,  367,  368, 
          369,  370,  371,   -1,  304,   -1,   10,  307,  308,  309, 
           -1,   -1,   -1,   -1,   -1,  304,   -1,   -1,  307,  308, 
          309,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
           44,  330,  342,   -1,   -1,   -1,   -1,   -1,  337,  349, 
          350,  351,  352,  342,   58,   59,   -1,   61,   -1,   63, 
          349,  350,  351,  352,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,   -1, 
          335,  336,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  350,   -1,  352,   -1,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   44,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,  299,   63,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  319, 
           10,   -1,  318,   -1,  324,  325,   -1,   -1,   -1,   -1, 
           -1,   10,   91,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345, 
          350,  347,  352,  349,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,   -1,  360,   -1,   -1,   -1,   -1,   59, 
          366,  367,  368,  369,  370,  371,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,  338,   -1,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
          364,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,  338, 
           -1,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,  364,    0,  366,  367,  368, 
          369,  370,  371,   -1,  304,   -1,   10,  307,  308,  309, 
           -1,   -1,   -1,   -1,   -1,  304,   -1,   -1,  307,  308, 
          309,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
           44,  330,  342,   -1,   -1,   -1,   -1,   -1,  337,  349, 
          350,  351,  352,  342,   58,   59,   -1,   -1,   -1,   63, 
          349,  350,  351,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,    0,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   10,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,   44,   -1,   -1,  318,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  335,   -1,   -1,  338,   -1, 
           -1,  341,  319,   -1,  344,  345,   -1,  347,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   10,   91,   -1,   -1,   -1,  366,  367,  368,  369, 
          370,  371,   -1,  350,   -1,  352,   -1,  354,  355,  356, 
          357,   -1,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,  338,   -1,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
          364,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,  338, 
           -1,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,  364,    0,  366,  367,  368, 
          369,  370,  371,   -1,  304,   -1,   10,  307,  308,  309, 
           -1,   -1,   -1,   -1,   -1,  304,   -1,   -1,  307,  308, 
          309,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
           44,  330,  342,   -1,   -1,   -1,   -1,   -1,  337,  349, 
          350,  351,  352,  342,   58,   59,   -1,   -1,   -1,   63, 
          349,  350,  351,  352,  304,  305,   -1,   -1,  308,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319, 
          320,  321,  322,   -1,  324,  325,   -1,   91,  328,   -1, 
           -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
          350,    0,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   10,  362,   -1,   -1,  365,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   44,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,  299,   63,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344,  345, 
           -1,  347,   -1,  349,   -1,  351,   61,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   91,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,  338,   -1,  340,  341,   -1,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
          364,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,  279,  280,  335,  336,  337,  338, 
           -1,  340,  341,   -1,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,  364,    0,  366,  367,  368, 
          369,  370,  371,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,   -1,   -1,  342,  343,   -1, 
           -1,   -1,   -1,  319,  320,  321,  322,  323,  324,  325, 
           44,   -1,  328,  329,   -1,  360,   -1,   -1,  363,  335, 
          336,   -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,  350,   -1,  352,   -1,  354,  355, 
          356,  357,  358,  359,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,    0,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   10,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
          300,  301,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,   44,  316,  317,  318,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,  345, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

           -1,  347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  361,   91,   -1,   -1,   -1, 
          366,  367,  368,  369,  370,  371,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  299, 
           59,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,   -1,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   -1,   -1,  335,  336,  337,  338,   -1, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,   -1,  366,  367,  368,  369, 
          370,  371,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   44,   -1,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,   -1,  293,  294, 
          295,  296,  297,   63,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
           -1,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   -1,   -1, 
          335,  336,  337,  338,   -1,  340,  341,   -1,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,    0,  364, 
           -1,  366,  367,  368,  369,  370,  371,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   44,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   59,   -1,   61, 
          299,   63,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
           -1,   -1,   -1,    0,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   10,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,   -1,   -1,   -1,   -1,   44,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,  350,   61,  352,   63,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,   -1,   -1,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
           -1,  331,  332,   -1,   91,  335,  336,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          350,   -1,  352,   -1,  354,  355,  356,  357,  358,  359, 
          360,   58,  362,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,  337,  338,   -1,   -1,  341, 
          342,  343,  344,  345,   -1,  347,   -1,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,  364,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,  338,   -1,   -1,  341,  342,  343,  344,  345,   -1, 
          347,   -1,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,  364,    0,  366, 
          367,  368,  369,  370,  371,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,   -1,  331,  332,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  350,   -1,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,    0,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   10,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,   44,  316,  317, 
          318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347, 
           -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  361,   91,   -1,   -1,   -1,  366,  367, 
          368,  369,  370,  371,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,  299,   58,   59, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,   -1,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,  337,  338,   -1,   -1,  341, 
          342,  343,  344,  345,   -1,  347,   -1,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,  364,   -1,  366,  367,  368,  369,  370,  371, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,  338,   -1,   -1,  341,  342,  343,  344,  345,   -1, 
          347,   -1,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,   -1,  366, 
          367,  368,  369,  370,  371,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,  281,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,    0,  316,  317,  318,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,  337,  338,   -1, 
           -1,  341,   -1,  343,  344,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,  353,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  361,   -1,   -1,  364,   -1,  366,  367,  368,  369, 
          370,  371,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   91,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,    0,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   10,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,  345,   -1,  347,   -1,   58,   59,   -1,   61, 
          353,   63,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1, 
           -1,   -1,   -1,  366,  367,  368,  369,  370,  371,  304, 
          305,   -1,   -1,  308,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,  316,  317,   -1,  319,  320,  321,  322,   -1,  324, 
          325,   -1,    0,  328,   -1,   -1,   -1,   -1,  333,  334, 
          335,  336,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,   -1,   -1, 
          365,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           58,   59,  267,  268,  269,   63,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  280,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   -1,   -1, 
          335,  336,  337,   -1,   -1,  340,   -1,   -1,  343,   -1, 
           -1,  346,   -1,  348,   -1,  350,    0,  352,   -1,  354, 
          355,  356,  357,  358,  359,  360,   10,  362,  363,  364, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,  337,   -1,  339,  340,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350,    0, 
          352,   -1,  354,  355,  356,  357,  358,  359,  360,   10, 
          362,   -1,  364,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  280,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,  337, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,  350,   44,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,  363,  364,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,    0,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   10,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
          281,  282,  343,   -1,   -1,  346,   -1,  348,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,  364,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,   -1,   -1,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,   -1,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   -1,  364,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,  337, 
           -1,  339,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,  350,   44,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,   -1,  364,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  350,   44,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,  364,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,  304,  305,   -1,   -1, 
          308,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317, 
           -1,  319,  320,  321,  322,   -1,  324,  325,   -1,   -1, 
          328,   91,   -1,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,  350,   10,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,   -1,   -1,  365,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,   -1,   -1,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,    0,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   10,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   91,   -1,  335,  336,  337,   -1,   -1, 
          340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1, 
          350,    0,  352,   -1,  354,  355,  356,  357,  358,  359, 
          360,   10,  362,   -1,  364,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   44,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,   -1,   91,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,    0,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   10,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,  337, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,   -1,  354,  355,  356,  357, 
          358,  359,  360,   10,  362,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   91,   -1,  335,  336,  337,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,    0,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,   10,  364,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,   -1,   91,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,   -1,  350,    0,  352,   -1, 
          354,  355,  356,  357,  358,  359,  360,   10,  362,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,    0,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   10,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   91,   -1,  335, 
          336,  337,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
           -1,   -1,   -1,   -1,  350,    0,  352,   -1,  354,  355, 
          356,  357,  358,  359,  360,   10,  362,   -1,  364,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,  337,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,   -1,   -1,   -1,   -1,  350,   -1,  352, 
            0,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
           10,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,  281,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,    0,   -1,  340,   -1,   -1,  343, 
           -1,   -1,   -1,   -1,   10,   -1,  350,   -1,  352,   -1, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   58,   59,   -1,  290,  291,   63,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,    0, 
          335,  336,   -1,   -1,   -1,  340,   -1,   -1,  343,   10, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,   -1,  364, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   58,   59,   -1, 
          290,  291,   63,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
           -1,  331,  332,   -1,   -1,  335,  336,   -1,   -1,    0, 
          340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348,   10, 
          350,   -1,  352,   -1,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,   -1,  331,  332,   -1,    0,  335, 
          336,   -1,   -1,   -1,  340,   -1,   -1,  343,   10,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,   -1,  354,  355, 
          356,  357,  358,  359,  360,   -1,  362,   -1,  364,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   58,   59,   -1,  290, 
          291,   63,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,   -1,  335,  336,   -1,   -1,    0,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,   10,  350, 
           -1,  352,   -1,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   58,   59,   -1,  290, 
          291,   63,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,    0,  335,  336,   -1,   -1,   -1,  340, 
           -1,   -1,  343,   10,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,   -1,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,   -1,  331, 
          332,   -1,   -1,  335,  336,   -1,   -1,   -1,  340,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,    0,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,   10,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,   -1,  331, 
          332,   -1,   91,  335,  336,   -1,   -1,   -1,  340,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,    0,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,   10,  364,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,   -1,  339,   -1,   -1,   -1,  343,   -1,   -1,   44, 
           -1,   -1,   -1,  350,   -1,  352,   -1,  354,  355,  356, 
          357,  358,  359,  360,   59,  362,   61,  364,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,   10,  328,  329,   91, 
           -1,   -1,   -1,   -1,  335,  336,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,  350, 
           -1,  352,   -1,  354,  355,  356,  357,  358,  359,  360, 
           44,  362,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  331,  332,   91,   -1,  335, 
          336,  337,   -1,   -1,   -1,   -1,   -1,  343,   -1,   -1, 
           -1,   -1,   -1,   -1,  350,    0,  352,   -1,  354,  355, 
          356,  357,  358,  359,  360,   10,  362,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  343,  290,  291, 
          346,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,  337,   -1,   -1,  262,  263, 
          264,  343,   -1,   -1,  268,  269,   -1,  271,  350,   44, 
          352,   -1,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,   -1,  364,   58,   59,   -1,  290,  291,   63,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,    0,   -1,   -1,   -1,   -1,  343, 
           -1,   -1,   -1,   -1,   10,   -1,  350,   -1,  352,   -1, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   58,   59,   -1,  290,  291,   63,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,    0, 
          335,  336,   -1,   -1,   -1,  340,   -1,   -1,  343,   10, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,  356,  357,  358,  359,  360,   -1,  362,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,   -1, 
          335,  336,   -1,   -1,   -1,  340,   -1,   -1,  343,   -1, 
           -1,  346,   -1,  348,   -1,   -1,    0,  352,   -1,   -1, 
           -1,  356,  357,  358,  359,  360,   10,  362,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,   -1,  331,  332,   -1,   -1,  335, 
          336,   -1,   -1,   -1,  340,   -1,   -1,  343,   -1,    0, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   10, 
           -1,   -1,  358,  359,  360,   -1,  362,   -1,  364,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,   -1,  335,  336,   -1,   -1,   -1,  340, 
           -1,   -1,  343,    0,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   10,   -1,   -1,   -1,  358,  359,  360, 
           -1,  362,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   58,   59,  267,  268,  269,   63,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,   -1,  331,  332,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,  343, 
            0,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           10,   -1,   -1,   -1,  358,  359,  360,   -1,  362,   -1, 
          364,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   44,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,  343,    0,   -1,  346,   -1,  348,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,  358,  359,  360, 
           -1,  362,   -1,  364,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,   -1,  331,  332,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  358,  359,  360,   -1,  362,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,  262,  263,  264,   63,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
           -1,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,  343,    0,   -1,  346,   -1,  348,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,  358,  359, 
           -1,   -1,   -1,   -1,  364,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,   -1,  331,  332,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  358,  359,   -1,  262,  263,  264,  364,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,   -1,  331,  332,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,  343,   10,   -1,  346,   -1, 
          348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          358,  359,   -1,   -1,   -1,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,   -1,  331,  332,   -1,   -1,   -1, 
           -1,   58,   59,    0,  340,   -1,   -1,  343,   -1,   -1, 
          346,   -1,  348,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  358,  359,  262,  263,  264,   -1,  364,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   10,  346,   -1, 
          348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  364,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  326,  327,    0,   -1,   -1,  331,  332,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          364,   -1,   -1,   -1,  281,  282,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,    0,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  281,  282,  343,   -1,   -1,  346, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326, 
          327,   58,   59,   -1,  331,  332,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,    0,   -1,  267,  268,  269,  364,  271,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,  326,  327,   63,   -1,   -1,  331,  332, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,  262,  263,  264,    0, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   10, 
           -1,  364,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
          326,  327,   63,   -1,   -1,  331,  332,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
          346,   -1,  348,   -1,   -1,  262,  263,  264,   -1,    0, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,  364,   10, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,  326, 
          327,   -1,   -1,   -1,  331,  332,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           44,  348,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   58,   59,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,    0,  343,   -1,   44,  346,   -1, 
          348,  262,  263,  264,   10,   -1,  267,  268,  269,   -1, 
          271,   58,   59,   -1,   -1,   -1,  364,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  327,   10,   -1,   -1, 
          331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   44,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   58,   59,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   10,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,  340,   -1,   -1,  343, 
           -1,   -1,  346,   -1,  348,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   44,   -1,   -1,   -1,   -1, 
          364,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   58, 
           59,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  340,   -1,   -1,  343,   -1,   -1,  346, 
           -1,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   44,   -1,  364,   -1,  262, 
          263,  264,   10,   -1,  267,  268,  269,   -1,  271,   58, 
           59,   -1,   -1,   -1,  340,   -1,   -1,  343,  281,  282, 
          346,   -1,  348,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   44,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,  262,  263,  264,   -1, 
            0,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           10,  364,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  262,  263,  264,   -1,    0,  267,  268, 
          269,   -1,  271,   -1,   44,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58,   59, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,  340,   -1,   -1,  343,   -1,   -1, 
          346,   44,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,    0,  271,   -1,   -1,  364,   -1,   -1,   -1,   -1, 
           -1,   10,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,    0,  267, 
          268,  269,   -1,  271,   -1,   44,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,  364,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   10,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
          340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  364,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   10,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   58,   59, 
           -1,  340,   -1,   -1,  343,   -1,   -1,  346,   -1,  348, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   10,   -1,   -1, 
           -1,  343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,    0,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   10,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  262,  263,  264,   44,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
          343,   -1,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  343,   -1,   -1,  346,   -1, 
          348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,  364,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,  281,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  343,   -1,   -1,  346,   10,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  364,   -1,   -1,   -1,  281,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,  343, 
          293,  294,  295,  296,  297,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   59,   -1,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
          343,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  343,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,  364,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   59,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,  338,   -1,   -1, 
          341,  342,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
           -1,   -1,  353,   -1,   -1,   -1,   -1,  358,   -1,   10, 
          361,   -1,  363,   -1,   -1,  366,  367,  368,  369,  370, 
          371,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   59,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,  338,   -1,   -1,  341,  342, 
           -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1, 
          353,   -1,   -1,   -1,   -1,  358,   -1,   10,  361,   -1, 
          363,   -1,   -1,  366,  367,  368,  369,  370,  371,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,   -1,  269,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   59,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,  338,   -1,   -1,  341,  342,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1, 
           -1,  358,   -1,   10,  361,   -1,  363,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   -1,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   59,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,  338,   -1,   -1, 
          341,  342,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
           -1,   -1,  353,   -1,   -1,   -1,   -1,  358,   -1,   10, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   59,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,  338,   -1,   -1,  341,   -1, 
           -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1, 
          353,   -1,   -1,   -1,   -1,  358,   -1,   10,  361,   -1, 
           -1,   -1,   -1,  366,  367,  368,  369,  370,  371,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   59,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,  345,   -1, 
          347,   -1,  349,   -1,   -1,   -1,  353,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  361,   -1,   -1,   -1,   -1,  366, 
          367,  368,  369,  370,  371,  256,  257,  258,  259,  260, 
          261,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   59,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,  345,   -1,  347,   -1,  349,   -1, 
           -1,   -1,  353,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,  366,  367,  368,  369,  370, 
          371,   -1,   -1,  256,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1, 
          353,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1, 
           -1,  364,   -1,  366,  367,  368,  369,  370,  371,   -1, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,  342,   -1, 
          344,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,  342,   -1,  344,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,  353, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  361,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,  353,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,  349,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,   -1,   -1,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
          349,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,   -1,   -1,   -1,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,  368, 
          369,  370,  371,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,   -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  366,  367,  368,  369,  370,  371,  257,  258, 
          259,  260,  261,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  270,  271,   -1,   -1,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
          299,  300,  301,  302,  303,  304,  305,  306,   -1,  308, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1, 
          319,  320,  321,  322,   -1,  324,  325,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,   -1,   -1,  365,  366,  257,  258, 
          259,  260,  261,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  270,  271,   -1,   -1,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
          299,  300,  301,  302,  303,  304,  305,   -1,   -1,  308, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1, 
          319,  320,  321,  322,   -1,  324,  325,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,   -1,   -1,  365,  366,  257,  258, 
          259,  260,  261,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  270,  271,   -1,   -1,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
          299,  300,  301,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1, 
          319,  320,  321,  322,   -1,  324,  325,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,   -1,   -1,  365,  257,  258,  259, 
          260,  261,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          270,  271,   -1,   -1,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,  299, 
          300,  301,  302,  303,  304,  305,  306,  307,  308,  309, 
           -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319, 
          320,  321,  322,   -1,  324,  325,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,   -1,   -1,  365,  257,  258,  259,  260, 
          261,  262,  263,  264,   -1,   -1,  267,  268,  269,  270, 
          271,   -1,   -1,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,  299,  300, 
          301,  302,  303,  304,  305,   -1,   -1,  308,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320, 
          321,  322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,  362,  304,  305,  365,   -1,  308,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320,  321, 
          322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,  304,  305,  365,   -1,  308,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  316,  317,   -1,  319,  320,  321,  322, 
           -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
          304,  305,  365,   -1,  308,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  316,  317,   -1,  319,  320,  321,  322,   -1, 
          324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,  304, 
          305,  365,   -1,  308,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  316,  317,   -1,  319,  320,  321,  322,   -1,  324, 
          325,   -1,   -1,  328,   -1,   -1,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,  304,  305, 
          365,   -1,  308,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          316,  317,   -1,  319,  320,  321,  322,   -1,  324,  325, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,  362,  304,  305,  365, 
           -1,  308,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316, 
          317,   -1,  319,  320,  321,  322,   -1,  324,  325,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,  304,  305,  365,   -1, 
          308,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317, 
           -1,  319,  320,  321,  322,   -1,  324,  325,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,  362,  304,  305,  365,   -1,  308, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1, 
          319,  320,  321,  322,   -1,  324,  325,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,   -1,   -1,  365, 
      };
   }

}
