/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.model.internal;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ruby.core.model.ASTCaching;
import org.eclipse.dltk.ruby.core.model.IElement;
import org.eclipse.dltk.ruby.core.model.IElementCriteria;
import org.eclipse.dltk.ruby.core.model.IElementKind;
import org.eclipse.dltk.ruby.core.model.IModel;

public class Model
implements IModel {
    private final IScriptProject project;
    private final Map<ISourceModule, SoftReference<ModuleDeclaration>> sourceModulesToASTs = new HashMap<ISourceModule, SoftReference<ModuleDeclaration>>();

    public Model(IScriptProject project) {
        this.project = project;
    }

    @Override
    public ModuleDeclaration getASTNode(ISourceModule sourceModule, ASTCaching caching) {
        ISourceParser parser;
        ModuleDeclaration result = null;
        SoftReference<ModuleDeclaration> astNode = this.sourceModulesToASTs.get(sourceModule);
        if (astNode != null && caching != ASTCaching.REPARSE) {
            result = astNode.get();
        }
        if (result == null && caching != ASTCaching.CACHED_ONLY && (result = (ModuleDeclaration)(parser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature")).parse((IModuleSource)sourceModule, null)) != null) {
            astNode = new SoftReference<ModuleDeclaration>(result);
            this.sourceModulesToASTs.put(sourceModule, astNode);
        }
        return result;
    }

    public ISourceModule[] search(String name) {
        ArrayList<ISourceModule> sourceModules = new ArrayList<ISourceModule>();
        try {
            IModelElement[] children = this.project.getChildren();
            this.addModules(sourceModules, children);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return sourceModules.toArray(new ISourceModule[sourceModules.size()]);
    }

    private void addModules(Collection<ISourceModule> sourceModules, IModelElement[] children) throws ModelException {
        int i = 0;
        while (i < children.length) {
            IModelElement element = children[i];
            if (element instanceof ISourceModule) {
                sourceModules.add((ISourceModule)element);
            } else if (element instanceof IParent) {
                this.addModules(sourceModules, ((IParent)element).getChildren());
            }
            ++i;
        }
    }

    @Override
    public IElement[] findChildren(IElementCriteria criteria, String name, IProgressMonitor pm) {
        return null;
    }

    @Override
    public IElement getAncestor(IElementCriteria criteria) {
        return null;
    }

    @Override
    public IElementKind getElementKind() {
        return IElementKind.MODEL;
    }
}

