/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.utils.CompoundIterator;

public class RTypeQuery {
    protected final List<IRTypeDeclaration> types = new ArrayList<IRTypeDeclaration>();
    static final int ROOT = 1;
    static final int SUPERTYPES = 2;
    static final int TRAITS = 4;

    public RTypeQuery() {
    }

    public RTypeQuery(IRTypeDeclaration type) {
        this.add(type);
    }

    public void add(IRTypeDeclaration type) {
        this.types.add(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        boolean first = true;
        for (IRTypeDeclaration type : this.types) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(type.getName());
        }
        sb.append(")");
        return sb.toString();
    }

    protected boolean isValid(IRTypeDeclaration type) {
        return true;
    }

    public List<IRTypeDeclaration> getHierarchy() {
        ArrayList<IRTypeDeclaration> result = new ArrayList<IRTypeDeclaration>();
        TypeIterator i = new TypeIterator();
        while (i.hasNext()) {
            result.add((IRTypeDeclaration)i.next());
        }
        return result;
    }

    public Iterable<IRTypeDeclaration> getAllTraits() {
        return new TypeIterable(4);
    }

    private class TypeIterable
    implements Iterable<IRTypeDeclaration> {
        private final int flags;

        public TypeIterable(int flags) {
            this.flags = flags;
        }

        @Override
        public Iterator<IRTypeDeclaration> iterator() {
            return new TypeIterator(this.flags);
        }
    }

    private class TypeIterator
    extends CompoundIterator<IRTypeDeclaration> {
        private final Set<IRTypeDeclaration> visited = new HashSet<IRTypeDeclaration>();
        private final List<IRTypeDeclaration> queue = new ArrayList<IRTypeDeclaration>();
        private final List<IRTypeDeclaration> skipQueue = new ArrayList<IRTypeDeclaration>();
        private final int flags;

        public TypeIterator() {
            this(7);
        }

        public TypeIterator(int flags) {
            this.flags = flags;
            if (RTypeQuery.this.types != null) {
                if ((flags & 1) != 0) {
                    this.queue.addAll(RTypeQuery.this.types);
                } else {
                    this.skipQueue.addAll(RTypeQuery.this.types);
                }
            }
            this.current = this.queue.iterator();
        }

        private boolean canVisit(IRTypeDeclaration type) {
            return this.visited.add(type);
        }

        protected boolean fetchNext() {
            block8: {
                do {
                    if (!this.skipQueue.isEmpty()) {
                        this.queue.addAll(this.skipQueue);
                        this.skipQueue.clear();
                    }
                    if (this.queue.isEmpty()) break block8;
                    IRTypeDeclaration[] copy = this.queue.toArray(new IRTypeDeclaration[this.queue.size()]);
                    this.queue.clear();
                    IRTypeDeclaration[] iRTypeDeclarationArray = copy;
                    int n = copy.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRTypeDeclaration type = iRTypeDeclarationArray[n2];
                        IRTypeDeclaration superType = type.getSuperType();
                        if (superType != null && this.canVisit(superType) && RTypeQuery.this.isValid(superType)) {
                            if ((this.flags & 2) != 0) {
                                this.queue.add(superType);
                            } else {
                                this.skipQueue.add(superType);
                            }
                        }
                        if ((this.flags & 4) != 0) {
                            for (IRTypeDeclaration trait : type.getTraits()) {
                                if (!this.canVisit(trait) || !RTypeQuery.this.isValid(trait)) continue;
                                this.queue.add(trait);
                            }
                        }
                        ++n2;
                    }
                } while (this.queue.isEmpty());
                this.current = this.queue.iterator();
                return true;
            }
            return false;
        }
    }
}

