/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import org.eclipse.dltk.internal.testing.model.TestCaseElement;
import org.eclipse.dltk.internal.testing.model.TestCategoryElement;
import org.eclipse.dltk.internal.testing.model.TestSuiteElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class TestTreeComparator
extends ViewerComparator {
    private int sortDirection = 0;

    public int category(Object element) {
        if (element instanceof TestCategoryElement) {
            return 0;
        }
        if (element instanceof TestSuiteElement) {
            return 1;
        }
        return 2;
    }

    public void setSortDirection(int sortDirection) {
        this.sortDirection = sortDirection;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        String left = "";
        String right = "";
        if (e1 instanceof TestSuiteElement && e2 instanceof TestSuiteElement) {
            left = ((TestSuiteElement)e1).getTestName();
            right = ((TestSuiteElement)e2).getTestName();
        } else if (e1 instanceof TestCaseElement && e2 instanceof TestCaseElement) {
            left = ((TestCaseElement)e1).getTestName();
            right = ((TestCaseElement)e2).getTestName();
        } else {
            return super.compare(viewer, e1, e2);
        }
        if (this.sortDirection == 0) {
            return 0;
        }
        if (this.sortDirection == 1) {
            return left.compareTo(right);
        }
        if (this.sortDirection == 2) {
            return -1 * left.compareTo(right);
        }
        return 0;
    }
}

