/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.refactoring.code;

import java.util.List;
import org.eclipse.dltk.internal.javascript.corext.refactoring.ParameterInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.dltk.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.util.RowLayouter;
import org.eclipse.dltk.javascript.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.dltk.javascript.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExtractMethodInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "ExtractMethodInputPage";
    private ExtractMethodRefactoring fRefactoring;
    private Text fTextField;
    private boolean fFirstTime;
    private ScriptSourceViewer fSignaturePreview;
    private Document fSignaturePreviewDocument;
    private IDialogSettings fSettings;
    private static final String DESCRIPTION = RefactoringMessages.ExtractMethodInputPage_description;
    private static final String THROW_RUNTIME_EXCEPTIONS = "ThrowRuntimeExceptions";
    private static final String GENERATE_JAVADOC = "GenerateJavadoc";
    private static final String ACCESS_MODIFIER = "AccessModifier";

    public ExtractMethodInputPage() {
        super(PAGE_NAME);
        this.setImageDescriptor(DLTKPluginImages.DESC_WIZBAN_REFACTOR_CU);
        this.setDescription(DESCRIPTION);
        this.fFirstTime = true;
        this.fSignaturePreviewDocument = new Document();
    }

    public void createControl(Composite parent) {
        this.fRefactoring = (ExtractMethodRefactoring)this.getRefactoring();
        this.loadSettings();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        GridData gd = null;
        this.initializeDialogUnits((Control)result);
        Label label = new Label(result, 0);
        label.setText(this.getLabelText());
        this.fTextField = this.createTextInputField(result, 2048);
        this.fTextField.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)label, (Control)this.fTextField, 1);
        Composite group = new Composite(result, 0);
        group.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        layouter.perform((Control)label, (Control)group, 1);
        if (!this.fRefactoring.getParameterInfos().isEmpty()) {
            ChangeParametersControl cp = new ChangeParametersControl(result, 0, RefactoringMessages.ExtractMethodInputPage_parameters, new IParameterListChangeListener(){

                @Override
                public void parameterChanged(ParameterInfo parameter) {
                    ExtractMethodInputPage.this.parameterModified();
                }

                @Override
                public void parameterListChanged() {
                    ExtractMethodInputPage.this.parameterModified();
                }

                @Override
                public void parameterAdded(ParameterInfo parameter) {
                    ExtractMethodInputPage.this.updatePreview(ExtractMethodInputPage.this.getText());
                }
            }, ChangeParametersControl.Mode.EXTRACT_METHOD);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            cp.setLayoutData(gd);
            cp.setInput(this.fRefactoring.getParameterInfos());
        }
        label = new Label(result, 258);
        label.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)label);
        this.createSignaturePreview(result, layouter);
        Dialog.applyDialogFont((Control)result);
    }

    private Text createTextInputField(Composite parent, int style) {
        Text result = new Text(parent, style);
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtractMethodInputPage.this.textModified(ExtractMethodInputPage.this.getText());
            }
        });
        TextFieldNavigationHandler.install((Text)result);
        return result;
    }

    private String getText() {
        if (this.fTextField == null) {
            return null;
        }
        return this.fTextField.getText();
    }

    private String getLabelText() {
        return RefactoringMessages.ExtractMethodInputPage_label_text;
    }

    private void createSignaturePreview(Composite composite, RowLayouter layouter) {
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText(RefactoringMessages.ExtractMethodInputPage_signature_preview);
        layouter.perform((Control)previewLabel);
        IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.javascript.core.nature");
        IPreferenceStore store = toolkit.getCombinedPreferenceStore();
        this.fSignaturePreview = new ScriptSourceViewer(composite, null, null, false, 584, store);
        this.fSignaturePreview.configure((SourceViewerConfiguration)new JavascriptSourceViewerConfiguration(toolkit.getTextTools().getColorManager(), store, null, null));
        this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
        this.fSignaturePreview.setDocument((IDocument)this.fSignaturePreviewDocument);
        this.fSignaturePreview.setEditable(false);
        Control signaturePreviewControl = this.fSignaturePreview.getControl();
        PixelConverter pixelConverter = new PixelConverter(signaturePreviewControl);
        GridData gdata = new GridData(1808);
        gdata.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        gdata.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
        signaturePreviewControl.setLayoutData((Object)gdata);
        layouter.perform(signaturePreviewControl);
    }

    private void updatePreview(String text) {
        String signature;
        if (this.fSignaturePreview == null) {
            return;
        }
        if (text.length() == 0) {
            text = "someMethodName";
        }
        int top = this.fSignaturePreview.getTextWidget().getTopPixel();
        try {
            signature = this.fRefactoring.getSignature(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            signature = "";
        }
        this.fSignaturePreviewDocument.set(signature);
        this.fSignaturePreview.getTextWidget().setTopPixel(top);
    }

    private void loadSettings() {
        this.fSettings = this.getDialogSettings().getSection("ExtractMethodWizard");
        if (this.fSettings == null) {
            this.fSettings = this.getDialogSettings().addNewSection("ExtractMethodWizard");
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.setPageComplete(false);
                this.updatePreview(this.getText());
                this.fTextField.setFocus();
            } else {
                this.setPageComplete(this.validatePage(true));
            }
        }
        super.setVisible(visible);
    }

    private void textModified(String text) {
        this.fRefactoring.setMethodName(text);
        RefactoringStatus status = this.validatePage(true);
        if (!status.hasFatalError()) {
            this.updatePreview(text);
        } else {
            this.fSignaturePreviewDocument.set("");
        }
        this.setPageComplete(status);
    }

    private void parameterModified() {
        this.updatePreview(this.getText());
        this.setPageComplete(this.validatePage(false));
    }

    private RefactoringStatus validatePage(boolean text) {
        RefactoringStatus result = new RefactoringStatus();
        if (text) {
            result.merge(this.validateMethodName());
            result.merge(this.validateParameters());
        } else {
            result.merge(this.validateParameters());
            result.merge(this.validateMethodName());
        }
        return result;
    }

    private RefactoringStatus validateMethodName() {
        RefactoringStatus result = new RefactoringStatus();
        String text = this.getText();
        if ("".equals(text)) {
            result.addFatalError(RefactoringMessages.ExtractMethodInputPage_validation_emptyMethodName);
            return result;
        }
        result.merge(this.fRefactoring.checkMethodName());
        return result;
    }

    private RefactoringStatus validateParameters() {
        RefactoringStatus result = new RefactoringStatus();
        List parameters = this.fRefactoring.getParameterInfos();
        for (ParameterInfo info : parameters) {
            if (!"".equals(info.getNewName())) continue;
            result.addFatalError(RefactoringMessages.ExtractMethodInputPage_validation_emptyParameterName);
            return result;
        }
        result.merge(this.fRefactoring.checkParameterNames());
        return result;
    }
}

