/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser.jsdoc;

import java.util.ArrayList;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTags;
import org.eclipse.dltk.utils.IntList;

public class SimpleJSDocParser {
    private static final char FORM_FEED = '\f';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char TAB = '\t';
    private static final char SPACE = ' ';
    private char[] buffer;
    private int index;
    private int end;
    private final StringBuilder value = new StringBuilder();
    private final IntList ranges = new IntList();

    public JSDocTags parse(String content, int offset) {
        ArrayList<JSDocTag> tags = null;
        this.index = "/**".length();
        this.buffer = content.toCharArray();
        this.end = this.buffer.length;
        if (this.index + 2 <= this.end && this.buffer[this.end - 2] == '*' && this.buffer[this.end - 1] == '/') {
            this.end -= 2;
        }
        while (this.index < this.end) {
            switch (this.readChar()) {
                case '\t': 
                case '\f': 
                case ' ': 
                case '*': {
                    break;
                }
                case '\n': {
                    this.skipChar('\r');
                    break;
                }
                case '\r': {
                    this.skipChar('\n');
                    break;
                }
                case '@': {
                    JSDocTag tag = this.parseTag(offset);
                    if (tag != null) {
                        if (tags == null) {
                            tags = new ArrayList<JSDocTag>();
                        }
                        tags.add(tag);
                        break;
                    }
                    this.skipEndOfLine();
                    break;
                }
                default: {
                    this.skipEndOfLine();
                }
            }
        }
        if (tags != null) {
            return new JSDocTags(tags.toArray(new JSDocTag[tags.size()]));
        }
        return JSDocTags.EMPTY;
    }

    private JSDocTag parseTag(int offset) {
        int[] ranges;
        String value;
        int end;
        int valueStart;
        int tagStart = this.index - 1;
        if (this.index < this.end && Character.isLetter(this.buffer[this.index])) {
            ++this.index;
            while (this.index < this.end && (this.buffer[this.index] == '.' || this.buffer[this.index] == '-' || Character.isLetterOrDigit(this.buffer[this.index]))) {
                ++this.index;
            }
        }
        if (this.index == tagStart + 1) {
            return null;
        }
        String tag = new String(this.buffer, tagStart, this.index - tagStart);
        int nameEnd = this.index;
        this.value.setLength(0);
        this.ranges.clear();
        this.skipSpaces();
        boolean lineStart = false;
        block7: while (this.index < this.end) {
            char c = this.readChar();
            switch (c) {
                case '@': {
                    if (lineStart) {
                        this.unread();
                        break block7;
                    }
                    this.value.append(c);
                    this.addToRanges(this.index);
                    break;
                }
                case '\r': {
                    this.skipChar('\n');
                    lineStart = true;
                    this.skipSpaces();
                    if (!this.skipAll('*') || !this.skipChar('/')) continue block7;
                    break block7;
                }
                case '\n': {
                    this.skipChar('\r');
                    lineStart = true;
                    this.skipSpaces();
                    if (!this.skipAll('*') || !this.skipChar('/')) continue block7;
                    break block7;
                }
                case '\t': 
                case '\f': 
                case ' ': {
                    this.value.append(c);
                    this.addToRanges(this.index);
                    break;
                }
                default: {
                    lineStart = false;
                    this.value.append(c);
                    this.addToRanges(this.index);
                }
            }
        }
        int len = this.value.length();
        while (len > 0 && Character.isWhitespace(this.value.charAt(len - 1))) {
            --len;
        }
        if (len != this.value.length()) {
            this.trimRangesBy(this.value.length() - len);
            this.value.setLength(len);
        }
        if (this.ranges.isEmpty()) {
            valueStart = nameEnd;
            end = nameEnd;
            value = "";
            ranges = null;
        } else {
            valueStart = this.ranges.first();
            end = this.ranges.last();
            if (end - valueStart == (value = this.value.toString()).length()) {
                ranges = null;
            } else {
                ranges = this.ranges.toArray();
                int i = 0;
                while (i < ranges.length) {
                    int n = i++;
                    ranges[n] = ranges[n] + offset;
                }
            }
        }
        return new JSDocTag(tag, value, offset + tagStart, offset + valueStart, offset + end, ranges);
    }

    private void trimRangesBy(int delta) {
        if (!this.ranges.isEmpty()) {
            int endIndex;
            for (endIndex = this.ranges.size(); endIndex > 0; endIndex -= 2) {
                int rangeLen = this.ranges.get(endIndex - 1) - this.ranges.get(endIndex - 2);
                if (rangeLen <= delta) {
                    delta -= rangeLen;
                    continue;
                }
                this.ranges.set(endIndex - 1, this.ranges.get(endIndex - 1) - delta);
                break;
            }
            if (endIndex != this.ranges.size()) {
                this.ranges.setSize(endIndex);
            }
        }
    }

    private void addToRanges(int offset) {
        if (this.ranges.isEmpty() || this.ranges.last() != offset - 1) {
            this.ranges.add(offset - 1);
            this.ranges.add(offset);
        } else {
            this.ranges.set(this.ranges.size() - 1, offset);
        }
    }

    private boolean skipAll(char expected) {
        boolean result = false;
        while (this.index < this.end && this.buffer[this.index] == expected) {
            ++this.index;
            result = true;
        }
        return result;
    }

    private void skipSpaces() {
        while (this.index < this.end && (this.buffer[this.index] == ' ' || this.buffer[this.index] == '\t')) {
            ++this.index;
        }
    }

    private void skipEndOfLine() {
        block4: while (this.index < this.end) {
            switch (this.readChar()) {
                case '\r': {
                    this.skipChar('\n');
                    break block4;
                }
                case '\n': {
                    this.skipChar('\r');
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
    }

    private boolean skipChar(char expected) {
        if (this.index < this.end && this.buffer[this.index] == expected) {
            ++this.index;
            return true;
        }
        return false;
    }

    private void unread() {
        --this.index;
    }

    private char readChar() {
        return this.buffer[this.index++];
    }
}

