package org.eclipse.dltk.python.launching;

import org.eclipse.dltk.launching.AbstractRemoteLaunchConfigurationDelegate;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.RemoteDebuggingEngineRunner;
import org.eclipse.dltk.python.core.PythonNature;
import org.eclipse.dltk.python.internal.launching.PythonRemoteDebuggerRunner;

public class PythonRemoteLaunchConfigurationDelegate extends
		AbstractRemoteLaunchConfigurationDelegate {

	@Override
	protected RemoteDebuggingEngineRunner getDebuggingRunner(
			IInterpreterInstall install) {
		return new PythonRemoteDebuggerRunner(install);
	}

	@Override
	public String getLanguageId() {
		return PythonNature.NATURE_ID;
	}

}
