/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.javascript.internal.core.RParameter;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRConstructor;
import org.eclipse.dltk.javascript.typeinfo.IRElement;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRVariable;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;

public class RModelBuilder {
    public static IRMethod create(ITypeInfoContext context, IModelBuilder.IMethod method) {
        if (method.isConstructor()) {
            return new RConstructor(method.getName(), context.contextualize(method.getType()), method.getSuppressedWarnings(), method.getVisibility(), RModelBuilder.convertParams0(context, method.getParameters()), method);
        }
        return new RMethod(method.getName(), context.contextualize(method.getType()), method.getSuppressedWarnings(), method.getVisibility(), RModelBuilder.convertParams0(context, method.getParameters()), method);
    }

    public static IRVariable create(ITypeInfoContext context, IModelBuilder.IVariable variable) {
        return new RVariable(variable.getName(), context.contextualize(variable.getType()), variable.getSuppressedWarnings(), variable.getVisibility(), variable);
    }

    public static List<IRParameter> convert(ITypeSystem context, List<Parameter> parameters) {
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IRParameter> params = new ArrayList<IRParameter>(parameters.size());
        for (Parameter parameter : parameters) {
            IRType paramType = parameter.getType() != null ? RTypes.create(context, parameter.getType()) : RTypes.any();
            params.add(new RParameter(parameter.getName(), paramType, parameter.getKind()));
        }
        return params;
    }

    public static IRParameter createParameter(String name, IRType type, ParameterKind kind) {
        return new RParameter(name, type, kind);
    }

    private static List<IRParameter> convertParams0(ITypeInfoContext context, List<IModelBuilder.IParameter> parameters) {
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IRParameter> params = new ArrayList<IRParameter>(parameters.size());
        for (IModelBuilder.IParameter parameter : parameters) {
            IRType paramType = parameter.getType() != null ? context.contextualize(parameter.getType()) : RTypes.any();
            params.add(new RParameter(parameter.getName(), paramType, parameter.getKind()));
        }
        return params;
    }

    public static IRMethod method(String name, IRType type, List<IRParameter> parameters, Visibility visibility, Object source) {
        return new RMethod(name, type, null, visibility, parameters, source);
    }

    private static class RConstructor
    extends RMethod
    implements IRConstructor {
        public RConstructor(String name, IRType type, Set<IProblemCategory> suppressedWarnings, Visibility visibility, List<IRParameter> parameters, Object source) {
            super(name, type, suppressedWarnings, visibility, parameters, source);
        }
    }

    private static class RElement
    implements IRElement {
        private final String name;
        protected final IRType type;
        private final Set<IProblemCategory> suppressedWarnings;
        private final Object source;

        public RElement(String name, IRType type, Set<IProblemCategory> suppressedWarnings, Object source) {
            this.name = name;
            this.type = type;
            this.suppressedWarnings = suppressedWarnings;
            this.source = source;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public IRType getType() {
            return this.type;
        }

        @Override
        public Set<IProblemCategory> getSuppressedWarnings() {
            return this.suppressedWarnings != null ? this.suppressedWarnings : Collections.emptySet();
        }

        @Override
        public boolean isSuppressed(IProblemIdentifier problemIdentifier) {
            if (this.suppressedWarnings != null) {
                for (IProblemCategory category : this.suppressedWarnings) {
                    if (!category.contents().contains(problemIdentifier)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isDeprecated() {
            if (this.source instanceof IModelBuilder.IMember) {
                return ((IModelBuilder.IMember)this.source).isDeprecated();
            }
            if (this.source instanceof Element) {
                return ((Element)this.source).isDeprecated();
            }
            return false;
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    private static class RMember
    extends RElement
    implements IRMember {
        final Visibility visibility;
        final IRTypeDeclaration typeDeclaration;

        public RMember(String name, IRType type, Set<IProblemCategory> suppressedWarnings, Visibility visibility, Object source, IRTypeDeclaration typeDeclaration) {
            super(name, type, suppressedWarnings, source);
            this.visibility = visibility;
            this.typeDeclaration = typeDeclaration;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public IRTypeDeclaration getDeclaringType() {
            return this.typeDeclaration;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }

    private static class RMethod
    extends RMember
    implements IRMethod {
        final List<IRParameter> parameters;

        public RMethod(String name, IRType type, Set<IProblemCategory> suppressedWarnings, Visibility visibility, List<IRParameter> parameters, Object source) {
            super(name, type, suppressedWarnings, visibility, source, null);
            this.parameters = parameters;
        }

        @Override
        public int getParameterCount() {
            return this.parameters.size();
        }

        @Override
        public List<IRParameter> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean isTyped() {
            if (this.type != null) {
                return true;
            }
            int i = 0;
            while (i < this.parameters.size()) {
                IRParameter parameter = this.parameters.get(i);
                if (parameter.getType() != RTypes.any() || parameter.getKind() != ParameterKind.NORMAL) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isGeneric() {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName());
            sb.append('(');
            int i = 0;
            while (i < this.parameters.size()) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(this.parameters.get(i));
                ++i;
            }
            sb.append(')');
            if (this.type != null) {
                sb.append(':').append(this.type);
            }
            return sb.toString();
        }
    }

    private static class RVariable
    extends RMember
    implements IRVariable {
        public RVariable(String name, IRType type, Set<IProblemCategory> suppressedWarnings, Visibility visibility, Object source) {
            super(name, type, suppressedWarnings, visibility, source, null);
        }
    }
}

