/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.dltk.javascript.internal.ui.refactoring.code.ExtractMethodWizard;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ExtractMethodAction
implements IEditorActionDelegate {
    private ScriptEditor editor;
    private ITextSelection selection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof ITextSelection ? (ITextSelection)selection : null;
        this.checkEnabled(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor instanceof ScriptEditor ? (ScriptEditor)targetEditor : null;
        this.checkEnabled(action);
    }

    private void checkEnabled(IAction action) {
        try {
            action.setEnabled(this.selection != null && this.selection.getLength() > 0 && this.editor != null && SelectionConverter.getInputAsSourceModule((IEditorPart)this.editor) != null);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
    }

    public void run(IAction action) {
        if (!ActionUtil.isEditable((ITextEditor)this.editor)) {
            return;
        }
        ExtractMethodRefactoring refactoring = new ExtractMethodRefactoring(SelectionConverter.getInputAsSourceModule((IEditorPart)this.editor), this.selection.getOffset(), this.selection.getLength());
        try {
            new RefactoringStarter().activate((Refactoring)refactoring, (RefactoringWizard)new ExtractMethodWizard(refactoring), this.editor.getEditorSite().getShell(), RefactoringMessages.ExtractMethodAction_dialog_title, false);
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

