/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.Documentable;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.IVariableStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableStatement
extends Expression
implements IVariableStatement,
Documentable {
    private Keyword varKeyword;
    private final List<VariableDeclaration> variables = new ArrayList<VariableDeclaration>();
    private Comment documentation;

    public VariableStatement(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.varKeyword != null) {
                this.varKeyword.traverse(visitor);
            }
            for (ASTNode aSTNode : this.variables) {
                aSTNode.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    @Override
    public List<VariableDeclaration> getVariables() {
        return this.variables;
    }

    @Override
    public void addVariable(VariableDeclaration declaration) {
        this.variables.add(declaration);
    }

    public Keyword getVarKeyword() {
        return this.varKeyword;
    }

    public void setVarKeyword(Keyword keyword) {
        this.varKeyword = keyword;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append("var");
        buffer.append(" ");
        int i = 0;
        while (i < this.variables.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.variables.get(i).toSourceString(indentationString));
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public Comment getDocumentation() {
        return this.documentation;
    }

    @Override
    public void setDocumentation(Comment documentation) {
        this.documentation = documentation;
    }
}

