/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.IVariableStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSDeclaration;
import org.eclipse.dltk.javascript.ast.JSNode;

public class VariableDeclaration
extends JSNode
implements ISourceable,
JSDeclaration {
    private Identifier identifier;
    private int colonPosition = -1;
    private int assignPosition = -1;
    private Expression initializer;
    private int commaPosition = -1;

    public VariableDeclaration(IVariableStatement parent) {
        super((JSNode)((Object)parent));
    }

    public String toSourceString(String indentationString) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier != null ? this.identifier.getName() : "ERROR");
        if (this.initializer != null) {
            sb.append("=");
            sb.append(this.initializer.toSourceString(indentationString));
        }
        return sb.toString();
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.identifier != null) {
                this.identifier.traverse(visitor);
            }
            if (this.initializer != null) {
                this.initializer.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public int getColonPosition() {
        return this.colonPosition;
    }

    public void setColonPosition(int colonPosition) {
        this.colonPosition = colonPosition;
    }

    public int getAssignPosition() {
        return this.assignPosition;
    }

    public void setAssignPosition(int assignPosition) {
        this.assignPosition = assignPosition;
    }

    public int getCommaPosition() {
        return this.commaPosition;
    }

    public void setCommaPosition(int commaPosition) {
        this.commaPosition = commaPosition;
    }

    public String getVariableName() {
        return this.identifier != null ? this.identifier.getName() : null;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier name) {
        this.identifier = name;
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression initializer) {
        this.initializer = initializer;
    }

    public Comment getDocumentation() {
        return this.identifier != null ? this.identifier.getDocumentation() : null;
    }

    public IVariableStatement getStatement() {
        return (IVariableStatement)((Object)this.getParent());
    }
}

