/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class DefaultXmlNamespaceStatement
extends Statement {
    private Keyword defaultKeyword;
    private Keyword xmlKeyword;
    private Keyword namespaceKeyword;
    private int assignOperation = -1;
    private Expression value;
    private int semic = -1;

    public DefaultXmlNamespaceStatement(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.defaultKeyword != null) {
                this.defaultKeyword.traverse(visitor);
            }
            if (this.xmlKeyword != null) {
                this.xmlKeyword.traverse(visitor);
            }
            if (this.namespaceKeyword != null) {
                this.namespaceKeyword.traverse(visitor);
            }
            if (this.value != null) {
                this.value.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Keyword getDefaultKeyword() {
        return this.defaultKeyword;
    }

    public void setDefaultKeyword(Keyword keyword) {
        this.defaultKeyword = keyword;
    }

    public Keyword getXmlKeyword() {
        return this.xmlKeyword;
    }

    public void setXmlKeyword(Keyword keyword) {
        this.xmlKeyword = keyword;
    }

    public Keyword getNamespaceKeyword() {
        return this.namespaceKeyword;
    }

    public void setNamespaceKeyword(Keyword keyword) {
        this.namespaceKeyword = keyword;
    }

    public int getAssignOperation() {
        return this.assignOperation;
    }

    public void setAssignOperation(int operation) {
        this.assignOperation = operation;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    public int getSemicolonPosition() {
        return this.semic;
    }

    public void setSemicolonPosition(int semic) {
        this.semic = semic;
    }

    public String toSourceString(String indentationString) {
        Assert.isNotNull((Object)this.defaultKeyword);
        Assert.isNotNull((Object)this.xmlKeyword);
        Assert.isNotNull((Object)this.namespaceKeyword);
        Assert.isNotNull((Object)this.value);
        Assert.isTrue((this.assignOperation > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("default");
        buffer.append(" ");
        buffer.append("xml");
        buffer.append(" ");
        buffer.append("namespace");
        buffer.append(" = ");
        buffer.append(this.value.toSourceString(""));
        if (this.semic > 0) {
            buffer.append(";");
        }
        return buffer.toString();
    }
}

