/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.ISemicolonStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Label;
import org.eclipse.dltk.javascript.ast.Statement;

public class BreakStatement
extends Statement
implements ISemicolonStatement {
    private Keyword breakKeyword;
    private Label label;
    private int semic = -1;

    public BreakStatement(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.breakKeyword != null) {
                this.breakKeyword.traverse(visitor);
            }
            if (this.label != null) {
                this.label.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Keyword getBreakKeyword() {
        return this.breakKeyword;
    }

    public void setBreakKeyword(Keyword keyword) {
        this.breakKeyword = keyword;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public int getSemicolonPosition() {
        return this.semic;
    }

    public void setSemicolonPosition(int semic) {
        this.semic = semic;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("break");
        if (this.getLabel() != null) {
            buffer.append(' ');
            buffer.append(this.getLabel().getText());
        }
        buffer.append(";\n");
        return buffer.toString();
    }
}

