/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracketsConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IPunctuationConfiguration;

public class ArrayBracketsConfiguration
implements IBracketsConfiguration,
IPunctuationConfiguration {
    private IFormatterDocument document;
    private final JSNode node;

    public ArrayBracketsConfiguration(IFormatterDocument document, JSNode node) {
        this.document = document;
        this.node = node;
    }

    protected IFormatterDocument getDocument() {
        return this.document;
    }

    public boolean isBeginLineBreaking() {
        if (!this.canBreak()) {
            return false;
        }
        String value = this.document.getString("formatter.braces.array");
        return "next.line".equals(value) || "next.line.indented".equals(value);
    }

    private boolean canBreak() {
        return !(this.node.getParent() instanceof ReturnStatement);
    }

    public boolean isBracketsIndenting() {
        return "next.line.indented".equals(this.document.getString("formatter.braces.array"));
    }

    public boolean isEndLineBreaking() {
        return false;
    }

    public boolean isIndenting() {
        String value = this.document.getString("formatter.braces.array");
        return "next.line".equals(value) || "next.line.indented".equals(value);
    }

    public boolean insertSpaceAfter() {
        return true;
    }

    public boolean insertSpaceBefore() {
        return false;
    }
}

