/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core;

import java.util.List;
import org.eclipse.dltk.internal.javascript.ti.TypeSystemImpl;
import org.eclipse.dltk.javascript.internal.core.RMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.GenericMethod;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMethod
extends RMember<Method>
implements IRMethod {
    private List<IRParameter> parameters;

    public RMethod(Method method, IRType type, List<IRParameter> parameters, IRTypeDeclaration typeDeclaration) {
        super(method, type, typeDeclaration);
        this.parameters = parameters;
    }

    public RMethod(Method method, IRTypeDeclaration typeDeclaration) {
        super(method, typeDeclaration);
    }

    @Override
    protected void initialize(ITypeSystem typeSystem) {
        super.initialize(typeSystem);
        this.parameters = TypeSystemImpl.convertParameters(typeSystem, ((Method)this.member).getParameters());
    }

    @Override
    public int getParameterCount() {
        this.checkInitialized();
        return this.parameters.size();
    }

    @Override
    public List<IRParameter> getParameters() {
        this.checkInitialized();
        return this.parameters;
    }

    @Override
    public boolean isTyped() {
        if (this.getType() != null) {
            return true;
        }
        int i = 0;
        while (i < this.parameters.size()) {
            IRParameter parameter = this.parameters.get(i);
            if (parameter.getType() != RTypes.any() || parameter.getKind() != ParameterKind.NORMAL) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String toString() {
        this.checkInitialized();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append('(');
        int i = 0;
        while (i < this.getParameterCount()) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.parameters.get(i).toString());
            ++i;
        }
        sb.append(')');
        sb.append(':');
        sb.append(this.getType());
        return sb.toString();
    }

    @Override
    public boolean isAbstract() {
        return ((Method)this.member).isAbstract();
    }

    @Override
    public boolean isGeneric() {
        return this.member instanceof GenericMethod;
    }
}

