/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.structure.IDeclaration;
import org.eclipse.dltk.javascript.structure.IParentNode;
import org.eclipse.dltk.javascript.structure.IScope;
import org.eclipse.dltk.javascript.structure.IStructureContext;
import org.eclipse.dltk.javascript.structure.IStructureNode;
import org.eclipse.dltk.javascript.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.structure.StructureNode;

public abstract class ParentNode
extends StructureNode
implements IParentNode {
    private List<NodeReference> references;

    public ParentNode(IParentNode parent) {
        super(parent);
    }

    private void addReference(NodeReference reference) {
        if (this.references == null) {
            this.references = new ArrayList<NodeReference>();
        }
        this.references.add(reference);
    }

    public void addLocalReference(Identifier node, IDeclaration resolved) {
        this.addReference(new LocalReference(node, resolved));
    }

    public void addMethodReference(Identifier identifier, int argCount) {
        this.addReference(new MethodRefence(identifier, argCount));
    }

    public void addFieldReference(Identifier identifier) {
        this.addReference(new FieldReference(identifier));
    }

    protected boolean isStructureKnown() {
        return true;
    }

    public void addToScope(IStructureNode child) {
        if (!this.isStructureKnown()) {
            this.getScope().addChild(child);
        }
    }

    protected void reportChildrenStructure(IStructureRequestor requestor, IStructureContext context) {
        if (this.references != null) {
            List<? extends IStructureNode> children = this.getChildren();
            ArrayList<? extends IStructureNode> nodes = new ArrayList<IStructureNode>(children.size() + this.references.size());
            nodes.addAll(children);
            nodes.addAll(this.references);
            Collections.sort(nodes, new Comparator<IStructureNode>(){

                @Override
                public int compare(IStructureNode o1, IStructureNode o2) {
                    return o1.start() - o2.start();
                }
            });
            for (IStructureNode iStructureNode : nodes) {
                iStructureNode.reportStructure(requestor, context);
            }
        } else {
            super.reportChildrenStructure(requestor, context);
        }
    }

    static class FieldReference
    extends NodeReference {
        public FieldReference(Identifier identifier) {
            super(identifier);
        }

        public void reportStructure(IStructureRequestor requestor, IStructureContext context) {
            requestor.acceptFieldReference(this.identifier);
        }
    }

    static class LocalReference
    extends NodeReference {
        final IDeclaration declaration;

        public LocalReference(Identifier identifier, IDeclaration declaration) {
            super(identifier);
            this.declaration = declaration;
        }

        public void reportStructure(IStructureRequestor requestor, IStructureContext context) {
            requestor.acceptLocalReference(this.identifier, this.declaration);
        }
    }

    static class MethodRefence
    extends NodeReference {
        final int argCount;

        public MethodRefence(Identifier identifier, int argCount) {
            super(identifier);
            this.argCount = argCount;
        }

        public void reportStructure(IStructureRequestor requestor, IStructureContext context) {
            requestor.acceptMethodReference(this.identifier, this.argCount);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class NodeReference
    implements IStructureNode {
        final Identifier identifier;

        public NodeReference(Identifier identifier) {
            this.identifier = identifier;
        }

        @Override
        public int start() {
            return this.identifier.start();
        }

        @Override
        public boolean isManyChildren() {
            return false;
        }

        @Override
        public List<? extends IStructureNode> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public IParentNode getParent() {
            return null;
        }

        @Override
        public IScope getScope() {
            return null;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "(" + this.identifier.getName() + ")";
        }
    }
}

