/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Literal;

public class BooleanLiteral
extends Literal {
    private final String text;

    public BooleanLiteral(ASTNode parent, String text) {
        super(parent);
        this.text = text;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            visitor.endvisit((ASTNode)this);
        }
    }

    public String getText() {
        return this.text;
    }

    public boolean booleanValue() {
        return "true".equals(this.text);
    }

    public String toSourceString(String indentionString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        return this.text;
    }
}

