/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.javascript.internal.ui.text.completion.GenericTypeCompletionProposal;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptCompletionProposal;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptProposalInfo;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.LazyScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ProposalContextInformation;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public class JavaScriptCompletionProposalCollector
extends ScriptCompletionProposalCollector {
    protected static final char[] VAR_TRIGGER = new char[]{'\t', ' ', '=', ';', '.'};

    protected char[] getVarTrigger() {
        return VAR_TRIGGER;
    }

    public JavaScriptCompletionProposalCollector(ISourceModule module) {
        super(module);
    }

    private boolean hasProposalInfo(AbstractScriptCompletionProposal proposal) {
        if (proposal instanceof LazyScriptCompletionProposal) {
            return true;
        }
        return proposal.getProposalInfo() != null;
    }

    protected IScriptCompletionProposal createScriptCompletionProposal(CompletionProposal proposal) {
        AbstractScriptCompletionProposal outProposal = (AbstractScriptCompletionProposal)super.createScriptCompletionProposal(proposal);
        if (!this.hasProposalInfo(outProposal) && proposal.getExtraInfo() != null) {
            outProposal.setProposalInfo((ProposalInfo)new JavaScriptProposalInfo(proposal.getExtraInfo()));
        }
        return outProposal;
    }

    protected IScriptCompletionProposal createTypeProposal(CompletionProposal typeProposal) {
        if (this.getAttribute(TypeMode.JSDOC) != null && typeProposal.getExtraInfo() instanceof GenericType) {
            return new GenericTypeCompletionProposal(typeProposal, this.getInvocationContext());
        }
        return super.createTypeProposal(typeProposal);
    }

    protected IScriptCompletionProposal createMethodReferenceProposal(CompletionProposal methodProposal) {
        Method method;
        AbstractScriptCompletionProposal methodReferenceProposal = (AbstractScriptCompletionProposal)super.createMethodReferenceProposal(methodProposal);
        if (methodProposal.getExtraInfo() != null) {
            methodReferenceProposal.setProposalInfo((ProposalInfo)new JavaScriptProposalInfo(methodProposal.getExtraInfo()));
        }
        StringBuilder sb = null;
        if (methodProposal.getExtraInfo() instanceof Method) {
            method = (Method)methodProposal.getExtraInfo();
            EList parameters = method.getParameters();
            if (parameters.size() > 0) {
                sb = new StringBuilder();
                for (Parameter parameter : parameters) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    if (parameter.getKind() == ParameterKind.OPTIONAL) {
                        sb.append('[');
                    }
                    if (parameter.getType() != null) {
                        sb.append(parameter.getType().getName());
                        if (parameter.getKind() == ParameterKind.VARARGS) {
                            sb.append("...");
                        }
                        sb.append(' ');
                    }
                    sb.append(parameter.getName());
                    if (parameter.getKind() == ParameterKind.VARARGS && parameter.getType() == null) {
                        sb.append("...");
                    }
                    if (parameter.getKind() != ParameterKind.OPTIONAL) continue;
                    sb.append(']');
                }
            }
        } else if (methodProposal.getExtraInfo() instanceof IValueReference && (method = (IRMethod)((IValueReference)methodProposal.getExtraInfo()).getAttribute("R_METHOD")) != null && method.getParameterCount() > 0) {
            sb = new StringBuilder();
            for (IRParameter parameter : method.getParameters()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (parameter.isOptional()) {
                    sb.append('[');
                }
                if (parameter.getType() != null) {
                    sb.append(parameter.getType().getName());
                    if (parameter.isVarargs()) {
                        sb.append("...");
                    }
                    sb.append(' ');
                }
                sb.append(parameter.getName());
                if (parameter.isVarargs() && parameter.getType() == null) {
                    sb.append("...");
                }
                if (!parameter.isOptional()) continue;
                sb.append(']');
            }
        }
        if (sb != null) {
            JavaScriptProposalContextInformation contextInformation = new JavaScriptProposalContextInformation(methodProposal, sb.toString());
            contextInformation.setContextInformationPosition(methodProposal.getReplaceStart() + methodProposal.getCompletion().length() + 1);
            methodReferenceProposal.setContextInformation((IContextInformation)contextInformation);
        }
        return methodReferenceProposal;
    }

    protected IScriptCompletionProposal createFieldProposal(CompletionProposal proposal) {
        IScriptCompletionProposal fieldProposal = super.createFieldProposal(proposal);
        if (proposal.getExtraInfo() != null) {
            ((AbstractScriptCompletionProposal)fieldProposal).setProposalInfo((ProposalInfo)new JavaScriptProposalInfo(proposal.getExtraInfo()));
        }
        return fieldProposal;
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, String displayString, int i, boolean isInDoc) {
        JavaScriptCompletionProposal javaScriptCompletionProposal = new JavaScriptCompletionProposal(completion, replaceStart, length, image, displayString, i, isInDoc);
        return javaScriptCompletionProposal;
    }

    protected IScriptCompletionProposal createKeywordProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.getLabelProvider().createSimpleLabel(proposal);
        Image img = this.getImage(this.getLabelProvider().createImageDescriptor(proposal));
        int relevance = this.computeRelevance(proposal);
        return this.createScriptCompletionProposal(completion, start, length, img, label, relevance, false);
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.javascript.core.nature";
    }

    private static final class JavaScriptProposalContextInformation
    extends ProposalContextInformation {
        private final String informationDisplayString;

        public JavaScriptProposalContextInformation(CompletionProposal proposal, String informationDisplayString) {
            super(proposal);
            this.informationDisplayString = informationDisplayString;
        }

        public String getInformationDisplayString() {
            return this.informationDisplayString;
        }
    }
}

