/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.templates;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.ScriptFormatterManager;
import org.eclipse.dltk.ui.templates.ScriptTemplateContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptTemplateContext
extends ScriptTemplateContext {
    public JavaScriptTemplateContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ISourceModule sourceModule) {
        super(type, document, completionOffset, completionLength, sourceModule);
    }

    public JavaScriptTemplateContext(TemplateContextType type, IDocument document, Position position, ISourceModule sourceModule) {
        super(type, document, position, sourceModule);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        IScriptFormatterFactory factory = ScriptFormatterManager.getSelected((String)"org.eclipse.dltk.javascript.core.nature", (IProject)this.getSourceModule().getScriptProject().getProject());
        if (factory != null) {
            IScriptFormatter formatter = factory.createFormatter(TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()), factory.retrievePreferences(this.getPreferences()));
            try {
                HashMap<String, String> remeberedVariables = new HashMap<String, String>();
                String encoded = JavaScriptTemplateContext.encodeVariables(template.getPattern(), remeberedVariables);
                TextEdit edit = formatter.format(encoded, 0, encoded.length(), 0);
                if (edit != null) {
                    Document document = new Document(encoded);
                    edit.apply((IDocument)document);
                    template = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), JavaScriptTemplateContext.restoreVariables(document.get(), remeberedVariables), template.isAutoInsertable());
                }
            }
            catch (FormatterException e) {
                JavaScriptUI.log((Exception)((Object)e));
            }
        }
        return super.evaluate(template);
    }

    private static String encodeVariables(String content, Map<String, String> variables) {
        StringBuilder bf = new StringBuilder(content.length() * 2);
        boolean in = false;
        int r = 0;
        int pos = -1;
        int a = 0;
        while (a < content.length()) {
            char c = content.charAt(a);
            if (c == '$') {
                if (a < content.length() - 1 && content.charAt(a + 1) == '{') {
                    in = true;
                    pos = a;
                }
            } else if (in) {
                if (c == '}') {
                    String variableValue = content.substring(pos, a + 1);
                    String variableKey = "specialSecret12435Id" + r++;
                    bf.append(variableKey);
                    variables.put(variableKey, variableValue);
                    in = false;
                }
            } else if (!in) {
                bf.append(c);
            }
            ++a;
        }
        return bf.toString();
    }

    private static String restoreVariables(String value, Map<String, String> variables) {
        String formatted = value;
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            formatted = JavaScriptTemplateContext.replaceSeq(formatted, entry.getKey(), entry.getValue());
        }
        return formatted;
    }

    private static String replaceSeq(String sq, String target, String replacement) {
        int indexOf = sq.indexOf(target);
        while (indexOf != -1) {
            sq = String.valueOf(sq.substring(0, indexOf)) + replacement + sq.substring(indexOf + target.length());
            indexOf = sq.indexOf(target);
        }
        return sq;
    }
}

