/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchComponent;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.YieldOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractNavigationVisitor<E>
extends ASTVisitor<E> {
    @Override
    public E visitArrayInitializer(ArrayInitializer node) {
        for (ASTNode aSTNode : node.getItems()) {
            this.visit(aSTNode);
        }
        return null;
    }

    @Override
    public E visitAsteriskExpression(AsteriskExpression node) {
        return null;
    }

    @Override
    public E visitBinaryOperation(BinaryOperation node) {
        this.visit(node.getLeftExpression());
        this.visit(node.getRightExpression());
        return null;
    }

    @Override
    public E visitBooleanLiteral(BooleanLiteral node) {
        return null;
    }

    @Override
    public E visitBreakStatement(BreakStatement node) {
        return null;
    }

    @Override
    public E visitCallExpression(CallExpression node) {
        this.visit(node.getExpression());
        for (ASTNode argument : node.getArguments()) {
            this.visit(argument);
        }
        return null;
    }

    @Override
    public E visitCommaExpression(CommaExpression node) {
        for (ASTNode item : node.getItems()) {
            this.visit(item);
        }
        return null;
    }

    @Override
    public E visitConditionalOperator(ConditionalOperator node) {
        this.visit(node.getCondition());
        this.visit(node.getTrueValue());
        this.visit(node.getFalseValue());
        return null;
    }

    @Override
    public E visitConstDeclaration(ConstStatement node) {
        this.processVariables(node.getVariables());
        return null;
    }

    private void processVariables(List<VariableDeclaration> variables) {
        for (VariableDeclaration declaration : variables) {
            if (declaration.getInitializer() == null) continue;
            this.visit(declaration.getInitializer());
        }
    }

    @Override
    public E visitContinueStatement(ContinueStatement node) {
        return null;
    }

    @Override
    public E visitDecimalLiteral(DecimalLiteral node) {
        return null;
    }

    @Override
    public E visitDefaultXmlNamespace(DefaultXmlNamespaceStatement node) {
        return null;
    }

    @Override
    public E visitDoWhileStatement(DoWhileStatement node) {
        Object result = this.visit(node.getBody());
        this.visitCondition(node.getCondition());
        return result;
    }

    protected void visitCondition(Expression condition) {
        this.visit(condition);
    }

    @Override
    public E visitEmptyExpression(EmptyExpression node) {
        return null;
    }

    @Override
    public E visitEmptyStatement(EmptyStatement node) {
        return null;
    }

    @Override
    public E visitForEachInStatement(ForEachInStatement node) {
        this.visit(node.getItem());
        this.visit(node.getIterator());
        return this.visit(node.getBody());
    }

    @Override
    public E visitForInStatement(ForInStatement node) {
        this.visit(node.getItem());
        this.visit(node.getIterator());
        return this.visit(node.getBody());
    }

    @Override
    public E visitForStatement(ForStatement node) {
        this.visit(node.getInitial());
        this.visit(node.getCondition());
        this.visit(node.getStep());
        return this.visit(node.getBody());
    }

    @Override
    public E visitFunctionStatement(FunctionStatement node) {
        return this.visit(node.getBody());
    }

    @Override
    public E visitGetAllChildrenExpression(GetAllChildrenExpression node) {
        this.visit(node.getObject());
        this.visit(node.getProperty());
        return null;
    }

    @Override
    public E visitGetArrayItemExpression(GetArrayItemExpression node) {
        this.visit(node.getArray());
        this.visit(node.getIndex());
        return null;
    }

    @Override
    public E visitGetLocalNameExpression(GetLocalNameExpression node) {
        this.visit(node.getNamespace());
        this.visit(node.getLocalName());
        return null;
    }

    @Override
    public E visitIdentifier(Identifier node) {
        return null;
    }

    @Override
    public E visitIfStatement(IfStatement node) {
        this.visitCondition(node.getCondition());
        if (node.getThenStatement() != null) {
            this.visit(node.getThenStatement());
        }
        if (node.getElseStatement() != null) {
            this.visit(node.getElseStatement());
        }
        return null;
    }

    @Override
    public E visitLabelledStatement(LabelledStatement node) {
        this.visit(node.getStatement());
        return null;
    }

    @Override
    public E visitNewExpression(NewExpression node) {
        this.visit(node.getObjectClass());
        return null;
    }

    @Override
    public E visitNullExpression(NullExpression node) {
        return null;
    }

    @Override
    public E visitObjectInitializer(ObjectInitializer node) {
        for (ObjectInitializerPart part : node.getInitializers()) {
            if (part instanceof GetMethod) {
                this.visitMethod((GetMethod)part);
                continue;
            }
            if (part instanceof SetMethod) {
                this.visitMethod((SetMethod)part);
                continue;
            }
            if (!(part instanceof PropertyInitializer)) continue;
            PropertyInitializer pi = (PropertyInitializer)part;
            this.visit(pi.getName());
            this.visit(pi.getValue());
        }
        return null;
    }

    protected E visitMethod(Method method) {
        return this.visit(method.getBody());
    }

    @Override
    public E visitParenthesizedExpression(ParenthesizedExpression node) {
        this.visit(node.getExpression());
        return null;
    }

    @Override
    public E visitPropertyExpression(PropertyExpression node) {
        this.visit(node.getObject());
        this.visit(node.getProperty());
        return null;
    }

    @Override
    public E visitRegExpLiteral(RegExpLiteral node) {
        return null;
    }

    @Override
    public E visitReturnStatement(ReturnStatement node) {
        if (node.getValue() != null) {
            this.visit(node.getValue());
        }
        return null;
    }

    @Override
    public E visitScript(Script node) {
        for (Statement statement : node.getStatements()) {
            this.visit(statement);
        }
        return null;
    }

    @Override
    public E visitStatementBlock(StatementBlock node) {
        for (Statement statement : node.getStatements()) {
            this.visit(statement);
        }
        return null;
    }

    @Override
    public E visitStringLiteral(StringLiteral node) {
        return null;
    }

    @Override
    public E visitSwitchStatement(SwitchStatement node) {
        if (node.getCondition() != null) {
            this.visit(node.getCondition());
        }
        for (SwitchComponent component : node.getCaseClauses()) {
            CaseClause caseClause;
            if (component instanceof CaseClause && (caseClause = (CaseClause)component).getCondition() != null) {
                this.visit(caseClause.getCondition());
            }
            for (Statement statement : component.getStatements()) {
                this.visit(statement);
            }
        }
        return null;
    }

    @Override
    public E visitThisExpression(ThisExpression node) {
        return null;
    }

    @Override
    public E visitThrowStatement(ThrowStatement node) {
        if (node.getException() != null) {
            this.visit(node.getException());
        }
        return null;
    }

    @Override
    public E visitTryStatement(TryStatement node) {
        Statement finallyStatement;
        this.visit(node.getBody());
        for (CatchClause catchClause : node.getCatches()) {
            Statement catchStatement;
            if (catchClause.getFilterExpression() != null) {
                this.visit(catchClause.getFilterExpression());
            }
            if ((catchStatement = catchClause.getStatement()) == null) continue;
            this.visit(catchStatement);
        }
        if (node.getFinally() != null && (finallyStatement = node.getFinally().getStatement()) != null) {
            this.visit(finallyStatement);
        }
        return null;
    }

    @Override
    public E visitUnaryOperation(UnaryOperation node) {
        this.visit(node.getExpression());
        return null;
    }

    @Override
    public E visitVariableStatement(VariableStatement node) {
        this.processVariables(node.getVariables());
        return null;
    }

    @Override
    public E visitVoidExpression(VoidExpression node) {
        this.visit(node.getExpression());
        return null;
    }

    @Override
    public E visitWhileStatement(WhileStatement node) {
        this.visitCondition(node.getCondition());
        return this.visit(node.getBody());
    }

    @Override
    public E visitWithStatement(WithStatement node) {
        this.visit(node.getExpression());
        this.visit(node.getStatement());
        return null;
    }

    @Override
    public E visitXmlLiteral(XmlLiteral node) {
        return null;
    }

    @Override
    public E visitXmlPropertyIdentifier(XmlAttributeIdentifier node) {
        this.visit(node.getExpression());
        return null;
    }

    @Override
    public E visitYieldOperator(YieldOperator node) {
        this.visit(node.getParent());
        return null;
    }
}

