/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FloatNumberRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IToken fToken;
    protected int fColumn = -1;

    public FloatNumberRule(IToken token) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c;
        int p = c = scanner.read();
        if (Character.isDigit((char)c) || c == 46) {
            boolean hex = false;
            if (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1) {
                do {
                    p = c;
                    c = scanner.read();
                    if (c != 120 && (c != 88 || hex)) continue;
                    hex = true;
                    p = c;
                    c = scanner.read();
                } while (Character.isDigit((char)c));
                if (c != 101 && c != 69) {
                    scanner.unread();
                }
                if (p == 46) {
                    scanner.unread();
                    return Token.UNDEFINED;
                }
                return this.fToken;
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

