/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

class DataFlowBitSet {
    private int[] itsBits;
    private int itsSize;

    DataFlowBitSet(int size) {
        this.itsSize = size;
        this.itsBits = new int[size + 31 >> 5];
    }

    void set(int n) {
        if (n < 0 || n >= this.itsSize) {
            this.badIndex(n);
        }
        int n2 = n >> 5;
        this.itsBits[n2] = this.itsBits[n2] | 1 << (n & 0x1F);
    }

    boolean test(int n) {
        if (n < 0 || n >= this.itsSize) {
            this.badIndex(n);
        }
        return (this.itsBits[n >> 5] & 1 << (n & 0x1F)) != 0;
    }

    void not() {
        int bitsLength = this.itsBits.length;
        int i = 0;
        while (i < bitsLength) {
            this.itsBits[i] = ~this.itsBits[i];
            ++i;
        }
    }

    void clear(int n) {
        if (n < 0 || n >= this.itsSize) {
            this.badIndex(n);
        }
        int n2 = n >> 5;
        this.itsBits[n2] = this.itsBits[n2] & ~(1 << (n & 0x1F));
    }

    void clear() {
        int bitsLength = this.itsBits.length;
        int i = 0;
        while (i < bitsLength) {
            this.itsBits[i] = 0;
            ++i;
        }
    }

    void or(DataFlowBitSet b) {
        int bitsLength = this.itsBits.length;
        int i = 0;
        while (i < bitsLength) {
            int n = i;
            this.itsBits[n] = this.itsBits[n] | b.itsBits[i];
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DataFlowBitSet, size = ");
        sb.append(this.itsSize);
        sb.append('\n');
        int bitsLength = this.itsBits.length;
        int i = 0;
        while (i < bitsLength) {
            sb.append(Integer.toHexString(this.itsBits[i]));
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    boolean df(DataFlowBitSet in, DataFlowBitSet gen, DataFlowBitSet notKill) {
        int bitsLength = this.itsBits.length;
        boolean changed = false;
        int i = 0;
        while (i < bitsLength) {
            int oldBits = this.itsBits[i];
            this.itsBits[i] = (in.itsBits[i] | gen.itsBits[i]) & notKill.itsBits[i];
            changed |= oldBits != this.itsBits[i];
            ++i;
        }
        return changed;
    }

    boolean df2(DataFlowBitSet in, DataFlowBitSet gen, DataFlowBitSet notKill) {
        int bitsLength = this.itsBits.length;
        boolean changed = false;
        int i = 0;
        while (i < bitsLength) {
            int oldBits = this.itsBits[i];
            this.itsBits[i] = in.itsBits[i] & notKill.itsBits[i] | gen.itsBits[i];
            changed |= oldBits != this.itsBits[i];
            ++i;
        }
        return changed;
    }

    private void badIndex(int n) {
        throw new RuntimeException("DataFlowBitSet bad index " + n);
    }
}

