/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.internal.corext.refactoring.base.ScriptStatusContext;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.util.Selection;
import org.eclipse.dltk.internal.javascript.corext.refactoring.util.SelectionAnalyzer;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public class StatementAnalyzer
extends SelectionAnalyzer {
    protected ISourceModule fCUnit;
    private RefactoringStatus fStatus;

    public StatementAnalyzer(ISourceModule cunit, Selection selection, boolean traverseSelectedNode) {
        super(selection, traverseSelectedNode);
        Assert.isNotNull((Object)cunit);
        this.fCUnit = cunit;
        this.fStatus = new RefactoringStatus();
    }

    protected void checkSelectedNodes() {
        Node[] nodes = this.getSelectedNodes();
        if (nodes.length == 0) {
            return;
        }
        Node first = nodes[0];
        Node last = nodes[nodes.length - 1];
        if (first.eContainingFeature() != last.eContainingFeature()) {
            SourceRange range = new SourceRange(this.getSelection().getOffset(), this.getSelection().getLength());
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_doesNotCover, ScriptStatusContext.create((ISourceModule)this.fCUnit, (ISourceRange)range));
        }
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public Boolean caseSource(Source node) {
        if (this.hasSelectedNodes() && !this.fStatus.hasFatalError()) {
            this.checkSelectedNodes();
        }
        return null;
    }

    protected void invalidSelection(String message, RefactoringStatusContext context) {
        this.fStatus.addFatalError(message, context);
        this.reset();
    }
}

