/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.hyperlink;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.typeinfo.IElementConverter;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.dltk.ui.infoviews.ModelElementArray;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JSDocTypeHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion inputRegion, boolean canShowMultipleHyperlinks) {
        ISourceModule input;
        OpenAction openAction;
        int end;
        int start;
        String line;
        IRegion lineRegion;
        block21: {
            IAction action;
            ITextEditor editor;
            block20: {
                block19: {
                    block18: {
                        int offset;
                        block17: {
                            IDocument doc;
                            block16: {
                                if (inputRegion == null || textViewer == null) {
                                    return null;
                                }
                                doc = textViewer.getDocument();
                                offset = inputRegion.getOffset();
                                String contentType = TextUtilities.getContentType((IDocument)doc, (String)"__javascript_partitioning", (int)offset, (boolean)true);
                                if ("__javascript_doc".equals(contentType) || "__javascript_comment".equals(contentType)) break block16;
                                return null;
                            }
                            int lineNumber = doc.getLineOfOffset(offset);
                            lineRegion = doc.getLineInformation(lineNumber);
                            line = doc.get(lineRegion.getOffset(), lineRegion.getLength());
                            start = line.lastIndexOf(123, offset - lineRegion.getOffset());
                            if (start >= 0) break block17;
                            return null;
                        }
                        end = line.indexOf(125, offset - lineRegion.getOffset());
                        if (end >= 0) break block18;
                        return null;
                    }
                    editor = (ITextEditor)this.getAdapter(ITextEditor.class);
                    if (editor != null) break block19;
                    return null;
                }
                action = editor.getAction("OpenEditor");
                if (action != null && action instanceof OpenAction) break block20;
                return null;
            }
            openAction = (OpenAction)action;
            input = EditorUtility.getEditorInputModelElement((IEditorPart)editor, (boolean)false);
            if (input != null) break block21;
            return null;
        }
        try {
            String typeName = line.substring(start + 1, end);
            TypeInferencer2 inferencer2 = new TypeInferencer2();
            inferencer2.setModelElement((IModelElement)input);
            Type type = inferencer2.getKnownType(typeName, TypeMode.JSDOC);
            Object[] elements = null;
            if (type == null) {
                try {
                    ScriptModelUtil.reconcile((ISourceModule)input);
                    input.accept((IModelElementVisitor)new Visitor(typeName));
                }
                catch (ModelException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (ModelElementFound e) {
                    elements = new Object[]{e.element};
                }
            } else {
                elements = SelectionConverter.filterElements((Object[])new Object[]{this.convert(input, type)});
            }
            if (elements != null && elements.length > 0) {
                Region region = new Region(lineRegion.getOffset() + start + 1, end - start - 1);
                ModelElementHyperlink link = elements.length == 1 ? new ModelElementHyperlink((IRegion)region, elements[0], openAction) : new ModelElementHyperlink((IRegion)region, (Object)new ModelElementArray(elements), openAction);
                return new IHyperlink[]{link};
            }
        }
        catch (BadLocationException e) {
            JavaScriptUI.log((Exception)((Object)e));
        }
        return null;
    }

    public Object convert(ISourceModule input, Type type) {
        IElementConverter[] iElementConverterArray = TypeInfoManager.getElementConverters();
        int n = iElementConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementConverter converter = iElementConverterArray[n2];
            IModelElement converted = converter.convert(input, (Element)type);
            if (converted != null) {
                return converted;
            }
            ++n2;
        }
        return type;
    }

    private static class ModelElementFound
    extends RuntimeException {
        private final IModelElement element;

        public ModelElementFound(IModelElement element) {
            this.element = element;
        }
    }

    private static class Visitor
    implements IModelElementVisitor {
        private final String name;

        public Visitor(String name) {
            this.name = name;
        }

        public boolean visit(IModelElement element) {
            IMember member;
            if (element instanceof IMember && this.name.equals((member = (IMember)element).getElementName())) {
                throw new ModelElementFound(element);
            }
            return true;
        }
    }
}

