/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.io.StringReader;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.utils.ASTUtil;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.XmlFragment;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.XmlTextFragment;
import org.eclipse.dltk.javascript.internal.ui.text.Token;
import org.eclipse.dltk.javascript.internal.ui.text.XMLTokenizer;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.ui.editor.highlighting.AbortSemanticHighlightingException;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;

public class JavaScriptXmlHighlighter
implements ISemanticHighlighter {
    private static final String HL_XML_TAG = "XML_TAG_NAME";
    private static final String HL_XML_ATTRIBUTE = "XML_ATTR_NAME";
    private static final String HL_XML_COMMENT = "XML_COMMENT_NAME";
    private static final String HL_KEYWORD = "DLTK_keyword";
    private static final String HL_REGEXP = "JS_REGEXP";

    public String[] getHighlightingKeys() {
        return new String[]{HL_XML_TAG, HL_XML_ATTRIBUTE, HL_XML_COMMENT, HL_KEYWORD, HL_REGEXP};
    }

    public void process(IModuleSource code, ISemanticHighlightingRequestor requestor) {
        Keyword keyword;
        Script declaration = JavaScriptParserUtil.parse((IModuleSource)code, null);
        if (declaration == null) {
            throw new AbortSemanticHighlightingException();
        }
        for (XmlLiteral literal : ASTUtil.select((ASTNode)declaration, XmlLiteral.class)) {
            for (XmlFragment fragment : literal.getFragments()) {
                if (!(fragment instanceof XmlTextFragment)) continue;
                XMLTokenizer tokenizer = new XMLTokenizer(new StringReader(((XmlTextFragment)fragment).getXml()));
                int offset = fragment.sourceStart();
                List tokens = tokenizer.getRegions();
                for (Token token : tokens) {
                    if (token.context == "5") {
                        JavaScriptXmlHighlighter.addRange(requestor, offset, token, HL_XML_TAG);
                        continue;
                    }
                    if (token.context == "28") {
                        JavaScriptXmlHighlighter.addRange(requestor, offset, token, HL_XML_ATTRIBUTE);
                        continue;
                    }
                    if (token.context == "16" || token.context == "8" || token.context == "17") {
                        JavaScriptXmlHighlighter.addRange(requestor, offset, token, HL_XML_COMMENT);
                        continue;
                    }
                    String cfr_ignored_0 = token.context;
                }
            }
        }
        for (Method method : ASTUtil.select((ASTNode)declaration, Method.class)) {
            if (method instanceof GetMethod) {
                keyword = ((GetMethod)method).getGetKeyword();
            } else {
                if (!(method instanceof SetMethod)) continue;
                keyword = ((SetMethod)method).getSetKeyword();
            }
            requestor.addPosition(keyword.sourceStart(), keyword.sourceEnd(), HL_KEYWORD);
        }
        for (ForEachInStatement forEach : ASTUtil.select((ASTNode)declaration, ForEachInStatement.class)) {
            keyword = forEach.getEachKeyword();
            requestor.addPosition(keyword.sourceStart(), keyword.sourceEnd(), HL_KEYWORD);
        }
        for (RegExpLiteral regExp : ASTUtil.select((ASTNode)declaration, RegExpLiteral.class)) {
            requestor.addPosition(regExp.sourceStart(), regExp.sourceEnd(), HL_REGEXP);
        }
    }

    private static void addRange(ISemanticHighlightingRequestor requestor, int start, Token token, String highlightingKey) {
        requestor.addPosition(start + token.start, start + token.start + token.textLength, highlightingKey);
    }
}

