/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodPattern;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.internal.search.FieldReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MethodReferenceNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPredicate
extends AbstractMatchingPredicate<MatchingNode> {
    private final boolean declarations;
    private final boolean references;
    private final ISourceModule module;
    private final int nameStart;
    private final int nameEnd;

    public MethodPredicate(MethodPattern pattern) {
        this((SearchPattern)pattern, pattern.selector, pattern.findDeclarations, pattern.findReferences);
    }

    public MethodPredicate(MethodDeclarationPattern pattern) {
        this((SearchPattern)pattern, pattern.simpleName, true, false);
    }

    private MethodPredicate(SearchPattern pattern, char[] pat, boolean declarations, boolean references) {
        super(pattern, pat);
        this.declarations = declarations;
        this.references = references;
        ISourceRange nameRange = null;
        if (pattern.focus instanceof IMember) {
            try {
                nameRange = ((IMember)pattern.focus).getNameRange();
            }
            catch (ModelException modelException) {}
        }
        if (nameRange != null) {
            this.nameStart = nameRange.getOffset();
            this.nameEnd = this.nameStart + nameRange.getLength();
            this.module = pattern.focus != null ? (ISourceModule)pattern.focus.getAncestor(5) : null;
        } else {
            this.nameStart = -1;
            this.nameEnd = -1;
            this.module = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatchLevel match(MatchingNode node) {
        if (node instanceof MethodDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            MethodDeclarationNode mNode = (MethodDeclarationNode)node;
            return this.matchName(mNode.getName());
        }
        if (node instanceof MethodReferenceNode) {
            if (!this.references) {
                return null;
            }
            MethodReferenceNode mNode = (MethodReferenceNode)node;
            ReferenceLocation location = mNode.getReferenceLocation();
            if (location == null || this.nameStart == -1 || this.nameEnd == -1) return this.matchName(((Identifier)mNode.node).getName());
            if (location.getNameStart() != this.nameStart || location.getNameEnd() != this.nameEnd || !this.isSame(location.getSourceModule())) return null;
            return this.matchName(((Identifier)mNode.node).getName());
        }
        if (!(node instanceof FieldReferenceNode)) return null;
        if (!this.references) {
            return null;
        }
        FieldReferenceNode mNode = (FieldReferenceNode)node;
        ReferenceLocation location = mNode.getReferenceLocation();
        if (location == null || this.nameStart == -1 || this.nameEnd == -1 || location.getNameStart() != this.nameStart || location.getNameEnd() != this.nameEnd || !this.isSame(location.getSourceModule())) return null;
        return this.matchName(((Identifier)mNode.node).getName());
    }

    private boolean isSame(ISourceModule module) {
        return module != null && module.equals(this.module);
    }
}

