/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.javascript.core.JavaScriptKeywords;
import org.eclipse.dltk.javascript.internal.ui.rules.FloatNumberRule;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWhitespaceDetector;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWordDetector;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWordRule;
import org.eclipse.dltk.javascript.ui.scriptcolor.provider.IScriptColorProvider;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptCodeScanner
extends AbstractScriptScanner {
    private static String fgReturnKeyword = "return";
    private static String[] fgTokenProperties = new String[]{"DLTK_single_line_comment", "DLTK_default", "DLTK_keyword", "DLTK_keyword_return", "DLTK_number", "DLTK_function_definition"};
    private static IScriptColorProvider[] providers;

    static {
        JavascriptCodeScanner.initProviders();
    }

    public static IScriptColorProvider[] getScriptColorProviders() {
        return providers;
    }

    private static void initProviders() {
        IConfigurationElement[] configurationElements;
        ArrayList<IScriptColorProvider> providerList = new ArrayList<IScriptColorProvider>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.javascript.ui.keywordsprovider");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                Object provider = configurationElement.createExecutableExtension("class");
                if (provider instanceof IScriptColorProvider) {
                    providerList.add((IScriptColorProvider)provider);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        providers = providerList.toArray(new IScriptColorProvider[providerList.size()]);
    }

    public JavascriptCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        Token keyword = this.getToken("DLTK_keyword");
        Token keywordReturn = this.getToken("DLTK_keyword_return");
        Token other = this.getToken("DLTK_default");
        Token def = this.getToken("DLTK_function_definition");
        Token number = this.getToken("DLTK_number");
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new JavascriptWhitespaceDetector()));
        JavascriptWordRule wordRule = new JavascriptWordRule(new JavascriptWordDetector(), (IToken)other, null, (IToken)def);
        String[] stringArray = JavaScriptKeywords.getJavaScriptKeywords();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            wordRule.addWord(word, (IToken)keyword);
            ++n2;
        }
        wordRule.addWord(fgReturnKeyword, (IToken)keywordReturn);
        int i = 0;
        while (i < providers.length) {
            String[] keywords = providers[i].getKeywords();
            if (keywords != null) {
                String[] stringArray2 = keywords;
                int n3 = keywords.length;
                int n4 = 0;
                while (n4 < n3) {
                    String word = stringArray2[n4];
                    wordRule.addWord(word, providers[i].getToken(word));
                    ++n4;
                }
            }
            ++i;
        }
        rules.add(wordRule);
        rules.add(new FloatNumberRule((IToken)number));
        i = 0;
        while (i < providers.length) {
            IRule[] r = providers[i].getRules();
            if (r != null) {
                int j = 0;
                while (j < r.length) {
                    rules.add(r[j]);
                    ++j;
                }
            }
            ++i;
        }
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }
}

