/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeReferencePredicate
extends AbstractMatchingPredicate<MatchingNode> {
    public TypeReferencePredicate(TypeReferencePattern pattern) {
        super((SearchPattern)pattern, pattern.simpleName);
    }

    public MatchLevel match(MatchingNode node) {
        if (node instanceof MethodDeclarationNode) {
            MethodDeclarationNode mNode = (MethodDeclarationNode)node;
            MatchLevel level = this.matchType(mNode.method.getType());
            if (level != null) {
                return level;
            }
            for (IModelBuilder.IParameter parameter : mNode.method.getParameters()) {
                level = this.matchType(parameter.getType());
                if (level == null) continue;
                return level;
            }
        } else if (node instanceof FieldDeclarationNode) {
            FieldDeclarationNode fNode = (FieldDeclarationNode)node;
            return this.matchType(fNode.declaredType);
        }
        return null;
    }

    private MatchLevel matchType(Type type) {
        if (type == null) {
            return null;
        }
        return this.matchName(type.getName());
    }
}

